/*
 * Decompiled with CFR 0.152.
 */
package kid;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import kid.cluster.Comparison;
import kid.cluster.dimensions.BulletFirePower;
import kid.cluster.dimensions.DeltaHeading;
import kid.cluster.dimensions.DeltaVelocity;
import kid.cluster.dimensions.Distance;
import kid.cluster.dimensions.LateralVelocity;
import kid.cluster.dimensions.Velocity;
import kid.cluster.dimensions.WallDanger;
import kid.cluster.dimensions.WallDistance;
import kid.data.RobotChooser;
import kid.data.pattern.PatternMatcher;
import kid.data.pattern.Polar;
import kid.data.pattern.PolarFactory;
import kid.graphics.Colors;
import kid.graphics.DrawMenu;
import kid.graphics.RGraphics;
import kid.management.ProfileManager;
import kid.management.RobotManager;
import kid.management.TargetingManager;
import kid.movement.MovementProfiler;
import kid.movement.gun.GunMovement;
import kid.movement.radar.RadarMovement;
import kid.movement.robot.MinimumRiskPoint;
import kid.movement.robot.Movement;
import kid.movement.robot.Perpendicular;
import kid.robot.EnemyData;
import kid.targeting.CircularTargeting;
import kid.targeting.GuessFactorTargeting;
import kid.targeting.HeadOnTargeting;
import kid.targeting.LinearTargeting;
import kid.targeting.PatternMatchingTargeting;
import kid.targeting.Targeting;
import kid.utils.Utils;
import kid.virtual.VirtualGun;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Toa
extends AdvancedRobot {
    private Perpendicular oneonone;
    private Movement melee;
    private RadarMovement radar;
    private GunMovement gun;
    private RobotManager robots;
    private TargetingManager targeting;
    private MovementProfiler profile;
    private ProfileManager profiles;
    private static PatternMatcher<Polar> matcher = new PatternMatcher();
    private static long SKIPPED_TURNS = 0L;

    public void run() {
        this.setColors(Colors.DARK_RED, Colors.SILVER, Colors.DIRT_GREEN);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        Rectangle2D.Double field = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.profile = new MovementProfiler(this, new Comparison[]{new LateralVelocity(), new Distance(), new DeltaVelocity(), new BulletFirePower(), new WallDanger(field)}, 7);
        this.profiles = new ProfileManager(this, new Comparison[]{new LateralVelocity(), new Velocity(), new Distance(), new DeltaVelocity(), new DeltaHeading(), new BulletFirePower(), new WallDistance(field), new WallDanger(field)});
        matcher.start((Robot)this, new PolarFactory());
        Targeting[] targetings = new Targeting[]{new HeadOnTargeting((Robot)this), new LinearTargeting((Robot)this), new LinearTargeting((Robot)this, true), new CircularTargeting((Robot)this), new CircularTargeting((Robot)this, false, true), new CircularTargeting((Robot)this, true, false), new CircularTargeting((Robot)this, true, true), new PatternMatchingTargeting((Robot)this, matcher), new GuessFactorTargeting((Robot)this, this.profiles, 10), new GuessFactorTargeting((Robot)this, this.profiles, 30)};
        this.robots = new RobotManager((Robot)this);
        this.targeting = new TargetingManager(this, targetings);
        this.oneonone = new Perpendicular((Robot)this);
        this.melee = new MinimumRiskPoint((Robot)this);
        this.radar = new RadarMovement((Robot)this);
        this.gun = new GunMovement((Robot)this);
        while (true) {
            EnemyData enemy = this.robots.getEnemy(RobotChooser.CLOSEST);
            if (this.robots.getAliveEnemies().length == 1) {
                this.oneonone.move(enemy, this.profile);
            } else {
                this.melee.move(this.robots.getRobots());
            }
            this.setTurnRadarRight(Double.POSITIVE_INFINITY);
            if (this.getGunHeat() < 0.4 || this.getOthers() == 1) {
                this.radar.setSweep(enemy, 15.0);
            }
            double firepower = this.getFirePower(enemy);
            this.gun.setTurnTo(this.targeting.getBestGun(enemy).getTargeting(), enemy, firepower);
            if (this.shouldFire(enemy, firepower)) {
                Bullet b = this.targeting.fire(enemy, firepower);
                this.profiles.fire(enemy, b);
            }
            this.execute();
        }
    }

    private boolean shouldFire(EnemyData enemy, double firepower) {
        boolean fire;
        boolean bl = fire = !enemy.isDead() && firepower < this.getEnergy() && Math.abs(this.getGunTurnRemaining()) < 2.0;
        if (this.getOthers() > 1) {
            return fire;
        }
        return enemy.distSq(this.getX(), this.getY()) < 40000.0 || fire && (this.getEnergy() - firepower > enemy.getEnergy() || this.getEnergy() > 16.0);
    }

    private double getFirePower(EnemyData enemy) {
        double firepower = 3.0;
        if (this.getOthers() > 1) {
            firepower = 1200.0 / enemy.dist(this.getX(), this.getY());
        } else if (enemy.distSq(this.getX(), this.getY()) > 40000.0) {
            firepower = 800.0 / enemy.dist(this.getX(), this.getY());
            VirtualGun gun = this.targeting.getBestGun(enemy);
            if (gun.getRealHitRate() >= 0.12) {
                firepower *= gun.getHitRate() / 0.15;
            }
            if (this.getEnergy() < 32.0) {
                firepower *= Utils.limit(0.5, this.getEnergy() / enemy.getEnergy(), 2.0);
            }
        }
        firepower = Math.min(firepower, enemy.getEnergy() / 4.0);
        return Utils.limit(0.1, firepower, 3.0);
    }

    public void onPaint(Graphics2D graphics) {
        RGraphics grid = new RGraphics(graphics, (Robot)this);
        DrawMenu.draw(grid);
        this.robots.draw(grid);
        this.targeting.draw(grid);
        this.profiles.draw(grid);
        this.profile.draw(grid);
        matcher.draw(grid);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.robots.inEvent((Event)e);
        this.targeting.inEvent((Event)e);
        this.profiles.inEvent((Event)e);
        this.oneonone.inEvent((Event)e);
        this.profile.inEvent((Event)e);
        matcher.inEvent((Event)e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.robots.inEvent((Event)e);
        this.targeting.inEvent((Event)e);
        this.profiles.inEvent((Event)e);
        this.oneonone.inEvent((Event)e);
        matcher.inEvent((Event)e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.profile.inEvent((Event)e);
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.profile.inEvent((Event)e);
    }

    public void onWin(WinEvent e) {
        this.robots.inEvent((Event)e);
        this.profile.inEvent((Event)e);
        matcher.inEvent((Event)e);
    }

    public void onDeath(DeathEvent e) {
        this.robots.inEvent((Event)e);
        this.targeting.inEvent((Event)e);
        this.profiles.inEvent((Event)e);
        this.profile.inEvent((Event)e);
        matcher.inEvent((Event)e);
    }

    public void onMouseClicked(MouseEvent e) {
        DrawMenu.inMouseEvent(e);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.out.println("SKIPPED TURN! (Time: " + e.getTime() + ", Total: " + ++SKIPPED_TURNS + ")");
    }
}

