/*
 * Decompiled with CFR 0.152.
 */
package kid.data;

import java.util.Collection;
import kid.data.RobotChooser;
import kid.robot.EnemyData;
import kid.robot.RobotData;
import kid.robot.TeammateData;
import kid.utils.Utils;
import robocode.Robot;

public class Closest
extends RobotChooser {
    private static final double CLOSER_MARGEN = 0.9;

    @Override
    public RobotData getRobotOverride(Robot myRobot, Collection<RobotData> robots) {
        RobotData robot = this.lastRobot;
        double distSq = Utils.distSq(myRobot.getX(), myRobot.getY(), this.lastRobot.getX(), this.lastRobot.getY());
        for (RobotData r : robots) {
            double distTemp;
            if (r.isDead() || !((distTemp = Utils.distSq(myRobot.getX(), myRobot.getY(), r.getX(), r.getY())) < distSq * 0.9)) continue;
            robot = r;
            distSq = distTemp;
        }
        return robot;
    }

    @Override
    public EnemyData getEnemyOverride(Robot myRobot, Collection<EnemyData> enemys) {
        EnemyData enemy = this.lastEnemy;
        double distSq = Utils.distSq(myRobot.getX(), myRobot.getY(), this.lastEnemy.getX(), this.lastEnemy.getY());
        for (EnemyData e : enemys) {
            double distTemp;
            if (e.isDead() || !((distTemp = Utils.distSq(myRobot.getX(), myRobot.getY(), e.getX(), e.getY())) < distSq * 0.9)) continue;
            enemy = e;
            distSq = distTemp;
        }
        return enemy;
    }

    @Override
    public TeammateData getTeammateOverride(Robot myRobot, Collection<TeammateData> teammates) {
        TeammateData teammate = this.lastTeammate;
        double distSq = Utils.distSq(myRobot.getX(), myRobot.getY(), this.lastTeammate.getX(), this.lastTeammate.getY());
        for (TeammateData t : teammates) {
            double distTemp;
            if (t.isDead() || !((distTemp = Utils.distSq(myRobot.getX(), myRobot.getY(), t.getX(), t.getY())) < distSq * 0.9)) continue;
            teammate = t;
            distSq = distTemp;
        }
        return teammate;
    }
}

