/*
 * Decompiled with CFR 0.152.
 */
package kid.graphics;

import java.awt.event.MouseEvent;
import java.util.HashMap;
import kid.graphics.DrawMenu;
import kid.graphics.RGraphics;

public class Menu {
    private String name;
    private boolean open;
    private HashMap<String, Boolean> items;

    public Menu(String name) {
        this.init(name, null);
    }

    public Menu(String name, String[] items) {
        this.init(name, items);
    }

    private void init(String n, String[] i) {
        this.name = n;
        this.items = new HashMap();
        if (i != null) {
            String[] stringArray = i;
            int n2 = i.length;
            int n3 = 0;
            while (n3 < n2) {
                String s = stringArray[n3];
                this.items.put(s, false);
                ++n3;
            }
        }
    }

    public void add(String item) {
        this.add(item, false);
    }

    public void add(String item, boolean def) {
        if (!this.items.keySet().contains(item)) {
            this.items.put(item, def);
        }
    }

    public boolean getValue(String item) {
        return this.getValue(item, false);
    }

    public boolean getValue(String item, boolean def) {
        Boolean value = this.items.get(item);
        if (value != null) {
            return value;
        }
        this.add(item, def);
        return def;
    }

    public String getName() {
        return this.name;
    }

    public boolean status() {
        return this.open;
    }

    public void open() {
        this.open = true;
    }

    public void close() {
        this.open = false;
    }

    public boolean inMouseEvent(MouseEvent e, double startX, double startY) {
        boolean found = false;
        if (this.open && e.getID() == 500) {
            double x = (double)e.getX() - startX;
            double y = (double)e.getY() - startY;
            if (x <= 70.0 && x >= 0.0 && y >= 0.0) {
                int i = 0;
                while (i < this.items.keySet().size() && !found) {
                    if (y <= ((double)i + 1.0) * 13.0) {
                        String s;
                        this.items.put(s, this.items.get(s = (String)this.items.keySet().toArray()[i]) == false);
                        found = true;
                    }
                    ++i;
                }
            }
        }
        return found;
    }

    public void draw(RGraphics grid, double startX, double startY) {
        if (this.open) {
            Object[] keys = this.items.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                String s = (String)keys[i];
                grid.setColor(this.items.get(s) != false ? DrawMenu.ITEM_ON : DrawMenu.ITEM_OFF);
                grid.drawRect(startX, startY + (double)i * 13.0, 70.0, 12.0);
                grid.drawString(s, startX + 2.0, startY + 2.0 + (double)i * 13.0);
                ++i;
            }
        }
    }
}

