/*
 * Decompiled with CFR 0.152.
 */
package kid.virtual;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import kid.graphics.RGraphics;
import kid.utils.Utils;
import kid.virtual.VirtualObject;
import robocode.Bullet;
import robocode.RobocodeFileOutputStream;
import robocode.Rules;

public class VirtualBullet
extends VirtualObject {
    private static final long serialVersionUID = 8647867336085921279L;
    private static double MAX_X = 5000.0;
    private static double MAX_Y = 5000.0;
    private double startX;
    private double stratY;
    private double deltaX;
    private double deltaY;
    private double heading;
    private double velocity;
    private double firePower;
    private long creationTime;

    public VirtualBullet(double startX, double startY, double heading, double firePower, long creationTime) {
        this.init(startX, startY, heading, firePower, creationTime);
    }

    public VirtualBullet(Bullet bullet, long curTime) {
        this.init(bullet.getX(), bullet.getY(), bullet.getHeading(), bullet.getPower(), curTime);
    }

    private VirtualBullet(VirtualBullet bullet) {
        this.init(bullet.getStartX(), bullet.getStartY(), bullet.getHeading(), bullet.getFirePower(), bullet.getCreationTime());
    }

    private void init(double startX, double startY, double heading, double firePower, long creationTime) {
        this.startX = startX;
        this.stratY = startY;
        this.deltaX = Utils.getDeltaX(Rules.getBulletSpeed((double)firePower), heading);
        this.deltaY = Utils.getDeltaY(Rules.getBulletSpeed((double)firePower), heading);
        this.heading = Utils.relative(heading);
        this.velocity = Rules.getBulletSpeed((double)firePower);
        this.firePower = firePower;
        this.creationTime = creationTime;
    }

    protected double getStartX() {
        return this.startX;
    }

    protected double getDeltaX() {
        return this.deltaX;
    }

    protected double getStartY() {
        return this.stratY;
    }

    protected double getDeltaY() {
        return this.deltaY;
    }

    public double getX(long time) {
        return this.getStartX() + this.getDeltaX() * (double)(time - this.getCreationTime());
    }

    public double getY(long time) {
        return this.getStartY() + this.getDeltaY() * (double)(time - this.getCreationTime());
    }

    public double getHeading() {
        return this.heading;
    }

    public double getFirePower() {
        return this.firePower;
    }

    public double getVelocity() {
        return this.velocity;
    }

    protected long getCreationTime() {
        return this.creationTime;
    }

    protected double getDist(long time) {
        return this.getVelocity() * (double)(time - this.getCreationTime());
    }

    public double getDist(double x, double y, long time) {
        return Utils.sqr(this.getDistSq(x, y, time));
    }

    public double getDistSq(double x, double y, long time) {
        return Utils.distSq(x, y, this.getX(time), this.getY(time));
    }

    public double getDist(Point2D point, long time) {
        return Utils.sqr(this.getDistSq(point, time));
    }

    public double getDistSq(Point2D point, long time) {
        return Utils.distSq(point, this.getBulletPoint(time));
    }

    public Line2D getBulletLine(long time) {
        return new Line2D.Double(this.getX(time - 1L), this.getY(time - 1L), this.getX(time), this.getY(time));
    }

    public Point2D getBulletPoint(long time) {
        return new Point2D.Double(this.getX(time), this.getY(time));
    }

    public boolean testActive(long time) {
        double x = this.getX(time);
        double y = this.getY(time);
        return !(x < 0.0 || x > MAX_X || y < 0.0 || y > MAX_Y);
    }

    public boolean testHit(Rectangle2D robot, long time) {
        return robot.contains(this.getBulletPoint(time));
    }

    public boolean testMissed(Rectangle2D robot, long time) {
        return Utils.distSq(this.getStartX(), this.getStartY(), robot.getX(), robot.getY()) < Utils.sqr(this.getDist(time - 1L));
    }

    @Override
    public void print(PrintStream console) {
        console.println(this.toString());
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }

    @Override
    public void draw(RGraphics grid) {
        long time = grid.getTime();
        grid.drawLine(this.getX(time - 1L), this.getY(time - 1L), this.getX(time), this.getY(time));
    }

    public Object clone() {
        return new VirtualBullet(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualBullet) {
            VirtualBullet bullet = (VirtualBullet)obj;
            return bullet.getHeading() == this.getHeading() && bullet.getFirePower() == this.getFirePower();
        }
        return false;
    }

    public String toString() {
        return new String();
    }

    public void finalize() {
    }
}

