/*
 * Decompiled with CFR 0.152.
 */
package KiraNL;

import java.awt.Color;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class SpaceKees
extends AdvancedRobot {
    private long lastTime;
    private BotPosition myPos;
    private BotPosition enemyPos;
    private ArrayList<VirtualBullet> bullets = new ArrayList();
    private VirtualBullet newBullet;
    private VirtualBullet bullet;
    private double fireTime;
    private static String enemyHistory = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0002\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffe\ufffc\ufffa\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff9\ufffa\ufffb\ufffc\ufffd\ufffe\uffff\u0000\u0002\u0004\u0006\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\u0007\u0006\u0005\u0004\u0003\u0002\u0001\u0000";

    public void run() {
        this.myPos = new BotPosition();
        this.enemyPos = new BotPosition();
        this.enemyPos.energy = 100.0;
        this.setColors(Color.red, Color.black, Color.red.darker(), Color.red.darker(), Color.red.darker());
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            this.handleRadar(null);
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double changeInEnergy = this.enemyPos.energy - e.getEnergy();
        this.myPos.x = this.getX();
        this.myPos.y = this.getY();
        this.enemyPos.calculatePosition(this.myPos.x, this.myPos.y, absoluteBearing, e.getDistance());
        if (changeInEnergy > 0.0 && changeInEnergy <= 3.0) {
            double angle = Utils.normalRelativeAngle((double)(absoluteBearing + Math.PI + Math.asin(Math.sin(e.getBearingRadians()) * this.getVelocity() / SpaceKees.bulletVelocity(changeInEnergy))));
            this.enemyPos.energy = e.getEnergy();
            this.newBullet = new VirtualBullet(this.enemyPos.x, this.enemyPos.y, changeInEnergy, angle);
            this.bullets.add(this.newBullet);
            this.newBullet = new VirtualBullet(this.enemyPos.x, this.enemyPos.y, changeInEnergy, angle + 0.1);
            this.bullets.add(this.newBullet);
            this.newBullet = new VirtualBullet(this.enemyPos.x, this.enemyPos.y, changeInEnergy, angle - 0.1);
            this.bullets.add(this.newBullet);
        }
        double fPower = SpaceKees.limit(600.0 / e.getDistance(), 1.0, 3.0);
        this.handleGun(fPower, e);
        this.handleMovement(e);
        this.handleRadar(e);
        this.lastTime = this.getTime();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.enemyPos.calculateEnergyGain(e.getBullet().getPower());
    }

    public void onBulletHit(BulletHitEvent e) {
        this.enemyPos.calculateEnergyLoss(e.getBullet().getPower());
    }

    private void handleRadar(ScannedRobotEvent e) {
        try {
            if (e != null) {
                double radarTurn = 1.9 * Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians()));
                double extraTurn = Math.min(Math.atan(5.0 / e.getDistance()), 0.7853981633974483);
                this.setTurnRadarRightRadians(radarTurn + (radarTurn < 0.0 ? -extraTurn : extraTurn));
            } else if (this.getRadarTurnRemaining() == 0.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
        }
        catch (Exception ex) {
            this.out.println(ex.toString());
        }
    }

    private void handleMovement(ScannedRobotEvent e) {
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double xForce = 0.0;
        double yForce = 0.0;
        int i = 0;
        while (i < this.bullets.size()) {
            this.bullet = this.bullets.get(i);
            this.bullet.tick(this.getTime() - this.lastTime);
            this.bullets.set(i, this.bullet);
            if (this.bullets.get(i).checkCollide(this.myPos.x, this.myPos.y)) {
                this.bullets.remove(i--);
            } else {
                double absBearing = Utils.normalAbsoluteAngle((double)Math.atan2(this.bullet.x - this.getX(), this.bullet.y - this.getY()));
                double distance = this.bullet.getDistance(this.getX(), this.getY()) - this.bullet.power;
                int radius = (int)this.bullet.getDistance(this.enemyPos.x, this.enemyPos.y);
                if ((double)radius < this.enemyPos.getDistance(this.myPos.x, this.myPos.y)) {
                    xForce -= Math.sin(absBearing) / (distance * distance);
                    yForce -= Math.cos(absBearing) / (distance * distance);
                }
            }
            ++i;
        }
        xForce -= Math.sin(absoluteBearing) / (e.getDistance() * e.getDistance());
        yForce -= Math.cos(absoluteBearing) / (e.getDistance() * e.getDistance());
        xForce -= 5000.0 / Math.pow(this.calculateDistance(this.getX(), this.getY(), this.getBattleFieldWidth(), this.getY()), 3.0);
        xForce += 5000.0 / Math.pow(this.calculateDistance(this.getX(), this.getY(), 0.0, this.getY()), 3.0);
        yForce -= 5000.0 / Math.pow(this.calculateDistance(this.getX(), this.getY(), this.getX(), this.getBattleFieldHeight()), 3.0);
        double angle = Math.atan2(xForce, yForce += 5000.0 / Math.pow(this.calculateDistance(this.getX(), this.getY(), this.getX(), 0.0), 3.0));
        if (Math.abs(angle - this.getHeadingRadians()) < 1.5707963267948966) {
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)(angle - this.getHeadingRadians())));
            this.setAhead(Double.POSITIVE_INFINITY);
        } else {
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)(angle + Math.PI - this.getHeadingRadians())));
            this.setAhead(Double.NEGATIVE_INFINITY);
        }
    }

    private void handleGun(double bpower, ScannedRobotEvent e) {
        double dist;
        int i;
        int n;
        int matchPos;
        int matchLen = 30;
        double angle = e.getBearingRadians();
        if (this.fireTime == (double)this.getTime() && this.getGunTurnRemaining() == 0.0) {
            this.setFire(bpower);
        }
        enemyHistory = String.valueOf((char)Math.round(2.0 * (e.getVelocity() * Math.sin(e.getHeadingRadians() - (angle += this.getHeadingRadians()))))).concat(enemyHistory);
        do {
            n = matchLen--;
            dist = e.getDistance();
            i = (int)(dist / 12.5 - 1.0);
        } while ((matchPos = enemyHistory.indexOf(enemyHistory.substring(0, n), i)) < 0);
        do {
            angle += Math.asin((double)((short)enemyHistory.charAt(--matchPos)) / dist / 2.0);
        } while (--i > 0);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(angle - this.getGunHeadingRadians())));
        this.fireTime = this.getTime() + 1L;
    }

    private static double limit(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    private double calculateDistance(double x, double y, double x2, double y2) {
        double powx = x - x2;
        double powy = y - y2;
        return Math.sqrt(powx * powx + powy * powy);
    }

    public class BotPosition {
        public double energy;
        public double x;
        public double y;

        public void calculateEnergyGain(double power) {
            ((SpaceKees)SpaceKees.this).enemyPos.energy += 3.0 * power;
        }

        public void calculateEnergyLoss(double power) {
            ((SpaceKees)SpaceKees.this).enemyPos.energy -= 4.0 * power + Math.max(0.0, 2.0 * (power - 1.0));
        }

        public void calculatePosition(double x, double y, double absoluteBearing, double distance) {
            this.x = x + distance * Math.sin(absoluteBearing);
            this.y = y + distance * Math.cos(absoluteBearing);
        }

        public double getDistance(double x, double y) {
            return Math.sqrt(Math.pow(x - this.x, 2.0) + Math.pow(y - this.y, 2.0));
        }
    }

    public class VirtualBullet {
        public double x;
        public double y;
        public double power;
        public double speed;
        public double angle;

        VirtualBullet(double startX, double startY, double bpower, double trajectory) {
            this.x = startX;
            this.y = startY;
            this.power = bpower;
            this.speed = SpaceKees.bulletVelocity(bpower);
            this.angle = trajectory;
        }

        public void tick(long ticks) {
            this.x += (double)ticks * (Math.sin(this.angle) * this.speed);
            this.y += (double)ticks * (Math.cos(this.angle) * this.speed);
        }

        public double getDistance(double botX, double botY) {
            return Math.sqrt(Math.pow(botX - this.x, 2.0) + Math.pow(botY - this.y, 2.0));
        }

        public boolean checkCollide(double botX, double botY) {
            if (this.x < 0.0 || this.y < 0.0 || this.x > SpaceKees.this.getBattleFieldWidth() || this.y > SpaceKees.this.getBattleFieldHeight()) {
                return true;
            }
            return botX - 18.0 < this.x && botX + 18.0 > this.x && botY - 18.0 < this.y && botY + 18.0 > this.y;
        }
    }
}

