/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mue.Gun;
import mue.HitStatistic;
import mue.RobotData;
import mue.ScanWave;
import mue.StatisticWave;
import mue.StatisticWaveListener;
import mue.Util;
import mue.VirtualHitStatistic;
import robocode.AdvancedRobot;
import robocode.Bullet;

abstract class GunArrayBase
implements StatisticWaveListener {
    private static Map targetData;
    private Map guns;
    private Map bullets;
    private AdvancedRobot owner;
    private int[] distanceBuckets;

    public GunArrayBase(AdvancedRobot advancedRobot, int[] nArray) {
        this.owner = advancedRobot;
        this.distanceBuckets = nArray;
        if (targetData == null) {
            targetData = new HashMap(20);
        }
        this.guns = new HashMap(10);
        this.bullets = new HashMap(300);
    }

    public void addGun(Gun gun) {
        this.guns.put(gun.getName(), gun);
        TargetData.addGunData(gun.getName());
    }

    public void addGun(Gun gun, float f, float f2, float f3) {
        this.guns.put(gun.getName(), gun);
        TargetData.addGunData(gun.getName(), f, f2, f3);
    }

    private final TargetData getTargetData(String string) {
        TargetData targetData = (TargetData)GunArrayBase.targetData.get(string);
        if (targetData == null) {
            targetData = new TargetData(this.distanceBuckets);
            GunArrayBase.targetData.put(string, targetData);
        }
        return targetData;
    }

    protected final VirtualHitStatistic getVirtualStatistic(String string, String string2) {
        return this.getTargetData(string).getVirtualStatistic(string2);
    }

    protected final int getTotalNumberOfShots() {
        int n = 0;
        Iterator iterator = targetData.values().iterator();
        while (iterator.hasNext()) {
            n += ((TargetData)iterator.next()).getRealStatistic().shots();
        }
        return n;
    }

    protected final Set getGunNames() {
        return this.guns.keySet();
    }

    protected final Gun getGun(String string) {
        return (Gun)this.guns.get(string);
    }

    public void onScan(RobotData robotData) {
        Iterator iterator = this.guns.values().iterator();
        while (iterator.hasNext()) {
            ((Gun)iterator.next()).onScan(robotData);
        }
    }

    public void onBulletHit(Bullet bullet, String string) {
        BulletFireData bulletFireData = (BulletFireData)this.bullets.get(bullet);
        if (bulletFireData == null) {
            Util.addWarning("GunArrayBase.onBulletHit: No bullet data found for specified bullet.");
            return;
        }
        TargetData targetData = this.getTargetData(string);
        targetData.getRealStatistic(bulletFireData.getGun()).addHit(bulletFireData.getDistance(), bullet.getPower());
        targetData.getRealStatistic().addHit(bulletFireData.getDistance(), bullet.getPower());
    }

    public void addHit(String string, Gun gun, int n, double d) {
        VirtualHitStatistic virtualHitStatistic = this.getTargetData(string).getVirtualStatistic(gun.getName());
        if (virtualHitStatistic != null) {
            virtualHitStatistic.addHit(n, d);
        }
    }

    public void addMiss(String string, Gun gun, int n, double d) {
        VirtualHitStatistic virtualHitStatistic = this.getTargetData(string).getVirtualStatistic(gun.getName());
        if (virtualHitStatistic != null) {
            virtualHitStatistic.addMiss(n, d);
        }
    }

    protected StatisticWave prepareStatisticWave(RobotData robotData, double d) {
        StatisticWave statisticWave = new StatisticWave(this, this.owner, robotData, d);
        TargetData targetData = this.getTargetData(robotData.getName());
        Iterator iterator = this.guns.values().iterator();
        while (iterator.hasNext()) {
            Gun gun = (Gun)iterator.next();
            if (targetData.getVirtualStatistic(gun.getName()) == null) continue;
            statisticWave.addGun(gun, gun.getFireAngle(robotData, d));
        }
        return statisticWave;
    }

    protected ScanWave prepareScanWave(RobotData robotData, double d) {
        ScanWave scanWave = new ScanWave(this.owner, robotData, d);
        Iterator iterator = this.guns.values().iterator();
        while (iterator.hasNext()) {
            scanWave.addListener((Gun)iterator.next());
        }
        return scanWave;
    }

    protected double setTurnGun(double d) {
        double d2 = Util.relativeAngle(this.owner.getGunHeading(), d);
        this.owner.setTurnGunRight(d2);
        double d3 = this.owner.getTurnRemaining();
        double d4 = Math.abs(this.owner.getVelocity());
        if (d3 > 10.0 - 0.75 * d4) {
            d3 = 10.0 - 0.75 * d4;
        }
        if (d3 < -10.0 + 0.75 * d4) {
            d3 = -10.0 + 0.75 * d4;
        }
        d3 = d2 * d3 < 0.0 ? 20.0 - Math.abs(d3) : 20.0 + Math.abs(d3);
        if (Math.abs(d2) > d3) {
            return Math.abs(d2) - d3;
        }
        return 0.0;
    }

    protected Bullet setFire(double d, RobotData robotData, Gun gun, StatisticWave statisticWave) {
        Bullet bullet = this.owner.setFireBullet(d);
        if (bullet != null) {
            TargetData targetData = this.getTargetData(robotData.getName());
            int n = (int)Math.round(robotData.getDistance());
            targetData.getRealStatistic().addShot(n, bullet.getPower());
            targetData.getRealStatistic(gun.getName()).addShot(n, bullet.getPower());
            if (statisticWave != null) {
                statisticWave.fire();
            }
            this.bullets.put(bullet, new BulletFireData(n, gun.getName()));
        }
        return bullet;
    }

    protected final long getTime() {
        return this.owner.getTime();
    }

    protected final int getRound() {
        return this.owner.getRoundNum();
    }

    protected final double getEnergy() {
        return this.owner.getEnergy();
    }

    protected final double getPowerForDamage(double d) {
        double d2 = d / 4.0;
        if (d2 > 1.0) {
            d2 = (d + 2.0) / 6.0;
        }
        return d2;
    }

    protected final int getCoolingTime() {
        return (int)Math.round(Math.ceil(this.owner.getGunHeat() / this.owner.getGunCoolingRate()));
    }

    public abstract void doGun(RobotData var1);

    public String evaluate() {
        StringBuffer stringBuffer = new StringBuffer(2000);
        Iterator iterator = targetData.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("vs. ").append(string).append("\n");
            stringBuffer.append(this.evaluate(string)).append("\n");
        }
        return stringBuffer.toString();
    }

    public String evaluate(String string) {
        return this.getTargetData(string).evaluate();
    }

    private static final class TargetData {
        private static Map gunData = null;
        private HitStatistic realStatistic;
        private Map gunRealStatistic;
        private Map gunVirtualStatistic;
        private int[] distanceBuckets;

        public TargetData(int[] nArray) {
            this.distanceBuckets = nArray;
            this.realStatistic = new HitStatistic(this.distanceBuckets);
            this.gunRealStatistic = new HashMap(10);
            this.gunVirtualStatistic = new HashMap(10);
        }

        public static void addGunData(String string) {
            if (gunData == null) {
                gunData = new HashMap(10);
            }
            gunData.put(string, null);
        }

        public static void addGunData(String string, float f, float f2, float f3) {
            if (gunData == null) {
                gunData = new HashMap(10);
            }
            gunData.put(string, new GunData(f, f2, f3));
        }

        public HitStatistic getRealStatistic() {
            return this.realStatistic;
        }

        public HitStatistic getRealStatistic(String string) {
            HitStatistic hitStatistic = (HitStatistic)this.gunRealStatistic.get(string);
            if (hitStatistic == null) {
                hitStatistic = new HitStatistic(this.distanceBuckets);
                this.gunRealStatistic.put(string, hitStatistic);
            }
            return hitStatistic;
        }

        public VirtualHitStatistic getVirtualStatistic(String string) {
            GunData gunData;
            VirtualHitStatistic virtualHitStatistic = (VirtualHitStatistic)this.gunVirtualStatistic.get(string);
            if (virtualHitStatistic == null && (gunData = (GunData)TargetData.gunData.get(string)) != null) {
                virtualHitStatistic = new VirtualHitStatistic(this.distanceBuckets, gunData.getInitialValue(), gunData.getHitRollingFactor(), gunData.getMissRollingFactor());
                this.gunVirtualStatistic.put(string, virtualHitStatistic);
            }
            return virtualHitStatistic;
        }

        public String evaluate() {
            String string;
            StringBuffer stringBuffer = new StringBuffer("overall hit statistic:\n");
            stringBuffer.append(this.realStatistic.evaluate());
            stringBuffer.append("\nreal hit statistics: \n");
            Iterator iterator = this.gunRealStatistic.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                HitStatistic hitStatistic = (HitStatistic)this.gunRealStatistic.get(string);
                stringBuffer.append(string).append(": \n").append(hitStatistic.evaluate());
            }
            stringBuffer.append("\nvirtual hit statistics:\n");
            iterator = this.gunVirtualStatistic.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                VirtualHitStatistic virtualHitStatistic = (VirtualHitStatistic)this.gunVirtualStatistic.get(string);
                stringBuffer.append(string).append(": \n").append(virtualHitStatistic.evaluate());
            }
            return stringBuffer.toString();
        }
    }

    private static final class GunData {
        private float initialValue;
        private float hitRollingFactor;
        private float missRollingFactor;

        public GunData(float f, float f2, float f3) {
            this.initialValue = f;
            this.hitRollingFactor = f2;
            this.missRollingFactor = f3;
        }

        public float getInitialValue() {
            return this.initialValue;
        }

        public float getHitRollingFactor() {
            return this.hitRollingFactor;
        }

        public float getMissRollingFactor() {
            return this.missRollingFactor;
        }
    }

    protected static final class BulletFireData {
        private int distance;
        private String gun;

        public BulletFireData(int n, String string) {
            this.distance = n;
            this.gun = string;
        }

        public String getGun() {
            return this.gun;
        }

        public int getDistance() {
            return this.distance;
        }
    }
}

