/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import mue.FireSnapshot;
import mue.RobotData;
import mue.ScanWaveListener;
import mue.Util;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.Robot;

final class ScanWave
extends Condition {
    private RobotData target;
    private AdvancedRobot robot;
    private FireSnapshot fireSnapshot;
    private Set listeners;
    private boolean real;
    private double speed;

    public ScanWave(AdvancedRobot advancedRobot, RobotData robotData, double d) {
        super("ScanWave");
        this.robot = advancedRobot;
        this.target = robotData;
        this.fireSnapshot = new FireSnapshot(this.target, d);
        this.speed = 20.0 - 3.0 * d;
        this.listeners = new HashSet(10);
    }

    public void fire(boolean bl) {
        this.real = bl;
        this.fireSnapshot.setRobot((Robot)this.robot);
        this.robot.addCustomEvent((Condition)this);
    }

    public void addListener(ScanWaveListener scanWaveListener) {
        this.listeners.add(scanWaveListener);
    }

    public void removeListener(ScanWaveListener scanWaveListener) {
        this.listeners.remove(scanWaveListener);
    }

    public RobotData getTarget() {
        return this.target;
    }

    public double getPower() {
        return this.fireSnapshot.getPower();
    }

    public boolean test() {
        if (!this.target.isAlive() && this.target.getTime() < this.robot.getTime() - 1L) {
            this.robot.removeCustomEvent((Condition)this);
            return false;
        }
        if ((double)(this.target.getTime() - this.fireSnapshot.getTime() + 1L) * this.speed < Util.distance(this.fireSnapshot.getOriginX(), this.fireSnapshot.getOriginY(), this.target.getX(), this.target.getY()) - 18.0) {
            return false;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ScanWaveListener scanWaveListener = (ScanWaveListener)iterator.next();
            scanWaveListener.onScanWave(this.target.getName(), this.fireSnapshot, this.target.getX(), this.target.getY(), this.real);
        }
        this.robot.removeCustomEvent((Condition)this);
        return false;
    }
}

