/*
 * Decompiled with CFR 0.152.
 */
package TCMI;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Enyo
extends AdvancedRobot {
    public static int BINS = 47;
    public static double[][] _surfStats = new double[16][BINS];
    public Point2D.Double _myLocation;
    public Point2D.Double _enemyLocation;
    public double _myLateralVelocity;
    public double _enemyLateralVelocity;
    public Point2D.Double _lastGoToPoint;
    public double direction = 1.0;
    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;
    public boolean hasLoadedStats = false;
    public static double _oppEnergy = 100.0;
    public static Rectangle2D.Double _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    public static double WALL_STICK = 160.0;
    double oldEnemyHeading;
    double oldEnemyX;
    double oldEnemyY;
    double[] pX = new double[256];
    double[] pY = new double[256];
    int numP;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this._enemyWaves = new ArrayList();
        this._surfDirections = new ArrayList();
        this._surfAbsBearings = new ArrayList();
        this.out.println("Reading surfstats from file...");
        boolean readFail = false;
        this.hasLoadedStats = false;
        if (!readFail) {
            this.out.println("Success!");
        }
        this.setColors(new Color(0, 0, 0), new Color(96, 96, 127), new Color(127, 127, 192), new Color(192, 192, 255), new Color(96, 96, 127));
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this._myLocation = new Point2D.Double(this.getX(), this.getY());
        this._myLateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        double angleToEnemy = this.getHeadingRadians() + e.getBearingRadians();
        double radarTurn = Utils.normalRelativeAngle((double)(angleToEnemy - this.getRadarHeadingRadians()));
        double extraTurn = Math.min(Math.atan(15.0 / e.getDistance()), Rules.RADAR_TURN_RATE_RADIANS);
        this.setTurnRadarRightRadians(radarTurn += radarTurn < 0.0 ? -extraTurn : extraTurn);
        double bulletPower = Math.min(1.72, this.getEnergy());
        double myX = this.getX();
        double myY = this.getY();
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyX = this.getX() + e.getDistance() * Math.sin(absoluteBearing);
        double enemyY = this.getY() + e.getDistance() * Math.cos(absoluteBearing);
        double enemyHeading = e.getHeadingRadians();
        double enemyHeadingChange = enemyHeading - this.oldEnemyHeading;
        double enemyVelocity = e.getVelocity();
        this.oldEnemyHeading = enemyHeading;
        this.oldEnemyX = enemyX;
        this.oldEnemyY = enemyY;
        double deltaTime = 0.0;
        double battleFieldHeight = this.getBattleFieldHeight();
        double battleFieldWidth = this.getBattleFieldWidth();
        double predictedX = enemyX;
        double predictedY = enemyY;
        this.numP = 0;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
            ++this.numP;
            this.pX[this.numP] = predictedX += Math.sin(enemyHeading) * enemyVelocity;
            this.pY[this.numP] = predictedY += Math.cos(enemyHeading) * enemyVelocity;
            enemyHeading += enemyHeadingChange;
            if (!(predictedX < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
        if (this.setFireBullet(1.72) != null) {
            this.out.println("Fired a bullet at " + e.getName() + ".");
        }
        this._surfDirections.add(0, new Integer(this._myLateralVelocity >= 0.0 ? 1 : -1));
        this._surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this._surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = Enyo.bulletVelocity(bulletPower);
            ew.distanceTraveled = Enyo.bulletVelocity(bulletPower);
            ew.direction = (Integer)this._surfDirections.get(2);
            ew.directAngle = (Double)this._surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._enemyLocation.clone();
            ew.lateralVelocity = this._myLateralVelocity;
            this._enemyWaves.add(ew);
        }
        _oppEnergy = e.getEnergy();
        this._enemyLocation = Enyo.project(this._myLocation, absBearing, e.getDistance());
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this._myLocation.distance(ew.fireLocation) + 50.0) {
                this._enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
        this.doSurfing();
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = Enyo.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / Enyo.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)Enyo.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = Enyo.getFactorIndex(ew, targetLocation);
        int index2 = Math.abs((int)(ew.lateralVelocity * 2.0));
        int y = 0;
        while (y < 16) {
            int x = 0;
            while (x < BINS) {
                double[] dArray = _surfStats[y];
                int n = x;
                dArray[n] = dArray[n] + 1.0 / ((Math.pow(index - x, 2.0) + 1.0 + (Math.pow(index2 - y, 2.0) + 1.0)) / 2.0);
                ++x;
            }
            ++y;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.out.println("Was hit by bullet!");
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) < 50.0 && Math.abs(Enyo.bulletVelocity(e.getBullet().getPower()) - ew.bulletVelocity) < 0.001) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        this.out.println("Bullet hit an enemy!");
    }

    public ArrayList predictPositions(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        ArrayList<Point2D.Double> traveledPoints = new ArrayList<Point2D.Double>();
        int counter = 0;
        boolean intercepted = false;
        do {
            double distance = predictedPosition.distance(surfWave.fireLocation);
            double offset = 0.5707963267948966 + distance / 400.0;
            double moveAngle = this.wallSmoothing(predictedPosition, Enyo.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * offset, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + Enyo.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = Enyo.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = Enyo.project(predictedPosition, predictedHeading, predictedVelocity);
            traveledPoints.add(predictedPosition);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) - 20.0 < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        if (traveledPoints.size() > 1) {
            traveledPoints.remove(traveledPoints.size() - 1);
        }
        return traveledPoints;
    }

    public double checkDanger(EnemyWave surfWave, Point2D.Double position) {
        int index = Enyo.getFactorIndex(surfWave, position);
        int index2 = Math.abs((int)(surfWave.lateralVelocity * 2.0));
        double distance = position.distance(surfWave.fireLocation);
        return _surfStats[index2][index] / distance;
    }

    public Point2D.Double getBestPoint(EnemyWave surfWave) {
        if (surfWave.safePoints == null) {
            int minDangerIndex;
            ArrayList bestPoints;
            double thisDanger;
            ArrayList forwardPoints = this.predictPositions(surfWave, 1);
            ArrayList reversePoints = this.predictPositions(surfWave, -1);
            int FminDangerIndex = 0;
            int RminDangerIndex = 0;
            double FminDanger = Double.POSITIVE_INFINITY;
            double RminDanger = Double.POSITIVE_INFINITY;
            int i = 0;
            int k = forwardPoints.size();
            while (i < k) {
                thisDanger = this.checkDanger(surfWave, (Point2D.Double)forwardPoints.get(i));
                if (thisDanger <= FminDanger) {
                    FminDangerIndex = i;
                    FminDanger = thisDanger;
                }
                ++i;
            }
            i = 0;
            k = reversePoints.size();
            while (i < k) {
                thisDanger = this.checkDanger(surfWave, (Point2D.Double)reversePoints.get(i));
                if (thisDanger <= RminDanger) {
                    RminDangerIndex = i;
                    RminDanger = thisDanger;
                }
                ++i;
            }
            if (FminDanger < RminDanger) {
                bestPoints = forwardPoints;
                minDangerIndex = FminDangerIndex;
            } else {
                bestPoints = reversePoints;
                minDangerIndex = RminDangerIndex;
            }
            Point2D.Double bestPoint = (Point2D.Double)bestPoints.get(minDangerIndex);
            while (bestPoints.indexOf(bestPoint) != -1) {
                bestPoints.remove(bestPoints.size() - 1);
            }
            bestPoints.add(bestPoint);
            surfWave.safePoints = bestPoints;
            bestPoints.add(0, new Point2D.Double(this.getX(), this.getY()));
        } else if (surfWave.safePoints.size() > 1) {
            surfWave.safePoints.remove(0);
        }
        if (surfWave.safePoints.size() >= 1) {
            int i = 0;
            int k = surfWave.safePoints.size();
            while (i < k) {
                Point2D.Double goToPoint = (Point2D.Double)surfWave.safePoints.get(i);
                if (goToPoint.distanceSq(this._myLocation) > 440.00000000000006) {
                    return goToPoint;
                }
                ++i;
            }
            return (Point2D.Double)surfWave.safePoints.get(surfWave.safePoints.size() - 1);
        }
        return null;
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        double distance = this._enemyLocation.distance(this._myLocation);
        if (surfWave == null || distance < 50.0) {
            double v2;
            double absBearing = Enyo.absoluteBearing(this._myLocation, this._enemyLocation);
            double headingRadians = this.getHeadingRadians();
            double stick = 160.0;
            double offset = 2.5707963267948966 - distance / 400.0;
            while (!_fieldRect.contains(Enyo.project(this._myLocation, v2 = absBearing + this.direction * (offset -= 0.02), stick))) {
            }
            if (offset < 1.0471975511965976) {
                this.direction = -this.direction;
            }
            this.setAhead(50.0 * Math.cos(v2 - headingRadians));
            this.setTurnRightRadians(Math.tan(v2 - headingRadians));
        } else {
            this.goTo(this.getBestPoint(surfWave));
        }
    }

    private void goTo(Point2D.Double destination) {
        if (destination == null) {
            if (this._lastGoToPoint != null) {
                destination = this._lastGoToPoint;
            } else {
                return;
            }
        }
        this._lastGoToPoint = destination;
        Point2D.Double location = new Point2D.Double(this.getX(), this.getY());
        double distance = location.distance(destination);
        double angle = Utils.normalRelativeAngle((double)(Enyo.absoluteBearing(location, destination) - this.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            distance = -distance;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.setTurnRightRadians(angle * (double)Math.signum(Math.abs((int)distance)));
        this.setAhead(distance);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(Enyo.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public void onRoundEnded(RoundEndedEvent r) {
        block10: {
            PrintStream w = null;
            this.out.println("Saving _surfStats to file.");
            try {
                try {
                    w = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile("_surfStats.dat")));
                    int j = 0;
                    while (j < 16) {
                        int i = 0;
                        while (i < BINS) {
                            w.println(_surfStats[j][i] % 8.0);
                            ++i;
                        }
                        ++j;
                    }
                    if (w.checkError()) {
                        this.out.println("Error writing file!");
                        break block10;
                    }
                    this.out.println("Success!");
                }
                catch (IOException e) {
                    this.out.println("IOException trying to write: ");
                    e.printStackTrace(this.out);
                    if (w != null) {
                        w.close();
                    }
                }
            }
            finally {
                if (w != null) {
                    w.close();
                }
            }
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(new Color(0, 127, 255));
        int i = 0;
        while (i < this._enemyWaves.size()) {
            EnemyWave w = (EnemyWave)this._enemyWaves.get(i);
            int radius = (int)w.distanceTraveled;
            Point2D.Double center = w.fireLocation;
            if ((double)(radius - 40) < center.distance(this._myLocation)) {
                g.drawOval((int)(center.x - (double)radius), (int)(center.y - (double)radius), radius * 2, radius * 2);
            }
            ++i;
        }
        Point2D.Double bestPoint = this.getBestPoint(this.getClosestSurfableWave());
        g.drawLine((int)this.getX(), (int)this.getY(), (int)bestPoint.x, (int)bestPoint.y);
        g.drawLine((int)bestPoint.x + 5, (int)bestPoint.y + 5, (int)bestPoint.x - 5, (int)bestPoint.y - 5);
        g.drawLine((int)bestPoint.x - 5, (int)bestPoint.y + 5, (int)bestPoint.x + 5, (int)bestPoint.y - 5);
        g.setColor(new Color(255, 0, 0, 127));
        int i2 = 1;
        while (i2 < this.numP) {
            g.drawLine((int)this.pX[i2], (int)this.pY[i2], (int)this.pX[i2 + 1], (int)this.pY[i2 + 1]);
            ++i2;
        }
        g.drawLine((int)this.pX[this.numP] + 5, (int)this.pY[this.numP] + 5, (int)this.pX[this.numP] - 5, (int)this.pY[this.numP] - 5);
        g.drawLine((int)this.pX[this.numP] - 5, (int)this.pY[this.numP] + 5, (int)this.pX[this.numP] + 5, (int)this.pY[this.numP] - 5);
        g.setColor(new Color(0, 0, 255, 127));
        g.drawLine((int)this.getX(), (int)this.getY(), (int)this.pX[this.numP], (int)this.pY[this.numP]);
        g.setColor(new Color(0, 255, 0, 255));
        g.draw(new Ellipse2D.Double(this.pX[1] - 20.0, this.pY[1] - 20.0, 40.0, 40.0));
        g.drawLine((int)this.getX(), (int)this.getY(), (int)this.pX[1], (int)this.pY[1]);
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        double lateralVelocity;
        int direction;
        ArrayList safePoints;
    }
}

