/*
 * Decompiled with CFR 0.152.
 */
package apollokidd;

import apollokidd.Enemy;
import apollokidd.PositionManager;
import apollokidd.Strategy;
import apollokidd.Utility;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public final class ApolloKidd
extends AdvancedRobot {
    boolean isWar = true;
    boolean isDebug = true;
    ArrayList bullets = new ArrayList();
    Hashtable enemies = new Hashtable();
    Strategy strategy;
    Enemy target;
    PositionManager pos;

    public final void run() {
        this.target = new Enemy();
        this.strategy = new Strategy(this);
        this.pos = new PositionManager(this);
        this.target.setDistance(100000.0);
        this.setColors(new Color(0, 128, 0), new Color(50, 186, 50), Color.green);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Math.PI * 2);
        this.console("--------- APOLLO KIDD'S CONSOLE --------");
        this.console("");
        while (this.isWar) {
            this.doMovement();
            this.doFirePower();
            this.doScanner();
            this.doGun();
            this.doFire();
            this.execute();
        }
    }

    final void doMovement() {
        this.strategy.moveBot();
        if (!this.pos.checkPosition()) {
            this.strategy.tooClose();
        }
    }

    final void doFirePower() {
        this.strategy.firePower();
    }

    final void doFire() {
        Bullet bullet = this.strategy.fire();
        if (bullet != null) {
            this.bullets.add(bullet);
        }
    }

    final void doScanner() {
        this.strategy.scanning();
    }

    final void doGun() {
        this.strategy.setGun();
    }

    public final void onScannedRobot(ScannedRobotEvent e) {
        if (e.getDistance() < this.target.getDistance() || this.target.getName().compareTo(e.getName()) == 0) {
            double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
            this.target.setName(e.getName());
            this.target.setX(this.getX() + Math.sin(absbearing_rad) * e.getDistance());
            this.target.setY(this.getY() + Math.cos(absbearing_rad) * e.getDistance());
            this.target.setBearing(e.getBearingRadians());
            this.target.setHeading(e.getHeadingRadians());
            this.target.setTime(this.getTime());
            this.target.setSpeed(e.getVelocity());
            this.target.setDistance(e.getDistance());
            this.target.setEnergy(e.getEnergy());
            this.enemies.put(this.target.getName(), this.target);
        }
    }

    public final void onHitWall(HitWallEvent e) {
    }

    public final void onRobotDeath(RobotDeathEvent e) {
        if (e.getName().compareTo(this.target.getName()) == 0) {
            this.target.setDistance(100000.0);
        }
        this.enemies.remove(e.getName());
    }

    public final void onDeath(DeathEvent e) {
        this.seeStats();
    }

    public final void finalDance() {
        this.isWar = false;
        this.setStop();
        double x = this.getX();
        double y = this.getY();
        double ringCentreX = this.getBattleFieldWidth() / 2.0 - this.getHeight() / 2.0;
        double ringCentreY = this.getBattleFieldHeight() / 2.0;
        double abs_bearing = Utility.NormaliseHeading(Utility.absbearing(x, y, ringCentreX, ringCentreY));
        this.turnLeftRadians(this.getHeadingRadians());
        this.turnRadarLeft(this.getRadarHeading());
        this.turnGunLeft(this.getGunHeading());
        this.setAdjustGunForRobotTurn(false);
        this.setAdjustRadarForGunTurn(false);
        if (abs_bearing < Math.PI) {
            this.turnRightRadians(abs_bearing);
        } else {
            this.turnLeftRadians(Math.PI * 2 - abs_bearing);
        }
        this.ahead(Utility.getrange(x, y, ringCentreX, ringCentreY));
        if (this.getHeadingRadians() < Math.PI) {
            this.turnLeftRadians(this.getHeadingRadians());
        } else {
            this.turnRightRadians(Math.PI * 2 - this.getHeadingRadians());
        }
    }

    public final void onBulletHit() {
    }

    public final void onBulletMissed(BulletMissedEvent e) {
    }

    public final void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public final void onWin(WinEvent event) {
        this.seeStats();
        this.finalDance();
    }

    public final void seeStats() {
        double missedBullet = 0.0;
        double randomBullet = 0.0;
        double hittedBullet = 0.0;
        double totalBullet = this.bullets.size();
        double lostEnergy = 0.0;
        double gainedEnergy = 0.0;
        double minimumPower = 100.0;
        double maximumPower = 0.0;
        int i = 0;
        while ((double)i < totalBullet) {
            Bullet currentBullet = (Bullet)this.bullets.get(i);
            if (currentBullet != null) {
                lostEnergy += currentBullet.getPower();
                minimumPower = Math.min(currentBullet.getPower(), minimumPower);
                maximumPower = Math.max(currentBullet.getPower(), maximumPower);
                if (currentBullet.getVictim() == null) {
                    missedBullet += 1.0;
                } else {
                    gainedEnergy += 4.0 * currentBullet.getPower() + (currentBullet.getPower() > 1.0 ? 2.0 * currentBullet.getPower() - 1.0 : 0.0);
                    hittedBullet += 1.0;
                }
            }
            ++i;
        }
        this.console("FIRED BULLET: " + Math.round(totalBullet));
        this.console("BULLET TO TARGET: " + Math.round(hittedBullet));
        this.console("MISSED BULLET: " + Math.round(missedBullet));
        this.console("HIT RATE: " + Math.round(hittedBullet / totalBullet * 100.0) + "%");
        this.console("ENERGY GAINED: " + Math.round(gainedEnergy));
        this.console("ENERGY LOST: " + Math.round(lostEnergy));
        this.console("MEDIUM BULLET POWER: " + lostEnergy / totalBullet);
        this.console("MIN: " + minimumPower + " - MAX: " + maximumPower);
    }

    public final Enemy getTarget() {
        return this.target;
    }

    private final void console(String text) {
        if (this.isDebug) {
            System.out.println(text);
        }
    }
}

