/*
 * Decompiled with CFR 0.152.
 */
package Grystrion;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.TurnCompleteCondition;
import robocode.util.Utils;

public class RandomTrackerNOREV
extends AdvancedRobot {
    boolean movingForward;

    public void run() {
        this.setBodyColor(new Color(200, 0, 0));
        this.setGunColor(new Color(200, 0, 0));
        this.setRadarColor(new Color(0, 150, 150));
        this.setBulletColor(new Color(200, 0, 0));
        this.setScanColor(new Color(0, 200, 200));
        while (true) {
            this.setAhead(40000.0);
            this.movingForward = true;
            this.setTurnRight(70.0 + Math.random() * 40.0);
            int i = 0;
            while (i < 45) {
                this.turnGunRight(8.0);
                ++i;
            }
            this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
            this.setTurnLeft(150.0 + Math.random() * 60.0);
            this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
            this.setTurnRight(150.0 + Math.random() * 60.0);
            this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.reverseDirection();
    }

    public void reverseDirection() {
        if (this.movingForward) {
            this.setBack(40000.0);
            this.movingForward = false;
        } else {
            this.setAhead(40000.0);
            this.movingForward = true;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double bulletPower = Math.min(3.0, this.getEnergy());
        double myX = this.getX();
        double myY = this.getY();
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double enemyX = this.getX() + e.getDistance() * Math.sin(absoluteBearing);
        double enemyY = this.getY() + e.getDistance() * Math.cos(absoluteBearing);
        double enemyHeading = e.getHeadingRadians();
        double enemyVelocity = e.getVelocity();
        double deltaTime = 0.0;
        double battleFieldHeight = this.getBattleFieldHeight();
        double battleFieldWidth = this.getBattleFieldWidth();
        double predictedX = enemyX;
        double predictedY = enemyY;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
        this.fire(bulletPower);
    }

    public void onHitRobot(HitRobotEvent e) {
        if (e.isMyFault()) {
            this.reverseDirection();
        }
    }
}

