/*
 * Decompiled with CFR 0.152.
 */
package synnalagma;

import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Iterator;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import synnalagma.BulletTracker;
import synnalagma.DodgeBullet;
import synnalagma.EnnemiBullets;
import synnalagma.EnnemiShoot;
import synnalagma.Point;
import synnalagma.RobotBase;
import synnalagma.RobotMath;
import synnalagma.Statistique;
import synnalagma.shooting.ShootManager;

public class Ennemi
extends Point {
    public double velocity;
    public double cgtVelocity = 0.0;
    public long time;
    public long diff = 0L;
    public double heading;
    public double cgtHeading = 0.0;
    public ShootManager sm;
    private String name;
    private double changehead = 0.0;
    private double Mvelocity;
    private double energie = 0.0;
    private int timeFired = 0;
    private int timeHit = 0;
    double totalShoot = 0.0;
    EnnemiShoot es;
    public boolean alive = true;
    public static final int HISTORY = 7;
    public int currentI = 0;
    public float[] headCgtHist = new float[7];
    public float[] accelHist = new float[7];
    public int bullet = 0;
    public Statistique allStat;
    public double[] shoot = new double[3];
    private Rectangle2D.Double box = new Rectangle2D.Double();

    public Ennemi(ScannedRobotEvent scannedRobotEvent) {
        super(0.0, 0.0, -1000.0);
        this.name = scannedRobotEvent.getName();
        this.allStat = new Statistique();
        this.actualise(scannedRobotEvent);
        this.sm = new ShootManager(this);
        this.shoot[0] = 0.15;
        this.shoot[1] = 0.15;
        this.shoot[2] = 0.15;
        this.es = new EnnemiShoot(this);
    }

    public boolean isAlive() {
        return this.alive;
    }

    public double setEnergie(double d) {
        double d2 = this.energie - d;
        this.energie = d;
        return d2;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUpdated() {
        return this.diff < 8L && this.time < RobotBase.monRobot.getTime();
    }

    public void actualise(ScannedRobotEvent scannedRobotEvent) {
        double d = RobotMath.absoluteAngleRadians(scannedRobotEvent.getBearingRadians(), RobotBase.monRobot.getHeadingRadians());
        this.x = Math.cos(1.5707963267948966 - d) * scannedRobotEvent.getDistance() + RobotBase.monRobot.getX();
        this.y = Math.sin(1.5707963267948966 - d) * scannedRobotEvent.getDistance() + RobotBase.monRobot.getY();
        this.diff = scannedRobotEvent.getTime() - this.time;
        if (this.time > scannedRobotEvent.getTime()) {
            this.diff = 0L;
        }
        this.time = scannedRobotEvent.getTime();
        this.cgtVelocity = scannedRobotEvent.getVelocity() - this.velocity;
        this.cgtHeading = RobotMath.NormaliseBearing(scannedRobotEvent.getHeadingRadians() - this.heading);
        this.accelHist[this.currentI] = (float)this.cgtVelocity;
        this.headCgtHist[this.currentI] = (float)this.cgtHeading;
        ++this.currentI;
        if (this.currentI == 7) {
            this.currentI = 0;
        }
        this.velocity = scannedRobotEvent.getVelocity();
        this.heading = scannedRobotEvent.getHeadingRadians();
        this.box.setFrameFromCenter(this.x, this.y, this.x - 18.0, this.y - 18.0);
        this.Mvelocity = (3.0 * this.velocity + scannedRobotEvent.getVelocity()) / 4.0;
        double d2 = this.setEnergie(scannedRobotEvent.getEnergy());
        if (d2 > 0.0 && d2 <= 3.0) {
            this.firingBullet(d2);
        }
    }

    public static double hitDamage(double d) {
        double d2 = 4.0 * d;
        if (d > 1.0) {
            d2 += 2.0 * (d - 1.0);
        }
        return d2;
    }

    public void bulletEvent(BulletTracker bulletTracker) {
        --this.bullet;
        this.sm.update(bulletTracker);
        if (bulletTracker.getHit()) {
            ++this.timeHit;
            double d = Ennemi.hitDamage(bulletTracker.getBullet().getPower());
            this.allStat.hitHim += d;
            this.allStat.gain += bulletTracker.getBullet().getPower() * 3.0;
            this.force += d;
        }
    }

    public void died() {
        this.energie = 0.0;
        this.alive = false;
    }

    public void shoot() {
        ++this.bullet;
        this.sm.shoot();
    }

    public String toString() {
        return this.name + "  " + this.allStat.toString() + "\nForce : " + this.getForce() + "\nShoot :\n" + this.sm.toString() + "\nProbabilite de Neural " + this.shoot[1] + " Probabilite de lineaire " + this.shoot[0] + " Incompris " + this.shoot[2];
    }

    public void touche(HitByBulletEvent hitByBulletEvent) {
        double d = Ennemi.hitDamage(hitByBulletEvent.getPower());
        this.totalShoot += 1.0;
        this.allStat.hitMe += d;
        this.force -= d;
        Iterator iterator = EnnemiBullets.getInstance().getAll().iterator();
        boolean bl = false;
        boolean bl2 = true;
        double d2 = Double.MAX_VALUE;
        int n = -1;
        while (iterator.hasNext()) {
            double d3;
            DodgeBullet dodgeBullet = (DodgeBullet)iterator.next();
            if (!(dodgeBullet.getForce() - hitByBulletEvent.getPower() < 0.1) || !dodgeBullet.name.equalsIgnoreCase(this.name)) continue;
            if (dodgeBullet.tech == 1) {
                EnnemiShoot.Shot shot = (EnnemiShoot.Shot)dodgeBullet.autre;
                if (RobotBase.monRobot.distanceTo(shot.x, shot.y) - dodgeBullet.speed * (double)shot.time < 30.0) {
                    this.es.uptdate(dodgeBullet);
                }
            }
            if (!((d3 = RobotBase.monRobot.distanceTo(dodgeBullet)) < d2)) continue;
            d2 = d3;
            n = dodgeBullet.tech;
        }
        if (n == -1) {
            this.shoot[2] = (this.shoot[2] * (this.totalShoot - 1.0) + 1.0) / this.totalShoot;
            this.shoot[0] = this.shoot[0] * (this.totalShoot - 1.0) / this.totalShoot;
            this.shoot[1] = this.shoot[1] * (this.totalShoot - 1.0) / this.totalShoot;
        } else if (n == 1) {
            this.shoot[1] = (this.shoot[1] * (this.totalShoot - 1.0) + 1.0) / this.totalShoot;
            this.shoot[2] = this.shoot[2] * (this.totalShoot - 1.0) / this.totalShoot;
            this.shoot[0] = this.shoot[0] * (this.totalShoot - 1.0) / this.totalShoot;
        } else if (n == 0) {
            this.shoot[0] = (this.shoot[0] * (this.totalShoot - 1.0) + 1.0) / this.totalShoot;
            this.shoot[2] = this.shoot[2] * (this.totalShoot - 1.0) / this.totalShoot;
            this.shoot[1] = this.shoot[1] * (this.totalShoot - 1.0) / this.totalShoot;
        }
    }

    private void firingBullet(double d) {
        Point point;
        Point point2 = point = new Point(RobotBase.monRobot.getX(), RobotBase.monRobot.getY(), 0.0);
        int n = 0;
        while (n < 10) {
            long l = Math.round(this.distance(point) / (20.0 - 3.0 * d));
            point2 = point.copyNextCircular(RobotBase.monRobot.getVelocity(), RobotBase.monRobot.getHeadingRadians(), RobotBase.monRobot.HeadingCgt, l);
            ++n;
        }
        double d2 = this.bearingTo(point2);
        EnnemiBullets.getInstance().add(new DodgeBullet(this.x, this.y, d2, this.name, d, 0));
        EnnemiBullets.getInstance().add(this.es.fire(d));
    }

    public void load(DataInputStream dataInputStream) {
        try {
            this.shoot[0] = this.shoot[0] * 0.2 + 0.8 * dataInputStream.readDouble();
            this.shoot[1] = this.shoot[1] * 0.2 + 0.8 * dataInputStream.readDouble();
            this.shoot[2] = this.shoot[2] * 0.2 + 0.8 * dataInputStream.readDouble();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.sm.load(dataInputStream);
        this.es.load(dataInputStream);
    }

    public void save(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeDouble(this.shoot[0]);
            dataOutputStream.writeDouble(this.shoot[1]);
            dataOutputStream.writeDouble(this.shoot[2]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.sm.save(dataOutputStream);
        this.es.save(dataOutputStream);
    }

    public Rectangle2D.Double getBox() {
        return this.box;
    }

    public Point getMaxPoint(double d) {
        double d2 = this.velocity;
        double d3 = this.heading;
        double d4 = this.heading - (RobotBase.monRobot.bearingTo(this) - 1.5707963267948966);
        if (d4 > 1.5707963267948966) {
            d4 -= Math.PI;
        } else if (d4 < -1.5707963267948966) {
            d4 += Math.PI;
        }
        int n = RobotMath.sign(d4);
        double d5 = this.x;
        double d6 = this.y;
        double d7 = 0.0;
        while (d > 0.0) {
            d2 = d2 >= 0.0 ? Math.min(8.0, d2 + 1.0) : (d2 += 2.0);
            if (RobotMath.sign(d4) == n) {
                d7 = (double)n * Math.toRadians(10.0 - Math.abs(d2) * 0.75);
                d3 -= d7;
                d4 -= d7;
            }
            d5 += Math.sin(d3) * d2;
            d6 += Math.cos(d3) * d2;
            d -= 1.0;
        }
        return new Point(d5, d6, 0.0);
    }

    public Point getMinPoint(double d) {
        double d2 = this.velocity;
        double d3 = this.heading;
        double d4 = this.heading - (RobotBase.monRobot.bearingTo(this) - 1.5707963267948966);
        if (d4 > 1.5707963267948966) {
            d4 -= Math.PI;
        } else if (d4 < -1.5707963267948966) {
            d4 += Math.PI;
        }
        int n = RobotMath.sign(d4);
        double d5 = this.x;
        double d6 = this.y;
        double d7 = 0.0;
        while (d > 0.0) {
            d2 = d2 <= 0.0 ? Math.max(-8.0, d2 - 1.0) : (d2 -= 2.0);
            if (RobotMath.sign(d4) == n) {
                d7 = (double)n * Math.toRadians(10.0 - Math.abs(d2) * 0.75);
                d3 -= d7;
                d4 -= d7;
            }
            d5 += Math.sin(d3) * d2;
            d6 += Math.cos(d3) * d2;
            d -= 1.0;
        }
        return new Point(d5, d6, 0.0);
    }

    public void reinitialize() {
        this.time = -8L;
        this.alive = true;
    }
}

