/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import pa3k.Change;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.SelfTracking;
import robocode.AdvancedRobot;
import robocode.util.Utils;

abstract class State {
    protected List<Change> changes = new LinkedList<Change>();
    protected int speed;
    protected double lkh = 0.0;

    public abstract Change amIStillHere(AdvancedRobot var1, SelfTracking var2, Opponent var3, long var4, State[] var6, boolean var7, long var8, boolean var10, long var11, long var13, double var15) throws Exception;

    public double getLikelihood() {
        return this.lkh;
    }

    public void deleteChange(Change c) {
        this.changes.remove(c);
    }

    public State(int speed) {
        this.speed = speed;
    }

    public void increaseNoChangeLikelihood(long lastOpponentSpeedChange, boolean facingWall, long lastOpponentHitDelay, long lastEnergyDropDelay, double lastEnergyDrop) {
        this.lkh += 1.0;
    }

    public double advancePosition(Position p, double heading, double lastHeading, int direction) {
        if (this.speed == 0 || direction == 0) {
            return heading;
        }
        p.check();
        Position prev = new Position(p);
        p.modify(1L, this.speed * direction, heading);
        p.adjustForWalls(prev, 1, null, 0.0, direction == -1 ? Utils.normalAbsoluteAngle((double)(heading + Math.PI)) : heading);
        return heading;
    }

    public Change advance(Position p, long lastOpponentSpeedChange, boolean facingWall, long lastOpponentHitDelay, long lastEnergyDropDelay, double lastEnergyDrop) {
        Iterator<Change> i = this.changes.iterator();
        if (this.changes.isEmpty()) {
            return null;
        }
        LinkedList<Change> applicableChanges = new LinkedList<Change>();
        double lkh = 0.0;
        double negLkh = this.lkh;
        while (i.hasNext()) {
            Change c = i.next();
            if (!c.isApplicable(lastOpponentSpeedChange, facingWall, lastOpponentHitDelay, lastEnergyDropDelay, lastEnergyDrop)) continue;
            lkh += c.getLikelihood();
            applicableChanges.add(c);
        }
        if (applicableChanges.isEmpty()) {
            return null;
        }
        double r = Utils.getRandom().nextDouble() * (negLkh + lkh);
        if (r < negLkh) {
            return null;
        }
        i = applicableChanges.iterator();
        lkh = negLkh;
        while (i.hasNext()) {
            Change c = i.next();
            if (!(r <= (lkh += c.getLikelihood()))) continue;
            return c;
        }
        assert (false);
        return null;
    }

    protected Change checkChanges(Change c, long lastOpponentSpeedChange, boolean facingWall, long lastOpponentHitDelay, long lastEnergyDropDelay, double lastEnergyDrop) {
        for (Change existing : this.changes) {
            if (!c.isSpecialCaseOf(existing)) continue;
            return existing;
        }
        this.changes.add(c);
        if (this.changes.size() > 4) {
            LinkedList<Change> newChanges = new LinkedList<Change>();
            ListIterator<Change> it = this.changes.listIterator();
            Change fav1 = null;
            Change fav2 = null;
            double score = 0.0;
            while (it.hasNext()) {
                Change c1 = it.next();
                it.remove();
                newChanges.add(c1);
                ListIterator<Change> sub = this.changes.listIterator();
                while (sub.hasNext()) {
                    Change c2 = sub.next();
                    double s = c1.cmp(c2);
                    if (!(s > score)) continue;
                    fav1 = c1;
                    fav2 = c2;
                    score = s;
                }
            }
            if (fav1 != null) {
                Log.log(3, "Generalizing " + fav1 + " with " + fav2);
                fav1.generalizeWith(fav2);
                Log.log(3, "  result " + fav1);
            }
            this.changes = newChanges;
            this.changes.remove(fav2);
        }
        return c;
    }

    public void dumpChanges() {
        for (Change c : this.changes) {
            Log.log(4, "  " + c);
        }
    }

    public int getSpeed() {
        return this.speed;
    }
}

