/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import pa3k.Aiming;
import pa3k.AngleUtils;
import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import robocode.AdvancedRobot;

public class TronAiming
extends Aiming {
    public TronAiming(AdvancedRobot robot, String opponentName, boolean outging) {
        super(robot, opponentName, outging);
    }

    @Override
    public void dumpStats() {
        super.dumpStats();
    }

    private void paintBins(double[] pBins, double[] nBins, Position source, double neg, double mid, double advance, double distance, Color c) {
        double countCorrection = (double)nBins.length / (double)pBins.length;
        int pMax = 0;
        int pMin = 0;
        int nMax = 0;
        int nMin = 0;
        int i = 0;
        while (i < pBins.length) {
            if (pBins[i] > pBins[pMax]) {
                pMax = i;
            }
            if (pBins[i] < pBins[pMin]) {
                pMin = i;
            }
            ++i;
        }
        i = 0;
        while (i < nBins.length) {
            if (nBins[i] > nBins[nMax]) {
                nMax = i;
            }
            if (nBins[i] < nBins[nMin]) {
                nMin = i;
            }
            ++i;
        }
        double min = nBins[nMin] * countCorrection < pBins[pMin] ? nBins[nMin] * countCorrection : pBins[pMin];
        double max = nBins[nMax] * countCorrection > pBins[pMax] ? nBins[nMax] * countCorrection : pBins[pMax];
        double combined = nBins[nBins.length - 1] * countCorrection + pBins[0];
        max = max > combined ? max : combined;
        int i2 = 0;
        while (i2 < nBins.length - 1) {
            Log.paintArc(4, source, mid - advance * (double)(nBins.length - 1 - i2) - advance / 2.0, advance, distance, new Color(c.getRed(), c.getGreen(), c.getBlue(), 20 + (int)(100.0 * ((nBins[i2] * countCorrection - min) / (max - min)))), 0);
            Log.paintLine(4, source, mid - advance * (double)(nBins.length - 1 - i2) - advance / 2.0, new Color(c.getRed(), c.getGreen(), c.getBlue(), 100), 0);
            ++i2;
        }
        Log.paintArc(4, source, mid - advance / 2.0, advance, distance, new Color(c.getRed(), c.getGreen(), c.getBlue(), 20 + (int)(100.0 * ((combined - min) / (max - min)))), 0);
        i2 = 1;
        while (i2 < pBins.length) {
            Log.paintArc(4, source, mid + advance * (double)i2 - advance / 2.0, advance, distance, new Color(c.getRed(), c.getGreen(), c.getBlue(), 20 + (int)(100.0 * ((pBins[i2] - min) / (max - min)))), 0);
            Log.paintLine(4, source, mid + advance * (double)i2 - advance / 2.0, new Color(c.getRed(), c.getGreen(), c.getBlue(), 100), 0);
            ++i2;
        }
        Log.paintLine(4, source, neg, c, 0);
        Log.paintLine(4, source, mid, c, 0);
    }

    @Override
    public BulletTracking getBestAimingAngle(Position source, Opponent target, double energy, long currentTime) {
        BulletTracking bt = super.getBestAimingAngle(source, target, energy, currentTime);
        Log.log(4, "neg " + bt.getNegativeAngle() + ", mid " + bt.getMiddleAngle() + ", pos " + bt.getPositiveAngle() + ", step " + bt.getAngleAdvance() + (bt.isTowardWall() ? ", towards wall" : ""));
        double[] pBins = this.getPositiveBins(bt, 0.9, 1.0, -0.2, 0.1);
        double[] nBins = this.getNegativeBins(bt, 0.9, 1.0, -0.2, 0.1);
        pBins[0] = pBins[0] + nBins[nBins.length - 1];
        double countCorrection = (double)nBins.length / (double)pBins.length;
        int pMax = 0;
        int nMax = nBins.length - 1;
        int i = 0;
        while (i < pBins.length) {
            if (pBins[i] > pBins[pMax]) {
                pMax = i;
            }
            ++i;
        }
        i = 0;
        while (i < nBins.length - 1) {
            if (nBins[i] > nBins[nMax]) {
                nMax = i;
            }
            ++i;
        }
        double dir = 0.0;
        dir = nBins[nMax] * countCorrection > pBins[pMax] ? bt.middleAngle - bt.getAngleAdvance() * (double)(nBins.length - 1 - nMax) : bt.middleAngle + bt.getAngleAdvance() * (double)pMax;
        bt.setFiringAngle(dir);
        this.paintBins(pBins, nBins, source, bt.getNegativeAngle(), bt.getMiddleAngle(), bt.getAngleAdvance(), bt.getSource().distance(bt.getTarget()), Color.WHITE);
        return bt;
    }

    @Override
    public double[] getEscapeBins(BulletTracking bt) {
        double weightNeighbor = 0.9;
        double[] pBins = this.getPositiveBins(bt, 1.0, 0.4, 0.0, weightNeighbor);
        double[] nBins = this.getNegativeBins(bt, 1.0, 0.4, 0.0, weightNeighbor);
        int noPositions = pBins.length + nBins.length - 1;
        double[] escapes = new double[noPositions];
        this.paintBins(pBins, nBins, bt.getSource(), bt.getNegativeAngle(), bt.getMiddleAngle(), bt.getAngleAdvance(), bt.getSource().distance(bt.getTarget()), Color.RED);
        double countCorrection = (double)nBins.length / (double)pBins.length;
        int k = 0;
        while (k < nBins.length - 1) {
            escapes[k] = nBins[k] * countCorrection;
            ++k;
        }
        k = nBins.length - 1;
        while (k < nBins.length + pBins.length - 1) {
            escapes[k] = pBins[k - (nBins.length - 1)];
            ++k;
        }
        int n = nBins.length - 1;
        escapes[n] = escapes[n] + nBins[nBins.length - 1] * countCorrection;
        if (nBins.length > 1) {
            int n2 = nBins.length - 2;
            escapes[n2] = escapes[n2] + escapes[nBins.length - 1] * weightNeighbor;
        }
        if (pBins.length > 1) {
            int n3 = nBins.length;
            escapes[n3] = escapes[n3] + escapes[nBins.length - 1] * weightNeighbor;
        }
        return escapes;
    }

    private void fillBin(BulletTracking history, BulletTracking wave, double[] bins, boolean higher, double weight, double neighborWeight) {
        if (history.getFiringAngle() == 0.0) {
            return;
        }
        if (history.isTowardWall() != wave.isTowardWall()) {
            return;
        }
        double ratio = history.getAimingRatio();
        if (ratio < 0.0 || ratio > 1.0) {
            Log.log(1, "fffffff3:" + history);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (ratio >= 0.5 && higher) {
            ratio -= 0.5;
            ratio *= 2.0;
        } else if (ratio < 0.5 && !higher) {
            ratio *= 2.0;
        } else {
            return;
        }
        int idx = (int)(ratio * (double)bins.length);
        if (idx >= bins.length) {
            Log.log(1, "ffffffff:" + history);
            idx = 0;
        }
        double diff = wave.getDistance() - history.getDistance();
        double fullValue = weight * Math.exp(-Math.abs(diff /= 100.0));
        int n = idx;
        bins[n] = bins[n] + fullValue;
        double n2 = fullValue * neighborWeight;
        if (idx > 0) {
            int n3 = idx - 1;
            bins[n3] = bins[n3] + n2;
        }
        if (idx < bins.length - 1) {
            int n4 = idx + 1;
            bins[n4] = bins[n4] + n2;
        }
    }

    private double[] getPositiveBins(BulletTracking wave, double hitWeight, double posWeight, double missWeight, double neighborWeight) {
        int count = (int)Math.round(AngleUtils.difference(wave.getPositiveAngle(), wave.getMiddleAngle()) / wave.getAngleAdvance()) + 1;
        double[] bins = new double[count];
        int i = 0;
        while (i < bins.length) {
            bins[i] = 0.0;
            ++i;
        }
        for (BulletTracking bt : this.hits) {
            this.fillBin(bt, wave, bins, true, hitWeight, neighborWeight);
        }
        for (BulletTracking bt : this.possibleHits) {
            this.fillBin(bt, wave, bins, true, posWeight, neighborWeight);
        }
        for (BulletTracking bt : this.misses) {
            this.fillBin(bt, wave, bins, true, missWeight, neighborWeight);
        }
        return bins;
    }

    private double[] getNegativeBins(BulletTracking wave, double hitWeight, double posWeight, double missWeight, double neighborWeight) {
        int count = (int)Math.round(AngleUtils.difference(wave.getMiddleAngle(), wave.getNegativeAngle()) / wave.getAngleAdvance()) + 1;
        if (count <= 0) {
            Log.log(1, "Error with angles: " + wave);
        }
        double[] bins = new double[count];
        int i = 0;
        while (i < bins.length) {
            bins[i] = 0.0;
            ++i;
        }
        for (BulletTracking bt : this.hits) {
            this.fillBin(bt, wave, bins, false, hitWeight, neighborWeight);
        }
        for (BulletTracking bt : this.possibleHits) {
            this.fillBin(bt, wave, bins, false, posWeight, neighborWeight);
        }
        for (BulletTracking bt : this.misses) {
            this.fillBin(bt, wave, bins, false, missWeight, neighborWeight);
        }
        return bins;
    }
}

