/*
 * Decompiled with CFR 0.152.
 */
package lambdaxy;

import java.util.HashMap;
import lambdaxy.Enemy;
import lambdaxy.GravityPoint;
import lambdaxy.TargetSelector;
import lambdaxy.TargetSelectorClosest;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class TBot
extends AdvancedRobot {
    HashMap targets;

    public void run() {
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.targets = new HashMap();
        TargetSelectorClosest targetSelector = new TargetSelectorClosest(this.targets);
        while (true) {
            this.moveScanner();
            Enemy target = ((TargetSelector)targetSelector).chooseTarget();
            if (target != null) {
                this.out.println("Target: " + target.getName());
            }
            this.moveRobot(target);
            double firePower = this.choosePower();
            this.moveGun(target);
            this.fire(firePower);
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy scannedEnemy;
        if (this.targets.containsKey(e.getName())) {
            scannedEnemy = (Enemy)this.targets.get(e.getName());
        } else {
            scannedEnemy = new Enemy();
            scannedEnemy.setName(e.getName());
            this.targets.put(e.getName(), scannedEnemy);
        }
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        scannedEnemy.setX(this.getX() + Math.sin(absbearing_rad) * e.getDistance());
        scannedEnemy.setY(this.getY() + Math.cos(absbearing_rad) * e.getDistance());
        scannedEnemy.setDistance(e.getDistance());
        scannedEnemy.setBearing(e.getBearingRadians());
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.targets.remove(e.getName());
    }

    public void moveScanner() {
        this.setTurnRadarLeftRadians(Math.PI * 2);
    }

    public void moveGun(Enemy target) {
        if (target != null) {
            double angleToTurnGunRadians = this.getHeadingRadians() - this.getGunHeadingRadians() + target.getBearingRadians();
            angleToTurnGunRadians = this.normaliseBearing(angleToTurnGunRadians);
            this.setTurnGunRightRadians(angleToTurnGunRadians);
        }
    }

    public double choosePower() {
        return 3.0;
    }

    void moveRobot(Enemy target) {
        double xforce = 0.0;
        double yforce = 0.0;
        for (Enemy enemy : this.targets.values()) {
            GravityPoint p = enemy.getName() == target.getName() ? (enemy.getDistance() >= 200.0 ? new GravityPoint(enemy.getX(), enemy.getY(), 1000.0) : (enemy.getDistance() >= 120.0 ? new GravityPoint(enemy.getX(), enemy.getY(), 0.0) : new GravityPoint(enemy.getX(), enemy.getY(), -1000.0))) : new GravityPoint(enemy.getX(), enemy.getY(), -1000.0);
            double force = p.getPower() / Math.pow(this.getRange(this.getX(), this.getY(), p.getX(), p.getY()), 2.0);
            double ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(this.getY() - p.getY(), this.getX() - p.getX()));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
        }
        xforce += 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getBattleFieldWidth(), this.getY()), 3.0);
        yforce += 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getX(), this.getBattleFieldHeight()), 3.0);
        this.goTo(this.getX() - (xforce -= 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), 0.0, this.getY()), 3.0)), this.getY() - (yforce -= 5000.0 / Math.pow(this.getRange(this.getX(), this.getY(), this.getX(), 0.0), 3.0)));
    }

    public double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    void goTo(double x, double y) {
        double dist = 20.0;
        double angle = Math.toDegrees(this.absbearing(this.getX(), this.getY(), x, y));
        double r = this.turnTo(angle);
        this.setAhead(dist * r);
    }

    int turnTo(double angle) {
        int dir;
        double ang = this.normaliseBearing(this.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.setTurnLeft(ang);
        return dir;
    }
}

