/*
 * Decompiled with CFR 0.152.
 */
package techdude.Class2C.Systems;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import techdude.Class2C.Systems.Joel;
import techdude.Class2C.Systems.System;

public abstract class Mark
extends System {
    public float freq;
    public int numfreq;
    public String name;
    public Color color;
    public int priority;
    public double fieldheight;
    public double fieldwidth;
    public int roundnum;
    public Rectangle2D battlefield;

    public void HitFrequencyToggle() {
        ++this.numfreq;
    }

    public void endRound() {
        this.freq = (this.freq * (float)this.roundnum + (float)this.numfreq) / (float)(this.roundnum + 1);
        ++this.roundnum;
        this.numfreq = 0;
    }

    public abstract MovementData move(Joel.RoboTrack var1, Joel.RoboTrack var2, RobotMovementState var3);

    public void onPaint(Graphics2D g, int j, boolean best) {
        g.setColor(Color.WHITE);
        g.drawString(this.name + '[' + (double)Math.round(this.freq * 100.0f) / 100.0 + "]: " + this.numfreq, 20, (int)this.fieldheight - (j + 1) * 15);
        if (best) {
            g.setColor(this.color);
            g.fillOval(5, (int)this.fieldheight - (j + 1) * 15, 10, 10);
        }
    }

    public Mark(Rectangle2D.Double r, Color c, String n, float f, int nf, int p) {
        this.battlefield = r;
        this.freq = f;
        this.name = n;
        this.color = c;
        this.roundnum = nf;
        this.priority = p;
        this.fieldheight = r.width;
        this.fieldwidth = r.height;
    }

    public static class RobotMovementState {
        public double getGunTurnRemaining;
        public double getTurnRemaining;
        public double getGunCoolingRate;
        public double getGunHeading;
        public double getHeading;
        public double getVelocity;
        public double getTime;
    }

    public static class MovementData {
        public double turn;
        public double distance;

        public MovementData() {
        }

        public MovementData(double t, double d) {
            this.turn = t;
            this.distance = d;
        }
    }
}

