/*
 * Decompiled with CFR 0.152.
 */
package leb;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.MoveCompleteCondition;
import robocode.ScannedRobotEvent;

public class ShootAnArrow
extends AdvancedRobot {
    public void run() {
        this.setTurnGunRightRadians(Double.POSITIVE_INFINITY);
        this.goTo(new Point2D.Double(Math.random() * this.getBattleFieldWidth(), Math.random() * this.getBattleFieldHeight()));
        this.setAhead(10.0);
        this.execute();
        while (true) {
            this.waitFor((Condition)new MoveCompleteCondition((AdvancedRobot)this));
            this.goTo(new Point2D.Double(Math.random() * this.getBattleFieldWidth(), Math.random() * this.getBattleFieldHeight()));
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.setFire(3);
        this.setTurnGunRightRadians(0.0 - this.getGunTurnRemainingRadians());
        if (Math.abs(this.getDistanceRemaining()) < (double)5) {
            Point2D.Double newLoc = new Point2D.Double(Math.random() * this.getBattleFieldWidth(), Math.random() * this.getBattleFieldHeight());
            this.goTo(newLoc);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.setFire(3);
        this.setTurnGunRightRadians(0.0 - e.getHeadingRadians() + (Math.random() - 0.5) / (double)5);
        Point2D.Double newLoc = new Point2D.Double(Math.random() * this.getBattleFieldWidth(), Math.random() * this.getBattleFieldHeight());
        this.goTo(newLoc);
    }

    private final void goTo(Point2D destination) {
        Point2D.Double location = new Point2D.Double(this.getX(), this.getY());
        double distance = location.distance(destination);
        double angle = this.normalRelativeAngle(this.absoluteBearing(location, destination) - this.getHeading());
        if (Math.abs(angle) > 90.0) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= 180.0) : (angle += 180.0);
        }
        this.setTurnRight(angle);
        this.setAhead(distance);
        this.setTurnGunRightRadians(800000.0 * (Math.random() - 0.5));
        this.execute();
    }

    private final double absoluteBearing(Point2D source, Point2D target) {
        return Math.toDegrees(Math.atan2(target.getX() - source.getX(), target.getY() - source.getY()));
    }

    private final double normalRelativeAngle(double angle) {
        angle = Math.toRadians(angle);
        return Math.toDegrees(Math.atan2(Math.sin(angle), Math.cos(angle)));
    }
}

