/*
 * Decompiled with CFR 0.152.
 */
package whitesquare.robots;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import whitesquare.robots.Point;
import whitesquare.robots.Rect;

public class SkynetAdvanced
extends AdvancedRobot {
    private int targetChangeCounter;
    private Point position;
    private Target target;
    private Rect board;
    private double goalDirection;
    private double bulletPower;
    private long tick;
    Map<String, Target> targets = new HashMap<String, Target>();

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.board = new Rect(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        this.goalDirection = this.getHeadingRadians();
        while (true) {
            double steeringChange;
            this.position = new Point(this.getX(), this.getY());
            this.bulletPower = 3.0;
            if (this.getEnergy() < 20.0) {
                this.bulletPower = 2.0;
            } else if (this.getEnergy() < 10.0) {
                this.bulletPower = 1.0;
            }
            for (Target t : this.targets.values()) {
                if (t.scanTime > t.prevScanTime) {
                    double maxTurn = 10.0 - 0.75 * Math.abs(t.velocity);
                    t.angularVelocity = (t.heading - t.lastHeading) / (double)(t.scanTime - t.prevScanTime);
                    t.angularVelocity = Math.min(Math.max(t.angularVelocity, -maxTurn), maxTurn);
                }
                t.position = this.calculateFuturePosition(t, 1);
                t.direction = t.position.minus(this.position).toAngle();
            }
            if (this.target != null) {
                double angleRelative = Utils.normalRelativeAngle((double)(this.target.direction - this.goalDirection));
                this.goalDirection = angleRelative > 0.0 ? this.target.direction - 1.5707963267948966 : this.target.direction + 1.5707963267948966;
            }
            int i = 0;
            while (i < 100) {
                Point goalPosition = this.position.plus(Point.makeVector(this.goalDirection, 150.0));
                if (this.board.inside(goalPosition)) break;
                if (this.target == null) {
                    this.goalDirection += 0.03;
                } else {
                    double change = Utils.normalRelativeAngle((double)(this.target.direction - this.goalDirection));
                    this.goalDirection += change * 0.03;
                }
                ++i;
            }
            if (Math.abs(steeringChange = Utils.normalRelativeAngle((double)(this.goalDirection - this.getHeadingRadians()))) > 0.001) {
                this.setTurnRightRadians(steeringChange);
            }
            if (this.target != null) {
                double powerNeeded = this.target.energy * 0.25;
                if (powerNeeded < this.bulletPower) {
                    this.bulletPower = powerNeeded;
                }
                if (this.bulletPower > 1.0 && this.target.distance > 200.0) {
                    this.bulletPower = Math.max(this.bulletPower - 1.0, 1.0);
                }
                this.target.prediction = this.calculateRobotHitPosition(this.position, this.target, Rules.getBulletSpeed((double)this.bulletPower));
            }
            if (this.target != null) {
                double angle = this.target.prediction.minus(this.position).toAngle();
                double dirChange = Utils.normalRelativeAngle((double)(angle - this.getGunHeadingRadians()));
                if (Math.abs(dirChange) > 0.01) {
                    this.setTurnGunRightRadians(dirChange);
                }
                if (Math.abs(dirChange) < 0.1 && this.getGunHeat() <= 0.0 && this.getEnergy() > this.bulletPower) {
                    this.setFire(this.bulletPower);
                }
            }
            if (this.target != null && this.target.distance < 50.0) {
                this.setBack(8.0);
            } else {
                this.setAhead(16.0);
            }
            if (this.target != null && this.targets.size() == 1) {
                double radarChange = Utils.normalRelativeAngle((double)(this.target.direction - this.getRadarHeadingRadians()));
                if (Math.abs(radarChange) > 0.0) {
                    this.setTurnRadarRightRadians(radarChange);
                } else {
                    this.scan();
                }
            } else {
                this.setTurnRadarLeftRadians(Double.MAX_VALUE);
            }
            this.execute();
            ++this.tick;
            if (this.targetChangeCounter <= 0) continue;
            --this.targetChangeCounter;
        }
    }

    private Point calculateFuturePosition(Target t, int ticks) {
        Point pos = t.position;
        double newHeading = t.heading + t.angularVelocity * (double)Math.max(this.tick - t.scanTime, 0L);
        int i = 0;
        while (i < ticks) {
            Point velocity = Point.makeVector(newHeading, t.velocity);
            newHeading += t.angularVelocity;
            pos = this.board.clamp(pos.plus(velocity));
            ++i;
        }
        return pos;
    }

    private Point calculateRobotHitPosition(Point ownPos, Target t, double speed) {
        Point last = t.position;
        Point prediction = t.position;
        double dist = t.distance;
        int i = 1;
        while (i <= 1000) {
            last = prediction;
            prediction = this.calculateFuturePosition(t, i);
            dist = prediction.minus(ownPos).length();
            if (dist < (double)i * speed) break;
            ++i;
        }
        return this.board.clamp(prediction);
    }

    private Target getTarget(ScannedRobotEvent e) {
        String name = e.getName();
        Target t = this.targets.get(name);
        if (t == null) {
            t = new Target();
            t.name = e.getName();
            this.targets.put(name, t);
        }
        return t;
    }

    private void switchTarget(Target t) {
        this.targetChangeCounter = 8;
        this.target = t;
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.targets.remove(event.getName());
        if (this.target != null && event.getName().equals(this.target.name)) {
            this.target = null;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Point position = new Point(this.getX(), this.getY());
        Target t = this.getTarget(e);
        t.velocity = e.getVelocity();
        t.lastHeading = t.heading;
        t.heading = e.getHeadingRadians();
        t.distance = e.getDistance();
        t.direction = e.getBearingRadians() + this.getHeadingRadians();
        t.energy = e.getEnergy();
        t.position = position.plus(Point.makeVector(t.direction, t.distance));
        if (t.prediction == null) {
            t.prediction = t.position;
        }
        t.prevScanTime = t.scanTime;
        t.scanTime = this.tick;
        if (this.target == null) {
            this.switchTarget(t);
        } else if (!t.name.equals(this.target.name)) {
            boolean change = false;
            if (t.distance < 60.0 && t.distance < this.target.distance) {
                change = true;
            } else if (t.distance < this.target.distance - 100.0) {
                change = true;
            } else if (t.distance < this.target.distance + 100.0 && t.energy < 10.0) {
                change = true;
            }
            if (change) {
                if (this.targetChangeCounter <= 0) {
                    this.switchTarget(t);
                } else {
                    --this.targetChangeCounter;
                }
            }
        }
    }

    public void onPaint(Graphics2D g) {
        super.onPaint(g);
        Point position = new Point(this.getX(), this.getY());
        this.drawCircle(g, Color.GREEN, position, 200);
        Point goalVector = Point.makeVector(this.goalDirection, 100.0);
        this.drawLine(g, Color.YELLOW, position, position.plus(goalVector));
        for (Target t : this.targets.values()) {
            Color c = this.target == t ? Color.RED : Color.GREEN;
            this.drawCircle(g, c.darker(), t.position, 35);
            Point endHeading = t.position.plus(Point.makeVector(t.heading, 35.0));
            this.drawLine(g, c, t.position, endHeading);
            Point endHeadingPred = t.position.plus(Point.makeVector(t.heading + t.angularVelocity * 10.0, 35.0));
            this.drawLine(g, c, endHeading, endHeadingPred);
            if (this.target != t) continue;
            int i = 0;
            while (i < 40) {
                Point pp = this.calculateFuturePosition(t, i);
                this.drawCircle(g, Color.BLUE, pp, 3);
                i += 5;
            }
            this.drawLine(g, Color.RED, position, position.plus(Point.makeVector(this.target.direction, 100.0)));
            this.drawCircle(g, Color.YELLOW, this.target.prediction, 10);
        }
    }

    public void drawLine(Graphics2D g, Color colour, Point from, Point to) {
        g.setColor(colour);
        g.drawLine((int)from.x, (int)from.y, (int)to.x, (int)to.y);
    }

    public void drawCircle(Graphics2D g, Color colour, Point p, int radius) {
        g.setColor(colour);
        g.drawArc(-radius + (int)p.x, -radius + (int)p.y, radius * 2, radius * 2, 0, 360);
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    class Target {
        Point position;
        Point prediction;
        double direction;
        double distance;
        double velocity;
        double lastHeading = 0.0;
        double heading = 0.0;
        double angularVelocity = 0.0;
        double energy = 100.0;
        String name;
        long scanTime = 0L;
        long prevScanTime = -1L;

        Target() {
        }
    }
}

