/*
 * Decompiled with CFR 0.152.
 */
package barontrozo;

import barontrozo.BaronTrozo;
import barontrozo.StatusBuilder;
import barontrozo.dataStructures.trees.DistanceFunction;

public class SmartDistanceFunction
implements DistanceFunction {
    static int dimensions_;
    boolean init_;
    double[] minDim_;
    double[] maxDim_;
    double[] factorDim_;
    boolean hasRanges_;
    static double maxDist_;

    public SmartDistanceFunction(int dimensions) {
        dimensions_ = dimensions;
        this.minDim_ = new double[dimensions_];
        this.maxDim_ = new double[dimensions_];
        this.factorDim_ = new double[dimensions_];
        this.init_ = false;
        int i = 0;
        while (i < dimensions_) {
            this.factorDim_[i] = 1.0;
            ++i;
        }
        this.hasRanges_ = false;
    }

    public static double GetMaxDistance() {
        return maxDist_;
    }

    public void FillFactor(double[] factor) {
        factor[0] = BaronTrozo.conf_.f0_;
        factor[1] = BaronTrozo.conf_.f1_;
        factor[2] = BaronTrozo.conf_.f2_;
        factor[3] = BaronTrozo.conf_.f3_;
        factor[4] = BaronTrozo.conf_.f4_;
        factor[5] = BaronTrozo.conf_.f5_;
        factor[6] = BaronTrozo.conf_.f6_;
    }

    @Override
    public double distance(double[] p1, double[] p2) {
        int i;
        double d = 0.0;
        if (!this.hasRanges_) {
            StatusBuilder.FillMaxAndMin(this.maxDim_, this.minDim_);
            this.FillFactor(this.factorDim_);
            maxDist_ = 0.0;
            i = 0;
            while (i < dimensions_) {
                maxDist_ += this.factorDim_[i];
                ++i;
            }
            this.hasRanges_ = true;
        }
        i = 0;
        while (i < dimensions_) {
            double diff = Math.abs((p1[i] - p2[i]) / (this.maxDim_[i] - this.minDim_[i]));
            d += (diff *= this.factorDim_[i]);
            ++i;
        }
        return d;
    }

    @Override
    public double distanceToRect(double[] point, double[] min, double[] max) {
        int i;
        double d = 0.0;
        if (!this.hasRanges_) {
            StatusBuilder.FillMaxAndMin(this.maxDim_, this.minDim_);
            this.FillFactor(this.factorDim_);
            maxDist_ = 0.0;
            i = 0;
            while (i < dimensions_) {
                maxDist_ += this.factorDim_[i];
                ++i;
            }
            this.hasRanges_ = true;
        }
        i = 0;
        while (i < dimensions_) {
            double diff = 0.0;
            if (point[i] > max[i]) {
                if (this.maxDim_[i] != this.minDim_[i]) {
                    diff = Math.abs((point[i] - max[i]) / (this.maxDim_[i] - this.minDim_[i]));
                }
            } else if (point[i] < min[i] && this.maxDim_[i] != this.minDim_[i]) {
                diff = Math.abs((point[i] - min[i]) / (this.maxDim_[i] - this.minDim_[i]));
            }
            d += (diff *= this.factorDim_[i]);
            ++i;
        }
        return d;
    }
}

