/*
 * Decompiled with CFR 0.152.
 */
package ahr.ice;

import ahr.ice.Gun;
import ahr.ice.RobotState;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.util.Utils;

class CircularGun
extends Gun {
    static double oldEnemyHeading = 0.0;

    CircularGun() {
    }

    @Override
    public String getName() {
        return "Circular Gun";
    }

    @Override
    public Color getColor() {
        return Color.WHITE;
    }

    @Override
    public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield) {
        double predictedY;
        double predictedX;
        block1: {
            double myX = shooter.getX();
            double myY = shooter.getY();
            double absoluteBearing = shooter.heading + shooter.absoluteAngleTo(target);
            double enemyX = target.x;
            double enemyY = target.y;
            double enemyHeading = target.heading;
            double enemyHeadingChange = enemyHeading - oldEnemyHeading;
            double enemyVelocity = target.velocity;
            oldEnemyHeading = enemyHeading;
            double deltaTime = 0.0;
            double battleFieldHeight = battlefield.getHeight();
            double battleFieldWidth = battlefield.getWidth();
            predictedX = enemyX;
            predictedY = enemyY;
            do {
                double d;
                deltaTime += 1.0;
                if (!(d * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY))) break block1;
                predictedY += Math.cos(enemyHeading) * enemyVelocity;
            } while (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0));
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - shooter.x, predictedY - shooter.y));
        return Utils.normalRelativeAngle((double)theta);
    }
}

