/*
 * Decompiled with CFR 0.152.
 */
package ahr.ice;

import ahr.ice.Gun;
import ahr.ice.Math.math;
import ahr.ice.RobotState;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.util.Utils;

class LinearGun
extends Gun {
    LinearGun() {
    }

    @Override
    public String getName() {
        return "Linear";
    }

    @Override
    public Color getColor() {
        return Color.YELLOW;
    }

    @Override
    public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield) {
        Point2D.Double me = new Point2D.Double(shooter.getX(), shooter.getY());
        RobotState enemy = target;
        double deltaTime = 1.0;
        double battleFieldHeight = battlefield.getHeight();
        double battleFieldWidth = battlefield.getWidth();
        Point2D.Double predicted = (Point2D.Double)enemy.clone();
        while (deltaTime * (20.0 - 3.0 * bulletPower) < me.distance(predicted)) {
            deltaTime += 1.0;
            predicted = math.project(predicted, target.heading, target.velocity);
            predicted.x = Math.min(Math.max(18.0, predicted.x), battleFieldWidth - 18.0);
            predicted.y = Math.min(Math.max(18.0, predicted.y), battleFieldHeight - 18.0);
        }
        return Utils.normalRelativeAngle((double)math.angle(me, predicted));
    }
}

