/*
 * Decompiled with CFR 0.152.
 */
package ahr.ice.Pilot;

import ahr.ice.AHRBot;
import ahr.ice.Math.PointEvaluator;
import ahr.ice.Math.PointGenerator;
import ahr.ice.Math.math;
import ahr.ice.Pilot.Movement;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class MinimumRiskMover
extends Movement {
    public Rectangle2D.Double safeBattlefield;
    long bulletDodgeTime = 0L;
    PointEvaluator PE;
    double offset;
    int timesCalled = 0;

    @Override
    public void move() {
        ++this.timesCalled;
        if (this.battlefield == null) {
            this.battlefield = this.r.getBattleField();
            this.safeBattlefield = new Rectangle2D.Double(this.battlefield.getX() + 20.0, this.battlefield.getY() + 20.0, this.battlefield.getWidth() - 40.0, this.battlefield.getHeight() - 40.0);
        }
        long time = this.r.getTime();
        PointGenerator pg = new PointGenerator(this.r, this.safeBattlefield);
        if (time - AHRBot.mrTimeToNextSpot >= 0L || this.r.getVelocity() == 0.0) {
            this.r.PE.averagePosition(new Point2D.Double(this.r.getX(), this.r.getY()), this.r.averagePosition);
            Point2D.Double best = pg.generatePoint(this.safeBattlefield);
            double thisRating = 0.0;
            double lastRating = 0.0;
            Iterator i = pg.generatePoints(20);
            while (i.hasNext()) {
                Point2D.Double ran = (Point2D.Double)i.next();
                thisRating = this.PE.pointEval(AHRBot.me, AHRBot.virtualBullets, this.r.getName(), ran, AHRBot.targets, this.r.averagePosition);
                if (!(thisRating >= lastRating)) continue;
                best = ran;
                lastRating = thisRating;
            }
            this.r.goTo(best.x, best.y);
            AHRBot.mrTimeToNextSpot = time + (long)this.r.position().distance(best) / 8L;
            this.r.execute();
        }
        double lastOffset = this.offset;
        this.offset = Math.sin(this.r.getTime() / 10L);
        this.r.setTurnRightRadians(this.r.getTurnRemainingRadians() - lastOffset + this.offset);
        this.r.execute();
    }

    @Override
    public void wallClose() {
        this.r.setTurnRightRadians(math.calculateBearingToXYRadians(this.r.getX(), this.r.getY(), this.r.getHeadingRadians(), AHRBot.middle.x, AHRBot.middle.y));
        this.r.setAhead(200.0);
        AHRBot.lastWallAvoidTime = this.r.getTime();
        this.r.setMaxVelocity(300.0 / this.r.getTurnRemaining());
        this.r.execute();
    }

    @Override
    public void robotClose() {
    }

    @Override
    public void bulletClose() {
        if (this.r.getTime() - this.bulletDodgeTime >= 30L) {
            AHRBot.mrTimeToNextSpot = this.r.getTime();
            this.move();
            this.bulletDodgeTime = this.r.getTime();
        }
    }

    public MinimumRiskMover(AHRBot r) {
        this.r = r;
        this.PE = new PointEvaluator(r);
    }
}

