/*
 * Decompiled with CFR 0.152.
 */
package pedersen.opponent;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.core.Combatant;
import pedersen.core.Constraints;
import pedersen.core.Conversions;
import pedersen.core.Foundation;
import pedersen.core.Snapshot;
import pedersen.core.SnapshotHistoryBase;
import pedersen.debug.Debug;
import pedersen.debug.GraphicalDebugger;
import pedersen.divination.FiringAngle;
import pedersen.divination.WaveData;
import pedersen.divination.WaveInboundBank;
import pedersen.divination.WaveInboundImpl;
import pedersen.divination.WaveOutboundImpl;
import pedersen.misc.Host;
import pedersen.opponent.OpponentEnergyTracker;
import pedersen.opponent.Target;
import pedersen.systems.FireControl;
import pedersen.tactics.bot.WaveAnalysis;
import pedersen.tactics.movement.MovementMethod;
import pedersen.tactics.movement.MovementMethodSet;
import pedersen.tactics.targeting.TargetingMethod;

public abstract class TargetBase
extends SnapshotHistoryBase
implements Target {
    private final String name;
    private long lastUpdate = 0L;
    private OpponentEnergyTracker energyTracker = new OpponentEnergyTracker();
    private double totalBulletDamageReceived = 0.0;
    private double totalBulletDamageDealt = 0.0;
    protected List offensiveTargetingMethods = new ArrayList();
    protected List defensiveTargetingMethods = new ArrayList();
    protected List offensiveWaveAnalyses = new ArrayList();
    protected List defensiveWaveAnalyses = new ArrayList();
    protected MovementMethodSet movementMethods;
    protected FireControl fireControl;
    private boolean isActive = true;
    private long lastShotFired = 0L;
    private double lastShotFirepower = 3.0;

    protected TargetBase(String newName, Foundation robot) {
        this.name = newName;
        this.movementMethods = robot.getMovementMethods();
        this.offensiveTargetingMethods = robot.getOffensiveTargetingMethods(this);
        this.defensiveTargetingMethods = robot.getDefensiveTargetingMethods(this);
        this.fireControl = robot.getFireControl();
    }

    public void update(Snapshot newSnapshot) {
        if (this.lastShotFired > newSnapshot.getTime()) {
            this.lastShotFired = 1L;
            this.lastShotFirepower = 3.0;
        }
        this.activate();
        this.detectShot(newSnapshot.getEnergy());
        this.appendSnapshot(newSnapshot);
        this.energyTracker.set(newSnapshot.getEnergy());
        long newUpdate = Host.singleton.getTurn();
        if (this.lastUpdate > 10L && newUpdate > this.lastUpdate + 1L) {
            if (newUpdate - this.lastUpdate == 1L) {
                Debug.line("Missed scan " + (newUpdate - 1L) + ".");
            } else {
                Debug.line("Missed scan(s) between " + this.lastUpdate + " and " + newUpdate + ".");
            }
        }
        this.lastUpdate = Host.singleton.getTurn();
    }

    private void detectShot(double newEnergy) {
        long time = Host.singleton.getTurn();
        boolean isGunCool = Host.singleton.isGunCool(this.getLastShotFired(), this.getLastShotFirepower());
        double energyDrop = -this.energyTracker.compare(newEnergy);
        if (energyDrop > 0.0 && isGunCool && (Constraints.isFirepowerLegal(energyDrop) || this.doubleCheckForCloseEnough(energyDrop))) {
            Combatant combatant = Combatant.getCombatant();
            double velocity = Conversions.getBulletVelocityFromFirepower(energyDrop);
            velocity = Constraints.getClosestLegalBulletVelocity(velocity);
            combatant.setPerformanceStatisticsTracking(true);
            WaveInboundImpl inboundWave = new WaveInboundImpl(this, this.getHistoricalSnapshot(0), velocity, combatant.getHistoricalSnapshot(2), time - 1L);
            inboundWave.setLiveRound();
            WaveInboundBank.singleton.add(inboundWave);
            this.attachOffensiveFiringAngles(inboundWave);
            this.setLastShotFired(time);
            this.setLastShotFirepower(energyDrop);
            combatant.onEnemyFire(inboundWave);
        }
    }

    private boolean doubleCheckForCloseEnough(double energyDrop) {
        return Constraints.areEqual(energyDrop, 0.1) || Constraints.areEqual(energyDrop, 3.0);
    }

    public boolean equals(Target other) {
        return other != null && this.name.compareTo(other.getName()) == 0;
    }

    public void attachOffensiveFiringAngles(WaveInboundImpl wave) {
        Iterator iterator = this.offensiveTargetingMethods.iterator();
        while (iterator.hasNext()) {
            TargetingMethod targetingMethod = (TargetingMethod)iterator.next();
            FiringAngle firingAngle = targetingMethod.getFiringAngle(wave, 0L, true);
            if (firingAngle == null) continue;
            wave.addFiringAngle(firingAngle);
        }
    }

    public void attachDefensiveFiringAngles(WaveOutboundImpl wave) {
        Iterator iterator = this.defensiveTargetingMethods.iterator();
        while (iterator.hasNext()) {
            TargetingMethod targetingMethod = (TargetingMethod)iterator.next();
            FiringAngle firingAngle = targetingMethod.getFiringAngle(wave, 1L, false);
            if (firingAngle == null) continue;
            wave.addFiringAngle(firingAngle);
        }
    }

    public TargetingMethod getFavoredTargetingMethod() {
        TargetingMethod preferredTargetingMethod = null;
        double preferredSuccessRate = 0.0;
        Iterator iterator = this.defensiveTargetingMethods.iterator();
        while (iterator.hasNext()) {
            TargetingMethod targetingMethod = (TargetingMethod)iterator.next();
            double successRate = targetingMethod.getTargetingStatistics().getSuccessRate();
            if (preferredTargetingMethod != null && !(successRate > preferredSuccessRate)) continue;
            preferredTargetingMethod = targetingMethod;
            preferredSuccessRate = successRate;
        }
        return preferredTargetingMethod;
    }

    public WaveAnalysis assignOffensiveWaveAnalysis(WaveAnalysis waveAnalysis) {
        this.offensiveWaveAnalyses.add(waveAnalysis);
        return waveAnalysis;
    }

    public WaveAnalysis assignDefensiveWaveAnalysis(WaveAnalysis waveAnalysis) {
        this.defensiveWaveAnalyses.add(waveAnalysis);
        return waveAnalysis;
    }

    public void recordOffensiveWave(WaveData waveData) {
        Iterator iterator = this.offensiveWaveAnalyses.iterator();
        while (iterator.hasNext()) {
            ((WaveAnalysis)iterator.next()).recordWave(waveData);
        }
    }

    public void recordDefensiveWave(WaveData waveData) {
        Iterator iterator = this.defensiveWaveAnalyses.iterator();
        while (iterator.hasNext()) {
            ((WaveAnalysis)iterator.next()).recordWave(waveData);
        }
    }

    public void onOffensiveFire() {
        Iterator iterator = this.offensiveWaveAnalyses.iterator();
        while (iterator.hasNext()) {
            ((WaveAnalysis)iterator.next()).onFire();
        }
        iterator = this.offensiveTargetingMethods.iterator();
        while (iterator.hasNext()) {
            ((TargetingMethod)iterator.next()).onFire();
        }
    }

    public void onDefensiveFire() {
        Iterator iterator = this.defensiveWaveAnalyses.iterator();
        while (iterator.hasNext()) {
            ((WaveAnalysis)iterator.next()).onFire();
        }
        iterator = this.defensiveTargetingMethods.iterator();
        while (iterator.hasNext()) {
            ((TargetingMethod)iterator.next()).onFire();
        }
    }

    public void roundTearDown() {
        this.deactivate();
    }

    public void teardown() {
    }

    public void onPaint(Graphics2D console) {
        if (this.isActive()) {
            console.setColor(Color.red);
            GraphicalDebugger.singleton.drawRing(console, this, 150.0);
            console.setColor(Color.darkGray);
            GraphicalDebugger.singleton.drawVehicleHitBox(console, this);
        }
    }

    public void receiveBulletDamage(double damage) {
        this.energyTracker.add(-damage);
        this.totalBulletDamageReceived += damage;
    }

    public void dealBulletDamage(double firepower) {
        this.energyTracker.add(Conversions.getEnergyRewardFromFirepower(firepower));
        this.totalBulletDamageDealt += Conversions.getBulletDamageFromFirepower(firepower);
    }

    public MovementMethodSet getMovementMethods() {
        return this.movementMethods;
    }

    public void setFireControl(FireControl newFireControl) {
        this.fireControl = newFireControl;
    }

    public FireControl getFireControl() {
        return this.fireControl;
    }

    public void activate() {
        this.isActive = true;
    }

    public void deactivate() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void setLastShotFired(long time) {
        this.lastShotFired = time;
    }

    private long getLastShotFired() {
        return this.lastShotFired;
    }

    private void setLastShotFirepower(double firepower) {
        this.lastShotFirepower = firepower;
    }

    private double getLastShotFirepower() {
        return this.lastShotFirepower;
    }

    public void debug() {
        Debug.debug("Target: " + this.name);
        Iterator iterator = this.defensiveTargetingMethods.iterator();
        while (iterator.hasNext()) {
            ((TargetingMethod)iterator.next()).debug();
        }
        iterator = this.movementMethods.getDynamicMovementMethods().iterator();
        while (iterator.hasNext()) {
            ((MovementMethod)iterator.next()).debug();
        }
        super.debug();
    }

    public String getName() {
        return this.name;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }
}

