/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

import dmonner.xlbp.Component;
import dmonner.xlbp.compound.WeightBank;
import dmonner.xlbp.connection.Connection;
import java.util.HashMap;
import java.util.Map;

public class NetworkCopier {
    private final Map<String, Component> copies = new HashMap<String, Component>();
    private final Map<String, Component> originals = new HashMap<String, Component>();
    private final Map<String, WeightBank> banks = new HashMap<String, WeightBank>();
    private String prefix;
    private String suffix;
    private boolean copyState;
    private boolean copyWeights;

    public NetworkCopier() {
        this("");
    }

    public NetworkCopier(String suffix) {
        this(suffix, false, false);
    }

    public NetworkCopier(String suffix, boolean copyState, boolean copyWeights) {
        this("", suffix, copyState, copyWeights);
    }

    public NetworkCopier(String prefix, String suffix, boolean copyState, boolean copyWeights) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.copyState = copyState;
        this.copyWeights = copyWeights;
    }

    public void addWeightBank(WeightBank bank) {
        this.originals.put(bank.getName(), bank);
        this.banks.put(bank.getName(), bank);
    }

    public void build() {
        for (WeightBank bank : this.banks.values()) {
            if (!this.copyExists(bank.getUpstream()) || !this.copyExists(bank.getDownstream())) continue;
            this.getCopyOf(bank);
        }
        for (Component orig : this.originals.values()) {
            this.copies.get(orig.getName()).copyConnectivityFrom(orig, this);
        }
        for (Component orig : this.originals.values()) {
            if (!orig.isBuilt()) continue;
            this.copies.get(orig.getName()).build();
        }
    }

    public void clear() {
        this.originals.clear();
        this.copies.clear();
    }

    public boolean copyExists(Component component) {
        return this.copies.containsKey(component.getName());
    }

    public boolean copyState() {
        return this.copyState;
    }

    public void copyState(boolean copyState) {
        this.copyState = copyState;
    }

    public boolean copyWeights() {
        return this.copyWeights;
    }

    public void copyWeights(boolean copyWeights) {
        this.copyWeights = copyWeights;
    }

    public <C extends Component> C getCopyIfExists(C component) {
        if (component == null) {
            return null;
        }
        return (C)this.copies.get(component.getName());
    }

    public String getCopyNameFrom(Component component) {
        return this.prefix + component.getName() + this.suffix;
    }

    public String getCopyNameFrom(Connection connection) {
        return this.prefix + connection.getName() + this.suffix;
    }

    public <C extends Component> C getCopyOf(C component) {
        Component copy;
        if (component == null) {
            return null;
        }
        Component existing = this.originals.get(component.getName());
        if (existing != null && existing != component) {
            throw new IllegalStateException("Duplicate component names detected: " + component.getName());
        }
        if (existing == null) {
            this.originals.put(component.getName(), component);
        }
        if ((copy = this.copies.get(component.getName())) == null) {
            copy = component.copy(this);
            this.copies.put(component.getName(), copy);
        }
        return (C)copy;
    }

    public String getNamePrefix() {
        return this.prefix;
    }

    public String getNameSuffix() {
        return this.suffix;
    }

    public void setNamePrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setNameSuffix(String suffix) {
        this.suffix = suffix;
    }
}

