/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.compound;

import dmonner.xlbp.Component;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.compound.AbstractWeightedCompound;
import dmonner.xlbp.compound.WeightBank;
import dmonner.xlbp.layer.AbstractLayer;
import dmonner.xlbp.layer.DownstreamLayer;
import dmonner.xlbp.layer.FanOutLayer;
import dmonner.xlbp.layer.SigmaLayer;
import dmonner.xlbp.layer.UpstreamLayer;
import dmonner.xlbp.util.MatrixTools;
import java.util.ArrayList;

public class SimpleCompound
extends AbstractWeightedCompound {
    private static final long serialVersionUID = 1L;
    private final int size;
    private SigmaLayer net;
    private FanOutLayer fan;
    private Component[] activate;

    public SimpleCompound(SimpleCompound that, NetworkCopier copier) {
        super(that, copier);
        this.size = that.size;
        this.net = copier.getCopyOf(that.net);
        this.fan = copier.getCopyOf(that.fan);
        this.activate = new Component[that.activate.length];
        for (int i = 0; i < that.activate.length; ++i) {
            this.activate[i] = copier.getCopyOf(that.activate[i]);
        }
        this.in = copier.getCopyOf(that.in);
        this.out = copier.getCopyOf(that.out);
    }

    public SimpleCompound(String name, int size) {
        super(name);
        this.size = size;
        this.net = new SigmaLayer(name + "Net", size);
        this.fan = new FanOutLayer(name + "Fanout", size);
        this.fan.addUpstream(this.net);
        this.activate = new Component[]{this.net, this.fan};
        this.in = this.net;
        this.out = this.fan;
    }

    @Override
    public void activateTest() {
        super.activateTest();
        for (int i = 0; i < this.activate.length; ++i) {
            this.activate[i].activateTest();
        }
    }

    @Override
    public void activateTrain() {
        super.activateTrain();
        for (int i = 0; i < this.activate.length; ++i) {
            this.activate[i].activateTrain();
        }
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            for (Component component : this.activate) {
                component.build();
            }
            this.built = true;
        }
    }

    @Override
    public void clearActivations() {
        super.clearActivations();
        for (int i = 0; i < this.activate.length; ++i) {
            this.activate[i].clearActivations();
        }
    }

    @Override
    public void clearEligibilities() {
        super.clearEligibilities();
        for (int i = 0; i < this.activate.length; ++i) {
            this.activate[i].clearEligibilities();
        }
    }

    @Override
    public void clearResponsibilities() {
        super.clearResponsibilities();
        for (int i = 0; i < this.activate.length; ++i) {
            this.activate[i].clearResponsibilities();
        }
    }

    @Override
    public SimpleCompound copy(NetworkCopier copier) {
        return new SimpleCompound(this, copier);
    }

    @Override
    public SimpleCompound copy(String nameSuffix) {
        NetworkCopier copier = new NetworkCopier(nameSuffix);
        SimpleCompound copy = this.copy(copier);
        copier.build();
        return copy;
    }

    @Override
    public Component[] getComponents() {
        return (Component[])this.activate.clone();
    }

    @Override
    public boolean optimize() {
        if (!super.optimize()) {
            return false;
        }
        ArrayList<AbstractLayer> activate = new ArrayList<AbstractLayer>(2);
        if (this.net != null) {
            if (this.net.optimize()) {
                activate.add(this.net);
            } else {
                this.net = null;
            }
        }
        if (this.fan != null) {
            if (this.fan.optimize()) {
                activate.add(this.fan);
            } else {
                this.fan = null;
            }
        }
        this.activate = activate.toArray(new Component[activate.size()]);
        this.in = (DownstreamLayer)((Object)(this.net == null ? this.fan : this.net));
        this.out = this.activate.length == 0 ? null : (UpstreamLayer)this.activate[this.activate.length - 1];
        return true;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showIntermediate()) {
            super.toString(sb);
            sb.pushIndent();
            for (int i = this.activate.length - 1; i >= 0; --i) {
                this.activate[i].toString(sb);
            }
            for (WeightBank bank : this.conn) {
                bank.toString(sb);
            }
            sb.popIndent();
        } else {
            super.toString(sb);
            sb.pushIndent();
            if (sb.showStates() && this.net != null) {
                sb.appendln("States:");
                sb.pushIndent();
                sb.appendln(MatrixTools.toString(this.net.getActivations()));
                sb.popIndent();
            }
            if (sb.showResponsibilities()) {
                sb.appendln("Responsibilities:");
                sb.pushIndent();
                sb.appendln(this.net.getResponsibilities().toString());
                sb.popIndent();
            }
            for (WeightBank bank : this.conn) {
                bank.getConnection().toString(sb);
            }
            sb.popIndent();
        }
    }

    @Override
    public void unbuild() {
        super.unbuild();
        for (Component component : this.activate) {
            component.unbuild();
        }
    }

    @Override
    public void updateEligibilities() {
        for (int i = this.activate.length - 1; i >= 0; --i) {
            this.activate[i].updateEligibilities();
        }
        super.updateEligibilities();
    }

    @Override
    public void updateResponsibilities() {
        for (int i = this.activate.length - 1; i >= 0; --i) {
            this.activate[i].updateResponsibilities();
        }
        super.updateResponsibilities();
    }

    @Override
    public void updateWeights() {
        for (int i = this.activate.length - 1; i >= 0; --i) {
            this.activate[i].updateWeights();
        }
        super.updateWeights();
    }
}

