/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.InputComponent;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.layer.AbstractUpstreamLayer;
import dmonner.xlbp.util.MatrixTools;
import java.util.Arrays;

public class InputLayer
extends AbstractUpstreamLayer
implements InputComponent {
    private static final long serialVersionUID = 1L;
    private boolean zeroed;

    public InputLayer(InputLayer that, NetworkCopier copier) {
        super(that, copier);
        this.zeroed = copier.copyState() ? that.zeroed : true;
    }

    public InputLayer(String name, int size) {
        super(name, size);
        this.zeroed = true;
    }

    @Override
    public void activateTest() {
    }

    @Override
    public void activateTrain() {
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            this.y = new float[this.size];
            this.d = new Responsibilities(this.size);
            this.built = true;
        }
    }

    @Override
    public void clearActivations() {
        if (!this.zeroed) {
            Arrays.fill(this.y, 0.0f);
            this.zeroed = true;
        }
    }

    @Override
    public InputLayer copy(NetworkCopier copier) {
        return new InputLayer(this, copier);
    }

    @Override
    public InputLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    public void setFilled() {
        this.zeroed = false;
    }

    @Override
    public void setInput(float[] activations) {
        System.arraycopy(activations, 0, this.y, 0, this.size);
        this.zeroed = false;
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showName()) {
            sb.indent();
            sb.append(this.name);
            sb.append(" (");
            sb.append(String.valueOf(this.size()));
            sb.append(")");
            sb.append(" : ");
            sb.append(this.getClass().getSimpleName());
            sb.appendln();
        }
        sb.pushIndent();
        if (sb.showActivations()) {
            sb.appendln("Inputs:");
            sb.pushIndent();
            sb.appendln(MatrixTools.toString(this.y));
            sb.popIndent();
        }
        sb.popIndent();
    }

    @Override
    public void updateEligibilities() {
    }

    @Override
    public void updateResponsibilities() {
    }
}

