/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.Map;

public class ErrorStat
extends AbstractStat {
    private final String name;
    private float sse;
    private float mse;
    private float rmse;
    private int n;

    public ErrorStat() {
        this("");
    }

    public ErrorStat(ErrorStat that) {
        this.name = that.name;
        this.sse = that.sse;
        this.n = that.n;
        this.mse = that.mse;
        this.rmse = that.rmse;
    }

    public ErrorStat(String name) {
        this.name = name;
    }

    public void add(ErrorStat that) {
        this.sse += that.sse;
        this.n += that.n;
    }

    @Override
    public void add(Stat that) {
        if (!(that instanceof ErrorStat)) {
            throw new IllegalArgumentException("Can only add in other ErrorStats.");
        }
        this.add((ErrorStat)that);
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        map.put(prefix + this.name + "N", this.n);
        map.put(prefix + this.name + "SSE", Float.valueOf(this.sse));
        map.put(prefix + this.name + "MSE", Float.valueOf(this.mse));
        map.put(prefix + this.name + "RMSE", Float.valueOf(this.rmse));
    }

    @Override
    public void analyze() {
        this.mse = this.sse / (float)this.n;
        this.rmse = (float)Math.sqrt(this.mse);
    }

    @Override
    public void clear() {
        this.sse = 0.0f;
        this.mse = 0.0f;
        this.rmse = 0.0f;
        this.n = 0;
    }

    public void compare(float[] target, float[] output) {
        for (int i = 0; i < target.length; ++i) {
            float diff = target[i] - output[i];
            this.sse += diff * diff;
        }
        this.n += target.length;
    }

    public float getMSE() {
        return this.mse;
    }

    public int getN() {
        return this.n;
    }

    public float getRMSE() {
        return this.rmse;
    }

    public float getSSE() {
        return this.sse;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        out.appendField(this.n);
        out.appendField(this.sse);
        out.appendField(this.mse);
        out.appendField(this.rmse);
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        out.appendHeader(prefix + this.name + "N");
        out.appendHeader(prefix + this.name + "SSE");
        out.appendHeader(prefix + this.name + "MSE");
        out.appendHeader(prefix + this.name + "RMSE");
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        String prename = prefix + this.name;
        sb.append(prename);
        sb.append("N = ");
        sb.append(this.n);
        sb.append("\n");
        sb.append(prename);
        sb.append("SSE = ");
        sb.append(this.sse);
        sb.append("\n");
        sb.append(prename);
        sb.append("MSE = ");
        sb.append(this.mse);
        sb.append("\n");
        sb.append(prename);
        sb.append("RMSE = ");
        sb.append(this.rmse);
        sb.append("\n");
        return sb.toString();
    }
}

