/*
 * Decompiled with CFR 0.152.
 */
package zezinho.virtualGuns;

import java.awt.geom.Point2D;

public class VirtualBullet {
    private double myHeading;
    private double headSin;
    private double headCos;
    private double myPower;
    private double myVelocity;
    private double myX;
    private double myY;
    private Point2D.Double myPosition;
    private String victim;
    private boolean active = true;

    public static double calcBulletVelocity(double firepower) {
        return 20.0 - 3.0 * firepower;
    }

    VirtualBullet(double headingRads, double power, double startX, double startY) {
        this.myX = startX;
        this.myY = startY;
        this.myPosition = new Point2D.Double(this.myX, this.myY);
        this.myPower = power;
        this.myVelocity = VirtualBullet.calcBulletVelocity(power);
        this.myHeading = headingRads;
        this.headSin = Math.sin(this.myHeading);
        this.headCos = Math.cos(this.myHeading);
    }

    public void update() {
        if (this.active) {
            this.myX += this.headSin * this.myVelocity;
            this.myY += this.headCos * this.myVelocity;
            this.myPosition.setLocation(this.myX, this.myY);
        }
    }

    public void setVictim(String name) {
        this.victim = name;
        this.setInactive();
    }

    public void setInactive() {
        this.active = false;
    }

    public double getHeading() {
        return this.myHeading;
    }

    public boolean isActive() {
        return this.active;
    }

    public double getVelocity() {
        return this.myVelocity;
    }

    public double getX() {
        return this.myX;
    }

    public double getY() {
        return this.myY;
    }

    public Point2D.Double getPosition() {
        return this.myPosition;
    }

    public double getPower() {
        return this.myPower;
    }

    public String getVictim() {
        return this.victim;
    }
}

