/*
 * Decompiled with CFR 0.152.
 */
package wiki.mini;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;

public class GouldingiHT
extends AdvancedRobot {
    private static Point2D location = new Point2D.Double();
    private static Point2D oldLocation = new Point2D.Double();
    private static Point2D enemyLocation = new Point2D.Double();
    private static Point2D oldEnemyLocation = new Point2D.Double();
    private static Rectangle2D fieldRectangle;
    private static double enemyDistance;
    private static double enemyEnergy;
    private static double deltaBearing;
    private static double meanOffsetFactor;
    private static double meanAimFactorLeft;
    private static double meanAimFactorStraight;
    private static double meanAimFactorRight;
    private static double currentDirection;
    private static double currentVBound;
    private static int distanceindex;
    private static double[] benefit;
    private static double[] penalty;
    private long nextTime;

    public void run() {
        fieldRectangle = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.setColors(Color.gray, Color.yellow, Color.black);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        enemyEnergy = 100.0;
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            double power;
            Bullet bullet;
            this.initMovement();
            if (this.getEnergy() > 0.2 && (bullet = this.setFireBullet(power = Math.min(this.getEnergy() / 3.0, Math.min(enemyEnergy / 4.0, 3.0)))) != null) {
                int n = distanceindex;
                penalty[n] = penalty[n] + power;
                this.addCustomEvent(new CheckUpdateFactors(bullet));
            }
            this.setAhead(currentDirection);
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        oldLocation.setLocation(location);
        location.setLocation(this.getX(), this.getY());
        oldEnemyLocation.setLocation(enemyLocation);
        enemyDistance = e.getDistance();
        this.toLocation(this.getHeadingRadians() + e.getBearingRadians(), enemyDistance, location, enemyLocation);
        double denergy = enemyEnergy - e.getEnergy();
        if (denergy >= 0.09 && denergy <= 3.0) {
            int n = distanceindex;
            benefit[n] = benefit[n] + denergy;
            if (this.getTime() >= this.nextTime) {
                if (Math.random() < 0.5) {
                    currentDirection = -currentDirection;
                }
                currentVBound = Math.random() * 20.0;
                this.nextTime = this.getTime() + (long)((int)(enemyDistance / (30.0 - 4.5 * denergy)));
            }
        }
        enemyEnergy = e.getEnergy();
        this.move(e);
        this.aim();
        this.setTurnRadarLeftRadians(this.getRadarTurnRemaining());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double power = e.getPower();
        int n = distanceindex;
        penalty[n] = penalty[n] + Math.max(power * 7.0, power * 9.0 - 2.0);
    }

    public void onBulletHit(BulletHitEvent e) {
        double power = e.getBullet().getPower();
        double damage = Math.max(4.0 * power, 6.0 * power - 2.0);
        int n = distanceindex;
        benefit[n] = benefit[n] + (damage + power * 3.0);
    }

    private final void initMovement() {
        double maxX = this.getBattleFieldWidth() - 18.0;
        double maxY = this.getBattleFieldHeight() - 18.0;
        this.setMaxVelocity(currentVBound);
        double futureX = currentDirection * Math.sin(this.getHeadingRadians()) + this.getX();
        double futureY = currentDirection * Math.cos(this.getHeadingRadians()) + this.getY();
        if (futureX < 18.0 || futureY < 18.0 || futureX > maxX || futureY > maxY) {
            currentDirection = -currentDirection;
        }
    }

    private final double distanceFromCorner() {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < 4) {
            min = Math.min(min, Point2D.distance(this.getX(), this.getY(), (double)(i & 1) * this.getBattleFieldWidth(), (double)(i >> 1) * this.getBattleFieldHeight()));
            ++i;
        }
        return min;
    }

    private final void move(ScannedRobotEvent e) {
        double rel;
        double d;
        distanceindex = (int)(enemyDistance / 50.0);
        Point2D.Double backwall = new Point2D.Double();
        this.toLocation(this.absoluteBearing(enemyLocation, location), 30.0, location, backwall);
        double mindist = this.findDistanceBracket() + 85.0;
        if ((e.getDistance() < mindist && enemyDistance > mindist - 120.0 && this.distanceFromCorner() > 200.0 && this.distanceFromCorner() > enemyDistance) | !fieldRectangle.contains(backwall)) {
            d = 1.5707963267948966;
        } else if ((e.getDistance() > mindist || this.distanceFromCorner() < 200.0) == currentDirection > 0.0) {
            d = 1.0471975511965976;
        } else {
            rel = 2.0943951023931953;
        }
        this.setTurnRightRadians(this.normalRelativeAngle(e.getBearingRadians() - rel));
    }

    private final double findDistanceBracket() {
        int bestindex = 4;
        int i = 5;
        while (i <= 14) {
            if (this.findBenefit(i) > this.findBenefit(bestindex)) {
                bestindex = i;
            }
            ++i;
        }
        return bestindex * 50;
    }

    private final double findBenefit(int index) {
        return (benefit[index] - penalty[index]) / (benefit[index] + penalty[index]);
    }

    private final void aim() {
        double meanAimFactor = meanAimFactorStraight;
        deltaBearing = this.normalRelativeAngle(this.absoluteBearing(oldLocation, enemyLocation) - this.absoluteBearing(oldLocation, oldEnemyLocation));
        if (deltaBearing < -0.005) {
            meanAimFactor = meanAimFactorLeft;
        } else if (deltaBearing > 0.005) {
            meanAimFactor = meanAimFactorRight;
        }
        double absoluteBearing = this.absoluteBearing(location, enemyLocation);
        double guessedHeading = absoluteBearing + meanOffsetFactor;
        if (Math.abs(deltaBearing) > 0.001) {
            guessedHeading = absoluteBearing + deltaBearing * meanAimFactor;
        }
        Point2D.Double impactLocation = new Point2D.Double();
        this.toLocation(guessedHeading, enemyDistance, location, impactLocation);
        guessedHeading = this.absoluteBearing(location, impactLocation);
        this.setTurnGunRightRadians(this.normalRelativeAngle(guessedHeading - this.getGunHeadingRadians()));
    }

    private final void toLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    private final double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    private final double normalRelativeAngle(double angle) {
        return Math.atan2(Math.sin(angle), Math.cos(angle));
    }

    public double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    static {
        currentDirection = 40.0;
        benefit = new double[100];
        penalty = new double[100];
    }

    class CheckUpdateFactors
    extends Condition {
        private long time;
        private double bulletVelocity;
        private double bulletPower;
        private double bearingDelta;
        private Point2D oldRLocation = new Point2D.Double();
        private Point2D oldELocation = new Point2D.Double();

        public boolean test() {
            double bulletDistance = this.bulletVelocity * (double)(GouldingiHT.this.getTime() - this.time);
            if (GouldingiHT.this.getOthers() > 0 && bulletDistance > location.distance(enemyLocation) - 10.0) {
                double bearingDiff = GouldingiHT.this.normalRelativeAngle(GouldingiHT.this.absoluteBearing(this.oldRLocation, enemyLocation) - GouldingiHT.this.absoluteBearing(this.oldRLocation, this.oldELocation));
                meanOffsetFactor = GouldingiHT.this.rollingAvg(meanOffsetFactor, bearingDiff, 20.0, this.bulletPower);
                if (Math.abs(this.bearingDelta) > 0.001) {
                    double factor = bearingDiff / this.bearingDelta;
                    if (this.bearingDelta < -0.05) {
                        meanAimFactorLeft = GouldingiHT.this.rollingAvg(meanAimFactorLeft, factor, 75.0, this.bulletPower);
                    } else if (this.bearingDelta > 0.05) {
                        meanAimFactorRight = GouldingiHT.this.rollingAvg(meanAimFactorRight, factor, 75.0, this.bulletPower);
                    } else {
                        meanAimFactorStraight = GouldingiHT.this.rollingAvg(meanAimFactorStraight, factor, 75.0, this.bulletPower);
                    }
                }
                GouldingiHT.this.removeCustomEvent(this);
            }
            return false;
        }

        public CheckUpdateFactors(Bullet bullet) {
            this.time = GouldingiHT.this.getTime();
            this.bulletVelocity = bullet.getVelocity();
            this.bulletPower = bullet.getPower();
            this.bearingDelta = deltaBearing;
            this.oldRLocation.setLocation(location);
            this.oldELocation.setLocation(enemyLocation);
        }
    }
}

