/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

import muf.utils.Rutils;

public class GameData {
    public long time;
    public double myX;
    public double myY;
    public double myHeading;
    public double myGunHeading;
    public double myEnergy;
    public double myVelocity;
    public double enemyBearing;
    public double enemyDistance;
    public double enemyHeading;
    public double enemyEnergy;
    public double enemyVelocity;
    public double enemyX;
    public double enemyY;
    public double enemyRelHeading;
    public double enemyAbsBearing;
    public double firedBulletPower;
    public boolean empty;

    public GameData() {
        this.empty = true;
    }

    public GameData(GameData gameData) {
        this.update(gameData.time, gameData.myX, gameData.myY, gameData.myHeading, gameData.myGunHeading, gameData.myEnergy, gameData.myVelocity, gameData.enemyBearing, gameData.enemyDistance, gameData.enemyHeading, gameData.enemyEnergy, gameData.enemyVelocity);
        this.firedBulletPower = gameData.firedBulletPower;
    }

    public GameData(long l, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        this.update(l, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11);
    }

    public void update(long l, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        this.time = l;
        this.myX = d;
        this.myY = d2;
        this.myHeading = d3;
        this.myGunHeading = d4;
        this.myEnergy = d5;
        this.myVelocity = d6;
        this.enemyBearing = d7;
        this.enemyDistance = d8;
        this.enemyHeading = d9;
        this.enemyEnergy = d10;
        this.enemyVelocity = d11;
        this.empty = false;
        this.firedBulletPower = 0.0;
        this.refresh();
    }

    public void refresh() {
        this.enemyAbsBearing = Rutils.normalAbsoluteAngle(this.myHeading + this.enemyBearing);
        this.enemyRelHeading = Rutils.normalRelativeAngle(180.0 + this.enemyAbsBearing - this.enemyHeading);
        this.enemyX = this.myX + this.enemyDistance * Rutils.sin(this.enemyAbsBearing);
        this.enemyY = this.myY + this.enemyDistance * Rutils.cos(this.enemyAbsBearing);
    }
}

