/*
 * Decompiled with CFR 0.152.
 */
package MyRobots;

import robocode.AdvancedRobot;
import robocode.util.Utils;

public class Drive {
    private AdvancedRobot robot;

    public Drive(AdvancedRobot r) {
        this.robot = r;
    }

    public double absoluteAngle(double r) {
        if ((r %= 360.0) < 0.0) {
            r = 360.0 + r;
        }
        return r;
    }

    public void vector(double x, double y) {
        double targetAngle = this.absoluteAngle(Math.toDegrees(Math.atan2(x, y)));
        double errorAngle = targetAngle - this.robot.getHeading();
        double errorDistance = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        if (errorDistance == 0.0) {
            return;
        }
        errorAngle = Utils.normalRelativeAngleDegrees((double)errorAngle);
        this.robot.setTurnRight(errorAngle);
        this.robot.setAhead(errorDistance);
    }

    public double go(double x, double y) {
        double errorX = x - this.robot.getX();
        double errorY = y - this.robot.getY();
        double errorDistance = Math.sqrt(Math.pow(errorX, 2.0) + Math.pow(errorY, 2.0));
        if (x < 0.0 || this.robot.getBattleFieldWidth() < x || y < 0.0 || this.robot.getBattleFieldHeight() < y) {
            return Double.NaN;
        }
        this.vector(errorX, errorY);
        return errorDistance;
    }

    public double relative(double x, double y) {
        double error = this.go(this.robot.getBattleFieldWidth() * x, this.robot.getBattleFieldHeight() * y);
        return error;
    }
}

