/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.projection;

import benhorner.utility.projection.Projection;
import benhorner.utility.units.Distance;
import benhorner.utility.units.Duration;
import benhorner.utility.units.Location;
import benhorner.utility.units.Speed;
import benhorner.utility.units.Units;
import benhorner.utility.units.Velocity;

public class LinearProjector {
    private Distance min_x;
    private Distance max_x;
    private Distance min_y;
    private Distance max_y;
    public static final Speed min_my_speed = new Speed(1.0);

    public LinearProjector(double min_x, double max_x, double min_y, double max_y) {
        this.min_x = new Distance(min_x);
        this.max_x = new Distance(max_x);
        this.min_y = new Distance(min_y);
        this.max_y = new Distance(max_y);
    }

    public Projection project(Location location, Velocity velocity, Duration dur) {
        return new Projection(location.add(velocity.multiply(dur)), dur);
    }

    public Projection projectToWall(Location loc, Velocity vel) {
        assert (vel.getSpeed().toDouble() != 0.0);
        assert (loc.getX().toDouble() >= this.min_x.toDouble());
        assert (loc.getX().toDouble() <= this.max_x.toDouble());
        assert (loc.getY().toDouble() >= this.min_y.toDouble());
        assert (loc.getY().toDouble() <= this.max_y.toDouble());
        Duration intersect_time = new Duration(Double.POSITIVE_INFINITY);
        if (Units.signum(vel.getXSpeed()) < 0.0) {
            intersect_time = Units.min(this.min_x.subtract(loc.getX()).divide(vel.getXSpeed()), intersect_time);
        }
        if (Units.signum(vel.getXSpeed()) > 0.0) {
            intersect_time = Units.min(this.max_x.subtract(loc.getX()).divide(vel.getXSpeed()), intersect_time);
        }
        if (Units.signum(vel.getYSpeed()) < 0.0) {
            intersect_time = Units.min(this.min_y.subtract(loc.getY()).divide(vel.getYSpeed()), intersect_time);
        }
        if (Units.signum(vel.getYSpeed()) > 0.0) {
            intersect_time = Units.min(this.max_y.subtract(loc.getY()).divide(vel.getYSpeed()), intersect_time);
        }
        return new Projection(loc.add(vel.multiply(intersect_time)), intersect_time);
    }

    public Projection project(Location enemy_loc, Velocity enemy_vel, Location my_loc, Velocity my_vel) {
        Speed my_speed = my_vel.getSpeed();
        if (my_speed.toDouble() == 0.0) {
            my_speed = new Speed(1.0);
        }
        Projection to_wall = null;
        if (enemy_vel.getSpeed().toDouble() != 0.0) {
            to_wall = this.projectToWall(enemy_loc, enemy_vel);
        }
        Projection collision = null;
        Duration one_turn = new Duration(1.0);
        Duration dur = new Duration(0.0);
        while (collision == null && (to_wall == null || Units.lessOrEqual(dur, to_wall.getDuration()))) {
            Location new_enemy_loc = enemy_loc.add(enemy_vel.multiply(dur));
            if (Units.lessOrEqual(my_loc.getDistanceTo(new_enemy_loc).divide(my_speed), dur)) {
                collision = new Projection(new_enemy_loc, dur);
            }
            dur = dur.add(one_turn);
        }
        assert (to_wall != null || collision != null);
        return collision == null ? to_wall : collision;
    }
}

