/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.units;

import benhorner.utility.units.Angle;
import benhorner.utility.units.Bearing;
import benhorner.utility.units.Distance;
import benhorner.utility.units.Duration;
import benhorner.utility.units.Speed;

public class Units {
    public static final Angle FULL_CIRCLE = new Angle(360.0);
    public static final Angle HALF_CIRCLE = new Angle(180.0);

    public static Angle atan2(Distance y, Distance x) {
        return new Angle(Math.toDegrees(Math.atan2(y.toDouble(), x.toDouble())));
    }

    public static double sin(Angle angle) {
        return Math.sin(angle.toRadians());
    }

    public static double cos(Angle angle) {
        return Math.cos(angle.toRadians());
    }

    public static Bearing abs(Bearing bearing) {
        return new Bearing(Math.abs(bearing.toDouble()));
    }

    public static Speed abs(Speed speed) {
        return new Speed(Math.abs(speed.toDouble()));
    }

    public static Bearing min(Bearing b1, Bearing b2) {
        return b1.toDegrees() < b2.toDegrees() ? b1 : b2;
    }

    public static Duration min(Duration d1, Duration d2) {
        return d1.toDouble() < d2.toDouble() ? d1 : d2;
    }

    public static double sign(Bearing bearing) {
        double result = Math.signum(bearing.toDegrees());
        result = result == 0.0 ? 1.0 : result;
        return result;
    }

    public static double signum(Speed speed) {
        return Math.signum(speed.toDouble());
    }

    public static Speed max(Speed s1, Speed s2) {
        return s1.toDouble() > s2.toDouble() ? s1 : s2;
    }

    public static Bearing max(Bearing b1, Bearing b2) {
        return b1.toDouble() > b2.toDouble() ? b1 : b2;
    }

    public static boolean lessOrEqual(Duration d1, Duration d2) {
        return d1.toDouble() <= d2.toDouble();
    }

    public static boolean less(Bearing b1, Bearing b2) {
        return b1.toDouble() < b2.toDouble();
    }

    public static boolean lessOrEqual(Bearing b1, Bearing b2) {
        return b1.toDouble() <= b2.toDouble();
    }
}

