/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.core.wiki;

public final class FastMath {
    public static final double PI = Math.PI;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double QUARTER_PI = 0.7853981633974483;
    public static final double THREE_OVER_TWO_PI = 4.71238898038469;
    private static final int TRIG_DIVISIONS = 8192;
    private static final int TRIG_HIGH_DIVISIONS = 131072;
    private static final double K = 1303.7972938088067;
    private static final double ACOS_K = 65535.0;
    private static final double TAN_K = 41721.51340188181;
    private static final double[] sineTable;
    private static final double[] tanTable;
    private static final double[] acosTable;

    public static final void init() {
        FastMath.sineTable[0] = sineTable[0];
    }

    public static final double sin(double value) {
        return sineTable[(int)((value * 1303.7972938088067 + 0.5) % 8192.0 + 8192.0) & 0x1FFF];
    }

    public static final double cos(double value) {
        return sineTable[(int)((value * 1303.7972938088067 + 0.5) % 8192.0 + 10240.0) & 0x1FFF];
    }

    public static final double tan(double value) {
        return tanTable[(int)((value * 41721.51340188181 + 0.5) % 131072.0 + 131072.0) & 0x1FFFF];
    }

    public static final double asin(double value) {
        return 1.5707963267948966 - FastMath.acos(value);
    }

    public static final double pow(double a, double b) {
        long tmp = Double.doubleToLongBits(a);
        long tmp2 = (long)(b * (double)(tmp - 4606921280493453312L)) + 4606921280493453312L;
        return Double.longBitsToDouble(tmp2);
    }

    public static final double acos(double value) {
        return acosTable[(int)(value * 65535.0 + 65535.5)];
    }

    public static final double atan(double value) {
        return value >= 0.0 ? FastMath.acos(1.0 / FastMath.sqrt(value * value + 1.0)) : -FastMath.acos(1.0 / FastMath.sqrt(value * value + 1.0));
    }

    public static final double atan2(double x, double y) {
        return x >= 0.0 ? FastMath.acos(y / FastMath.sqrt(x * x + y * y)) : -FastMath.acos(y / FastMath.sqrt(x * x + y * y));
    }

    public static final double sqrt(double x) {
        return Math.sqrt(x);
    }

    static {
        int i;
        sineTable = new double[8192];
        tanTable = new double[131072];
        acosTable = new double[131072];
        for (i = 0; i < 8192; ++i) {
            FastMath.sineTable[i] = Math.sin((double)i / 1303.7972938088067);
        }
        for (i = 0; i < 131072; ++i) {
            FastMath.tanTable[i] = Math.tan((double)i / 41721.51340188181);
            FastMath.acosTable[i] = Math.acos((double)i / 65535.0 - 1.0);
        }
    }
}

