/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rGun;

import dsekercioglu.mega.rGun.BattleInfo;
import dsekercioglu.mega.rGun.Claws;
import dsekercioglu.mega.rGun.GunUtils;

public class FirePowerManager {
    static final double STD_FIRE_POWER = 2.0;
    static final double AVERAGING_FACTOR = 0.5;
    private static final double INVERSE_SQRT_2_PI = 1.0 / Math.sqrt(Math.PI * 2);
    private double averageFirePower = 2.0;
    private double averageDistance = 450.0;
    private static final double FUTURE_TICKS = 50.0;
    private final Claws GUN;

    public FirePowerManager(Claws gun) {
        this.GUN = gun;
    }

    public void onFire(double firePower, BattleInfo battleInfo) {
        this.averageFirePower = this.averageFirePower * 0.5 + firePower * 0.5;
        this.averageDistance = this.averageDistance * 0.5 + battleInfo.getBotDistance() * 0.5;
    }

    public double firePower(BattleInfo battleInfo) {
        double firePower;
        double robotEnergy = battleInfo.getBotEnergy();
        double enemyEnergy = battleInfo.getEnemyEnergy();
        double neededAmountToKill = enemyEnergy <= 4.0 ? enemyEnergy / 4.0 : (enemyEnergy + 2.0) / 6.0;
        double hitRate = 1.0 * this.GUN.bulletsHit / this.GUN.bulletsShot;
        double farDistanceFirePower = 1200.0 / battleInfo.getBotDistance();
        double lowEnergyFirePower = robotEnergy / 20.0;
        double d = firePower = hitRate >= 0.33 ? 3.0 : GunUtils.limit(0.1, Math.min(lowEnergyFirePower, Math.min(farDistanceFirePower, Math.min(neededAmountToKill, 2.0))), 3.0);
        if (!Double.isFinite(firePower)) {
            firePower = battleInfo.getEnemyLastFirePower();
        }
        return firePower;
    }
}

