/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.ws.path;

import dsekercioglu.mega.rMove.MoveUtils;
import dsekercioglu.mega.rMove.sim.Wave;
import dsekercioglu.mega.rMove.ws.path.Path;
import dsekercioglu.mega.rMove.ws.path.State;
import dsekercioglu.mega.rMove.ws.path.aacalc.AttackAngleCalculator;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class PathGenerator {
    private static final double[] VELOCITIES = new double[]{-8.0, 0.0, 8.0};
    private static final int MAX_STOP_TIME = 5;
    private final double BATTLE_FIELD_WIDTH;
    private final double BATTLE_FIELD_HEIGHT;
    final double WALL_HIT_MARGIN = 18.0;
    private AttackAngleCalculator attackAngleCalculator;

    public PathGenerator(double battleFieldWidth, double battleFieldHeight) {
        this.BATTLE_FIELD_WIDTH = battleFieldWidth;
        this.BATTLE_FIELD_HEIGHT = battleFieldHeight;
    }

    public void setPathGenerator(AttackAngleCalculator attackAngleCalculator) {
        this.attackAngleCalculator = attackAngleCalculator;
    }

    public Path[] getExtremePaths(State currentState, State enemyState, Wave wave, int deltaTime) {
        int numberOfSimulations = this.getMaximumTimeLeft(wave, currentState.getLocation()) + 5;
        Path[] extremePaths = new Path[]{this.generatePath(this.attackAngleCalculator, currentState, enemyState, wave, deltaTime, -8.0, numberOfSimulations, -8.0), this.generatePath(this.attackAngleCalculator, currentState, enemyState, wave, deltaTime, 8.0, numberOfSimulations, 8.0)};
        return extremePaths;
    }

    public List<Path> generateRunAwayPaths(State currentState, State enemyState, Wave wave, int deltaTime) {
        ArrayList<Path> paths = new ArrayList<Path>(2);
        paths.add(this.generatePath(this.attackAngleCalculator, currentState, enemyState, wave, deltaTime, -8.0, 91, -8.0));
        paths.add(this.generatePath(this.attackAngleCalculator, currentState, enemyState, wave, deltaTime, 8.0, 91, 8.0));
        return this.filter(paths);
    }

    public List<Path> generateSimpleDistancingPaths(State currentState, State enemyState, Wave wave, int skippedCalculations) {
        return this.filter(this.generatePaths(this.attackAngleCalculator, currentState, enemyState, wave, 1.0, 0.0, skippedCalculations));
    }

    public List<Path> generateReverseDistancingPaths(State currentState, State enemyState, Wave wave, int skippedCalculations) {
        return this.filter(this.generatePaths(this.attackAngleCalculator, currentState, enemyState, wave, 1.0, -1.0, skippedCalculations));
    }

    public List<Path> generateAcceleratingDistancingPaths(State currentState, State enemyState, Wave wave, int skippedCalculations) {
        return this.filter(this.generatePaths(this.attackAngleCalculator, currentState, enemyState, wave, 0.0, 1.0, skippedCalculations));
    }

    private List<Path> generatePaths(AttackAngleCalculator attackAngleCalculator, State currentState, State enemyState, Wave wave, double startDirection, double finalTargetDirection, int skippedCalculations) {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path[] extremePaths = this.getExtremePaths(currentState, enemyState, wave, currentState.getDeltaTime());
        int skipFactor = skippedCalculations + 1;
        int numberOfBackwardSimulations = extremePaths[0].numberOfStates() / skipFactor;
        int numberOfForwardSimulations = extremePaths[1].numberOfStates() / skipFactor;
        for (int i = -numberOfBackwardSimulations; i <= numberOfForwardSimulations; ++i) {
            int iteration = Math.abs(i);
            int velocityIndex = Integer.compare(i, 0);
            int actualTime = iteration * skipFactor;
            double velocity = VELOCITIES[velocityIndex + 1];
            Path path = this.generatePath(attackAngleCalculator, currentState, enemyState, wave, currentState.getDeltaTime(), velocity * startDirection, actualTime, velocity * finalTargetDirection);
            paths.add(path);
        }
        paths.add(extremePaths[0]);
        paths.add(extremePaths[1]);
        return this.filter(paths);
    }

    private List<Path> filter(List<Path> paths) {
        int i;
        int stopPoint = paths.size() / 2;
        ArrayList<Path> toRemove = new ArrayList<Path>();
        ArrayList<Point2D.Double> endLocations = new ArrayList<Point2D.Double>();
        for (i = 0; i < paths.size(); ++i) {
            Path currentPath = paths.get(i);
            Point2D.Double endLocation = currentPath.getState(currentPath.numberOfStates() - 1).getLocation();
            if (MoveUtils.distanceToWall(endLocation.x, endLocation.y, this.BATTLE_FIELD_WIDTH, this.BATTLE_FIELD_HEIGHT) < 18.0) {
                toRemove.add(paths.get(i));
                if (i > stopPoint) continue;
                --stopPoint;
                continue;
            }
            endLocations.add(endLocation);
        }
        paths.removeAll(toRemove);
        if (paths.size() > 7 && paths.size() > stopPoint + 1 && stopPoint > 0) {
            Point2D.Double endLocation;
            toRemove.clear();
            for (i = stopPoint + 1; i < paths.size() - 1; ++i) {
                endLocation = (Point2D.Double)endLocations.get(i);
                if (!(((Point2D.Double)endLocations.get(i - 1)).distance(endLocation) < 7.0)) continue;
                toRemove.add(paths.get(i));
                ++i;
            }
            for (i = stopPoint - 1; i > 0; --i) {
                endLocation = (Point2D.Double)endLocations.get(i);
                if (!(((Point2D.Double)endLocations.get(i + 1)).distance(endLocation) < 7.0)) continue;
                toRemove.add(paths.get(i));
                --i;
            }
            paths.removeAll(toRemove);
        }
        return paths;
    }

    private Path generatePath(AttackAngleCalculator attackAngleCalculator, State startState, State enemyState, Wave wave, int deltaTime, double targetVelocity, int directionChangeTime, double finalTargetVelocity) {
        Path path = new Path(startState);
        boolean changingMovementPlan = false;
        double absoluteTargetVelocity = Math.abs(targetVelocity);
        path.setMaxVelocity(absoluteTargetVelocity);
        boolean intersected = false;
        State predictedEnemyState = new State((Point2D.Double)enemyState.getLocation().clone(), enemyState.getVelocity(), enemyState.getHeading(), enemyState.getDeltaTime());
        predictedEnemyState.setMaxVelocity(Math.abs(predictedEnemyState.getVelocity()));
        for (int moveTime = 0; moveTime <= 91; ++moveTime) {
            List<Point2D.Double> waveIntersection = this.calculateIntersection(path.getLastState().getLocation(), wave, moveTime + deltaTime);
            waveIntersection.addAll(this.calculateCornerIntersection(path.getLastState().getLocation(), wave, moveTime + deltaTime));
            if (!waveIntersection.isEmpty()) {
                path.getLastState().setIntersecting(true);
                path.getLastState().setIntersection(waveIntersection);
                intersected = true;
            } else if (intersected) {
                return path;
            }
            double moveAngle = attackAngleCalculator.getAttackAngle(wave, path.getLastState().getLocation(), predictedEnemyState.getLocation(), predictedEnemyState.getHeading(), targetVelocity);
            path.moveTowards(moveAngle);
            if (!changingMovementPlan && moveTime >= directionChangeTime) {
                targetVelocity = finalTargetVelocity;
                path.setMaxVelocity(Math.abs(targetVelocity));
                changingMovementPlan = true;
            }
            if (changingMovementPlan && finalTargetVelocity == 0.0 && path.getLastState().getVelocity() == 0.0 && !intersected) {
                path.getLastState().setIntersecting(true);
                path.getLastState().setIntersection(this.getDefaultIntersection(path.getLastState().getLocation()));
                return path;
            }
            if (!(MoveUtils.distanceToWall(path.getLastState().getLocation().x, path.getLastState().getLocation().y, this.BATTLE_FIELD_WIDTH, this.BATTLE_FIELD_HEIGHT) < 18.0) && !(path.getLastState().getLocation().distance(enemyState.getLocation()) < 18.0) || intersected) continue;
            path.getLastState().setIntersecting(true);
            path.getLastState().setIntersection(this.getDefaultIntersection(path.getLastState().getLocation()));
            return path;
        }
        if (path.numberOfStates() <= 1) {
            System.out.println("ERROR IN PATH GENERATION");
        }
        return path;
    }

    private List<Point2D.Double> calculateIntersection(Point2D.Double location, Wave wave, int deltaTime) {
        double waveRadius = wave.getDistanceTraveled() + (double)deltaTime * wave.getWaveVelocity();
        double previousWaveRadius = wave.getDistanceTraveled() + (double)(deltaTime - 1) * wave.getWaveVelocity();
        Point2D.Double waveSource = wave.getSource();
        Ellipse2D.Double waveCircle = new Ellipse2D.Double(waveSource.x - waveRadius, waveSource.y - waveRadius, waveRadius * 2.0, waveRadius * 2.0);
        Ellipse2D.Double previousWaveCircle = new Ellipse2D.Double(waveSource.x - previousWaveRadius, waveSource.y - previousWaveRadius, previousWaveRadius * 2.0, previousWaveRadius * 2.0);
        double cornerX = location.x - 18.0;
        double cornerY = location.y - 18.0;
        Rectangle2D.Double botBoundingBox = new Rectangle2D.Double(cornerX, cornerY, 36.0, 36.0);
        List<Point2D.Double> intersectionPoints = MoveUtils.rectangleCircleIntersection(waveCircle, botBoundingBox);
        intersectionPoints.addAll(MoveUtils.rectangleCircleIntersection(previousWaveCircle, botBoundingBox));
        return intersectionPoints;
    }

    private List<Point2D.Double> calculateCornerIntersection(Point2D.Double location, Wave wave, int deltaTime) {
        ArrayList<Point2D.Double> intersectionPoints = new ArrayList<Point2D.Double>();
        for (int x = -18; x <= 18; x += 36) {
            for (int y = -18; y <= 18; y += 36) {
                Point2D.Double cornerPosition = new Point2D.Double(location.x + (double)x, location.y + (double)y);
                if (!MoveUtils.waveIntersectsPoint(cornerPosition, wave.getSource(), wave.getWaveVelocity(), wave.getDistanceTraveled() + (double)deltaTime * wave.getWaveVelocity())) continue;
                intersectionPoints.add(cornerPosition);
            }
        }
        return intersectionPoints;
    }

    private List<Point2D.Double> getDefaultIntersection(Point2D.Double location) {
        ArrayList<Point2D.Double> intersectionPoints = new ArrayList<Point2D.Double>();
        for (int x = -18; x <= 18; x += 36) {
            for (int y = -18; y <= 18; y += 36) {
                Point2D.Double cornerPosition = new Point2D.Double(location.x + (double)x, location.y + (double)y);
                intersectionPoints.add(cornerPosition);
            }
        }
        return intersectionPoints;
    }

    public int getTimeLeft(Wave wave, Point2D.Double location) {
        return (int)Math.ceil((wave.getSource().distance(location) - wave.getDistanceTraveled()) / wave.getWaveVelocity());
    }

    public int getMaximumTimeLeft(Wave wave, Point2D.Double location) {
        return (int)Math.min(Math.ceil((wave.getSource().distance(location) - wave.getDistanceTraveled()) / (wave.getWaveVelocity() - 8.0)), 91.0);
    }
}

