/*
 * Decompiled with CFR 0.152.
 */
package jaybot.bots;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jaybot.guns.BulletDistanceComparator;
import jaybot.guns.FiringSolution;
import jaybot.guns.Gun;
import jaybot.guns.VirtualBullet;
import jaybot.intel.Enemy;
import jaybot.intel.EnemyIntel;
import jaybot.strategies.Strategy;
import jaybot.utils.LocationUtils;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public abstract class BaseBot
extends Robot {
    private boolean _$2716 = true;
    private boolean _$2717 = false;
    private boolean _$2718 = false;
    private boolean _$2719 = false;
    public static final double SYSTEM_MAX_TURNRATE = 10.0;
    public static final double SYSTEM_MAX_GUNTURNRATE = 20.0;
    public static final double SYSTEM_MAX_VELOCITY = 8.0;
    public static final double SYSTEM_MIN_BULLET_POWER = 0.1;
    public static final double SYSTEM_MAX_BULLET_POWER = 3.0;
    public static final double SYSTEM_MAX_SCAN_RANGE = 1200.0;
    public static final double SYSTEM_DAMAGE_FROM_COLLISION = 0.6;
    private Strategy _$2332;
    private int _$2259;
    protected EnemyIntel opponentTracker;
    private static int _$2725 = 0;
    private static long _$2726 = 0L;
    private static double _$2727 = 0.0;
    private static long _$2728 = 0L;
    private static long _$2729 = 0L;
    private static long _$2730 = 0L;
    private static long _$2731 = 0L;
    private Rectangle2D _$1741 = null;
    private Point2D _$2732 = null;
    protected static List oldTrackers = new ArrayList();
    protected static DecimalFormat dblfmt = new DecimalFormat();

    public final void run() {
        this._$1741 = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this._$2732 = new Point2D.Double(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
        LocationUtils.initialize(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this._$2259 = this.getOthers();
        this.announceBot();
        this._$2735(this.createEnemyIntel());
        this.changeStrategy(this.createStrategy());
        this.lastMinuteAdjustments();
        int iterationCount = 0;
        long iterationElapsed = 0L;
        try {
            while (true) {
                long startTime = this.getTime();
                this._$2332.doRunIteration();
                long elapsed = this.getTime() - startTime;
                ++iterationCount;
                iterationElapsed += elapsed;
            }
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            if (this._$2332 != null) {
                this._$2332.reactToGameEnding();
            }
            double iterationAverage = iterationElapsed;
            this.logImportant("\nAverage iteration time:           " + dblfmt.format(iterationAverage /= (double)iterationCount));
            iterationAverage = _$2726;
            this.logImportant("Average scan event time:          " + dblfmt.format(iterationAverage /= (double)_$2725));
            iterationAverage = _$2727;
            this.logImportant("Average gun scan degrees to fire: " + dblfmt.format(iterationAverage /= (double)_$2728));
            iterationAverage = (double)_$2730 / (double)_$2729 * 100.0;
            this.logImportant("Percentage of misfires:           " + dblfmt.format(iterationAverage) + "  (" + _$2730 + " of " + _$2729 + ")");
            iterationAverage = (double)_$2731 / (double)_$2729 * 100.0;
            this.logImportant("Percentage of skipped fires:      " + dblfmt.format(iterationAverage) + "  (" + _$2731 + " of " + _$2729 + ")");
            if (this.opponentTracker != null) {
                this.logTactical("");
                this.opponentTracker.announceStats();
            }
            this.logImportant("");
            this.logImportant("Accumulative shot accuracy:");
            this.logImportant("");
            oldTrackers.add(this.opponentTracker);
            HashMap<String, Double[]> allAccuracy = new HashMap<String, Double[]>();
            for (int round = 0; round < oldTrackers.size(); ++round) {
                EnemyIntel oneRound = (EnemyIntel)oldTrackers.get(round);
                Collection allEnemies = oneRound.getAllEnemies();
                Iterator i = allEnemies.iterator();
                while (i.hasNext()) {
                    Enemy badGuy = (Enemy)i.next();
                    Double[] roundAccuracyValues = (Double[])allAccuracy.get(badGuy.getName());
                    if (roundAccuracyValues == null) {
                        roundAccuracyValues = new Double[oldTrackers.size()];
                        allAccuracy.put(badGuy.getName(), roundAccuracyValues);
                    }
                    if (badGuy.getShotsHit() > 0 || badGuy.getShotsMissed() > 0) {
                        roundAccuracyValues[round] = new Double(badGuy.getShotAccuracy());
                        continue;
                    }
                    roundAccuracyValues[round] = new Double(-1.0);
                }
            }
            String output = "";
            Iterator i = allAccuracy.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry oneEntry = i.next();
                String badGuyName = (String)oneEntry.getKey();
                Double[] allRounds = (Double[])oneEntry.getValue();
                double total = 0.0;
                int nonNegativeCount = 0;
                for (int x = 0; x < allRounds.length; ++x) {
                    if (allRounds[x] == null || !(allRounds[x] >= 0.0)) continue;
                    total += allRounds[x].doubleValue();
                    ++nonNegativeCount;
                }
                double average = total / (double)nonNegativeCount;
                output = output + "    " + dblfmt.format(average) + "% against " + badGuyName + "\n";
                Enemy badGuy = this.opponentTracker.findEnemy(badGuyName);
                Iterator x = badGuy.getAllGuns().iterator();
                while (x.hasNext()) {
                    Gun oneGun = (Gun)x.next();
                    String stats = oneGun.getStatsString() + "\n";
                    output = output + "        " + stats;
                }
            }
            this.logImportant(output);
            this.logImportant("");
            String placeString = "1st";
            if (this.opponentTracker.getMyDeathOrder() > 0) {
                int place = this.opponentTracker.getInitialCompetitorCount() + 1 - this.opponentTracker.getMyDeathOrder() + 1;
                placeString = "" + place;
            }
            this.logImportant(placeString + " place, my death order: " + this.opponentTracker.getMyDeathOrder() + " out of " + (this.opponentTracker.getInitialCompetitorCount() + 1));
            this.logImportant("========================================================================");
            this.logImportant("");
            throw throwable;
        }
    }

    public VirtualBullet inDangerOfBulletHit(Enemy fromWhom, Point2D atPoint, double time, VirtualBullet exclude) {
        Enemy myEnemy = fromWhom;
        VirtualBullet closest = null;
        double closestDist = 0.0;
        boolean danger = false;
        Iterator i = myEnemy.getVirtualBullets().iterator();
        while (i.hasNext()) {
            VirtualBullet b = (VirtualBullet)i.next();
            if (b.isDead(time)) {
                i.remove();
                continue;
            }
            if (b == exclude) continue;
            double dist = b.distanceToPoint(atPoint, time);
            if (!b.isInLineOfFire(atPoint, time) || dist == Double.NEGATIVE_INFINITY || closest != null && !(dist < closestDist)) continue;
            closestDist = dist;
            closest = b;
        }
        return closest;
    }

    public VirtualBullet inDangerOfBulletHit(Point2D atPoint, double time, VirtualBullet exclude) {
        ArrayList<VirtualBullet> closest = new ArrayList<VirtualBullet>();
        Iterator i = this.opponentTracker.getAliveEnemies().iterator();
        while (i.hasNext()) {
            Enemy e = (Enemy)i.next();
            VirtualBullet thisClosest = this.inDangerOfBulletHit(e, atPoint, time, exclude);
            if (thisClosest == null) continue;
            closest.add(thisClosest);
        }
        if (closest.size() == 0) {
            return null;
        }
        if (closest.size() > 1) {
            Collections.sort(closest, new BulletDistanceComparator(false, atPoint, time));
        }
        return (VirtualBullet)closest.get(0);
    }

    public int getSign(double ofNumber) {
        return ofNumber < 0.0 ? -1 : 1;
    }

    public Rectangle2D getFieldRect() {
        return this._$1741;
    }

    public Point2D getFieldCenter() {
        return this._$2732;
    }

    public Color getTankColor() {
        return Color.red;
    }

    public Color getGunColor() {
        return Color.black;
    }

    public Color getRadarColor() {
        return Color.white;
    }

    public int getRoundsfought() {
        return this.getRoundNum() - 1;
    }

    public int getTotalRoundsToFight() {
        return this.getNumRounds();
    }

    protected abstract Strategy createStrategy();

    protected abstract EnemyIntel createEnemyIntel();

    protected abstract void announceBot();

    protected abstract void lastMinuteAdjustments();

    private void _$2735(EnemyIntel newTracker) {
        if (this.opponentTracker != null) {
            throw new RuntimeException("Cannot safely change the tracker, strategy and personalities will not update correctly if you do so");
        }
        EnemyIntel oldTracker = this.opponentTracker;
        this.opponentTracker = newTracker;
        if (this.opponentTracker == null) {
            throw new RuntimeException("Cannot proceed without enemy tracker");
        }
        this.opponentTracker.setBot(this);
        this.opponentTracker.setInitialEnemyCount(this._$2259);
        this.opponentTracker.announceTracker();
        if (oldTracker != null) {
            this.opponentTracker.copyFromLastTracker(oldTracker);
        }
    }

    public void changeStrategy(Strategy newDecisionMaker) {
        this._$2332 = newDecisionMaker;
        if (this._$2332 == null) {
            throw new RuntimeException("Cannot proceed without decision maker!");
        }
        this._$2332.setBot(this, this.opponentTracker);
        this._$2332.announceStrategy();
        this._$2332.doStartupAction();
    }

    public Strategy getStrategy() {
        return this._$2332;
    }

    public EnemyIntel getOpponentTracker() {
        return this.opponentTracker;
    }

    public int getHistoricalStatRoundCount() {
        return oldTrackers.size();
    }

    public List getHistoricalStatsForEnemy(String name) {
        ArrayList<Enemy> results = new ArrayList<Enemy>();
        Iterator i = oldTrackers.iterator();
        while (i.hasNext()) {
            EnemyIntel oldTrack = (EnemyIntel)i.next();
            Enemy badGuy = oldTrack.findEnemy(name);
            if (badGuy == null) continue;
            results.add(badGuy);
        }
        return results;
    }

    public final boolean fireBullet(FiringSolution solution, boolean turnGunEvenIfCantFire) {
        return this.fireBullet(solution, true, turnGunEvenIfCantFire);
    }

    public final double getGunTraversalNeededInDegreesToBearing(double toBearingInDegrees) {
        double startBearing = BaseBot.normalizeRelativeAngleDegrees(this.getGunBearingInDegrees());
        double gunTraversal = Math.abs(BaseBot.diffBetweenRelativeAnglesDegrees(startBearing, toBearingInDegrees));
        return gunTraversal;
    }

    public final double getGunTraversalTimeToBearing(double toBearingInDegrees) {
        double startBearing = BaseBot.normalizeRelativeAngleDegrees(this.getGunBearingInDegrees());
        double gunTraversal = Math.abs(BaseBot.diffBetweenRelativeAnglesDegrees(startBearing, toBearingInDegrees));
        double traversalTime = gunTraversal / 20.0;
        return traversalTime;
    }

    public final boolean fireBullet(FiringSolution solution, boolean turnGunToMatchSolutionBearing, boolean turnGunEvenIfCantFire) {
        boolean doFire;
        ++_$2729;
        double heat = this.getGunHeat();
        double gunTraversal = this.getGunTraversalNeededInDegreesToBearing(solution.getBearing());
        double traversalTime = gunTraversal / 20.0;
        heat = Math.max(0.0, heat - this.getGunCoolingRate() * traversalTime);
        this.logDetail("--- FIRE: ---");
        this.logDetail("    start heat =        " + dblfmt.format(this.getGunHeat()));
        this.logDetail("    gun start bearing = " + dblfmt.format(this.getGunBearingInDegrees()));
        this.logDetail("    gun end bearing =   " + dblfmt.format(solution.getBearing()));
        this.logDetail("    traversal time =    " + dblfmt.format(traversalTime));
        this.logDetail("    end heat =          " + dblfmt.format(heat));
        double threshold = 0.04;
        boolean fired = false;
        boolean bl = doFire = heat <= threshold;
        if (!turnGunToMatchSolutionBearing) {
            boolean bl2 = doFire = this.getGunHeat() <= 0.01;
        }
        if (doFire || turnGunEvenIfCantFire) {
            ++_$2728;
            if (turnGunToMatchSolutionBearing && this.getGunBearingInDegrees() != solution.getBearing()) {
                _$2727 += gunTraversal;
                this.turnGunToBearingDegrees(solution.getBearing());
            }
            if (doFire) {
                double actualHeat = this.getGunHeat();
                Bullet firedBullet = this.fireBullet(solution.getShotPower());
                if (firedBullet == null) {
                    ++_$2730;
                } else {
                    fired = true;
                    this.opponentTracker.recordFiringOfBullet(solution, firedBullet);
                }
            } else {
                ++_$2731;
            }
        } else {
            ++_$2731;
        }
        return fired;
    }

    public final boolean fireBulletWithoutGun(String targetName, double shotPower, double estimatedDistance) {
        FiringSolution solution = new FiringSolution(targetName, this.getGunBearingInDegrees(), estimatedDistance, shotPower);
        return this.fireBullet(solution, false);
    }

    public final void onBulletHit(BulletHitEvent event) {
        this.opponentTracker.recordBulletHitTarget(event, this._$2332);
    }

    public final void onBulletHitBullet(BulletHitBulletEvent event) {
        this.opponentTracker.recordBulletHitAnotherBullet(event, this._$2332);
    }

    public final void onBulletMissed(BulletMissedEvent event) {
        this.opponentTracker.recordBulletMissedTarget(event, this._$2332);
    }

    public final void onDeath(DeathEvent event) {
        this.opponentTracker.informOfMyDeath(event, this._$2332);
    }

    public final void onHitByBullet(HitByBulletEvent event) {
        this.opponentTracker.recordYouHitByEnemyBullet(event, this._$2332);
    }

    public final void onHitRobot(HitRobotEvent event) {
        this.opponentTracker.recordYouCollidedWithEnemyRobot(event, this._$2332);
    }

    public final void onHitWall(HitWallEvent event) {
        this._$2332.reactToYouHitWall(event);
    }

    public final void onRobotDeath(RobotDeathEvent event) {
        this.opponentTracker.recordAnotherRobotDeath(event, this._$2332);
    }

    public final void onScannedRobot(ScannedRobotEvent event) {
        ++_$2725;
        long startTime = this.getTime();
        this.opponentTracker.recordSeeingEnemyRobot(event, this._$2332);
        long elapsed = this.getTime() - startTime;
        _$2726 += elapsed;
    }

    public final void onWin(WinEvent event) {
        this._$2332.reactToYouWinning(event);
    }

    public static double getBulletDamageFromPower(double shotPower) {
        double damage = 4.0 * shotPower + (shotPower > 1.0 ? 2.0 * (shotPower - 1.0) : 0.0);
        return damage;
    }

    public static double getGunHeatGeneratedByPower(double shotPower) {
        return 1.0 + shotPower / 5.0;
    }

    public static double getBulletVelocityFromPower(double shotPower) {
        return 20.0 - 3.0 * shotPower;
    }

    public double getBestBulletPowerForDistance(double distance) {
        return this.getBestBulletPowerForDistance(distance, 50.0);
    }

    public double getBestBulletPowerForDistance(double distance, double shotAccuracy) {
        double shotPower = 1.72;
        if (shotAccuracy > 50.0 && this.getEnergy() > 10.0) {
            shotPower = 3.0;
        } else if (shotAccuracy < 18.0) {
            shotPower = 0.5;
        }
        if (this.getEnergy() > 20.0 && distance < 150.0) {
            shotPower = 3.0;
        }
        if (shotPower > this.getEnergy()) {
            shotPower = this.getEnergy() - 0.1;
        }
        return shotPower;
    }

    public static Point2D pointFromCoords(double x, double y) {
        return new Point2D.Double(x, y);
    }

    public Point2D getTankPosition() {
        return BaseBot.pointFromCoords(this.getX(), this.getY());
    }

    public static double getDistance(Point2D ptFrom, Point2D ptTo) {
        return ptFrom.distance(ptTo);
    }

    public void moveTank(double amount) {
        this.ahead(amount);
    }

    public double moveTank(Point2D point) {
        double distance = this.getTankPosition().distance(point);
        double heading = BaseBot.getAngleBetweenPointsInDegrees(this.getTankPosition(), point);
        double bearing = this.headingToBearingDegrees(heading);
        return this.moveTank(bearing, distance);
    }

    public double moveTank(double bearingInDegrees, double distance) {
        if (Math.abs(bearingInDegrees = BaseBot.normalizeRelativeAngleDegrees(bearingInDegrees)) > 90.0) {
            distance *= -1.0;
            bearingInDegrees = bearingInDegrees > 0.0 ? (bearingInDegrees -= 180.0) : (bearingInDegrees += 180.0);
        }
        if (bearingInDegrees != 0.0) {
            this.turnRight(bearingInDegrees);
        }
        this.ahead(distance);
        return distance;
    }

    public double getGunBearingInDegrees() {
        return this.headingToBearingDegrees(this.getGunHeading());
    }

    public double getRadarBearingInDegrees() {
        return this.headingToBearingDegrees(this.getRadarHeading());
    }

    public void turnTankByDegrees(double amountInDegrees) {
        if ((amountInDegrees = BaseBot.normalizeRelativeAngleDegrees(amountInDegrees)) > 0.0) {
            this.turnRight(Math.abs(amountInDegrees));
        }
        if (amountInDegrees < 0.0) {
            this.turnLeft(Math.abs(amountInDegrees));
        }
    }

    public void turnTankToBearingDegrees(double bearingInDegrees) {
        double tankBearing = this.headingToBearingDegrees(this.getHeading());
        double delta = tankBearing - bearingInDegrees;
        if (delta > 180.0) {
            this.turnRight(360.0 - delta);
        } else if (delta < -180.0) {
            this.turnLeft(360.0 - Math.abs(delta));
        } else {
            this.turnLeft(delta);
        }
    }

    public void turnGunByDegrees(double amountInDegrees) {
        if ((amountInDegrees = BaseBot.normalizeRelativeAngleDegrees(amountInDegrees)) > 0.0) {
            this.turnGunRight(Math.abs(amountInDegrees));
        }
        if (amountInDegrees < 0.0) {
            this.turnGunLeft(Math.abs(amountInDegrees));
        }
    }

    public void turnGunToBearingDegrees(double bearingDegrees) {
        double gunBearing = this.headingToBearingDegrees(this.getGunHeading());
        double delta = gunBearing - bearingDegrees;
        if (delta > 180.0) {
            this.turnGunRight(360.0 - delta);
        } else if (delta < -180.0) {
            this.turnGunLeft(360.0 - Math.abs(delta));
        } else {
            this.turnGunLeft(delta);
        }
    }

    public void turnGunToBearingDegreesWithRadarScanning(double bearingDegrees, boolean lockRadarToTankTurn, boolean lockRadarToGunTurn) {
        this.setAdjustRadarForGunTurn(false);
        this.turnRadarToBearingDegrees(this.headingToBearingDegrees(this.getGunHeading()));
        this.setAdjustRadarForGunTurn(true);
        this.turnGunToBearingDegrees(bearingDegrees);
        this.setAdjustRadarForGunTurn(!lockRadarToGunTurn);
        this.setAdjustRadarForRobotTurn(!lockRadarToTankTurn);
    }

    public void turnGunToFront(boolean lockGunToTankTurn) {
        this.setAdjustGunForRobotTurn(!lockGunToTankTurn);
        double b = this.getHeading() - this.getGunHeading();
        b = BaseBot.normalizeRelativeAngleDegrees(b);
        this.turnGunByDegrees(b);
    }

    public void turnRadarByDegrees(double amountInDegrees) {
        if ((amountInDegrees = BaseBot.normalizeRelativeAngleDegrees(amountInDegrees)) > 0.0) {
            this.turnRadarRight(Math.abs(amountInDegrees));
        }
        if (amountInDegrees < 0.0) {
            this.turnRadarLeft(Math.abs(amountInDegrees));
        }
    }

    public double turnRadarToBearingDegrees(double bearing) {
        double radarBearing = this.headingToBearingDegrees(this.getRadarHeading());
        double delta = radarBearing - bearing;
        double amount = 0.0;
        if (delta > 180.0) {
            amount = 360.0 - delta;
            if (amount != 0.0) {
                this.turnRadarRight(amount);
            }
        } else if (delta < -180.0) {
            amount = 360.0 - Math.abs(delta);
            if (amount != 0.0) {
                this.turnRadarLeft(amount);
            }
        } else {
            amount = delta;
            if (amount != 0.0) {
                this.turnRadarLeft(delta);
            }
        }
        return Math.abs(delta);
    }

    public void turnRadarToFront(boolean lockRadarToTankTurn, boolean lockRadarToGunTurn) {
        this.setAdjustRadarForGunTurn(!lockRadarToGunTurn);
        this.setAdjustRadarForRobotTurn(!lockRadarToTankTurn);
        double b = this.getHeading() - this.getRadarHeading();
        b = BaseBot.normalizeRelativeAngleDegrees(b);
        this.turnRadarByDegrees(b);
    }

    public static double normalizeRelativeAngleDegrees(double angleDegrees) {
        if (angleDegrees > 180.0) {
            angleDegrees = angleDegrees % 360.0 - 360.0;
        }
        if (angleDegrees < -180.0) {
            angleDegrees = angleDegrees % 360.0 + 360.0;
        }
        return angleDegrees;
    }

    public static Point2D projectPointInTime(Point2D startPos, double headingInDegrees, double velocity, double time) {
        return BaseBot.projectPointInSpace(startPos, headingInDegrees, velocity * time);
    }

    public static Point2D projectPointInSpace(Point2D startPos, double headingInDegrees, double distance) {
        headingInDegrees = BaseBot.normalizeAbsoluteAngleDegrees(headingInDegrees);
        return BaseBot.pointFromCoords(startPos.getX() + Math.sin(Math.toRadians(headingInDegrees)) * distance, startPos.getY() + Math.cos(Math.toRadians(headingInDegrees)) * distance);
    }

    public static double diffBetweenRelativeAnglesDegrees(double angle1Degrees, double angle2Degrees) {
        return BaseBot.normalizeRelativeAngleDegrees(BaseBot.normalizeRelativeAngleDegrees(angle1Degrees) - BaseBot.normalizeRelativeAngleDegrees(angle2Degrees));
    }

    public static double normalizeAbsoluteAngleDegrees(double angleDegrees) {
        return angleDegrees += (double)((angleDegrees %= 360.0) < 0.0 ? 360 : 0);
    }

    public double bearingToHeadingDegrees(double bearingDegrees) {
        double heading = this.getHeading() + bearingDegrees;
        return BaseBot.normalizeAbsoluteAngleDegrees(heading);
    }

    public double headingToBearingDegrees(double headingDegrees) {
        headingDegrees = BaseBot.normalizeAbsoluteAngleDegrees(headingDegrees);
        double bearing = headingDegrees - this.getHeading();
        bearing = BaseBot.normalizeRelativeAngleDegrees(bearing);
        return bearing;
    }

    public static double getAngleBetweenPointsInDegrees(Point2D ptFrom, Point2D ptTo) {
        return BaseBot.normalizeAbsoluteAngleDegrees(Math.toDegrees(Math.atan2(ptTo.getX() - ptFrom.getX(), ptTo.getY() - ptFrom.getY())));
    }

    public boolean nearWall(Point2D pt, double distance) {
        return this.nearWall(pt.getX(), pt.getY(), distance);
    }

    public boolean nearWall(double xPos, double yPos, double distance) {
        return xPos <= distance || xPos >= this.getBattleFieldWidth() - distance || yPos <= distance || yPos >= this.getBattleFieldHeight() - distance;
    }

    public boolean inCorner(Point2D pt, double distance) {
        return this.inCorner(pt.getX(), pt.getY(), distance);
    }

    public boolean inCorner(double xPos, double yPos, double distance) {
        double c1 = Math.sqrt(xPos * xPos + yPos * yPos);
        double c2 = Math.sqrt((xPos - this.getBattleFieldWidth()) * (xPos - this.getBattleFieldWidth()) + yPos * yPos);
        double c3 = Math.sqrt((xPos - this.getBattleFieldWidth()) * (xPos - this.getBattleFieldWidth()) + (yPos - this.getBattleFieldHeight()) * (yPos - this.getBattleFieldHeight()));
        double c4 = Math.sqrt(xPos * xPos + (yPos - this.getBattleFieldHeight()) * (yPos - this.getBattleFieldHeight()));
        return c1 <= distance || c2 <= distance || c3 <= distance || c4 <= distance;
    }

    public void logImportant(String s) {
        if (this._$2716) {
            System.out.println(s);
        }
    }

    public void logTactical(String s) {
        if (this._$2717) {
            System.out.println(s);
        }
    }

    public void logStats(String s) {
        if (this._$2718) {
            System.out.println(s);
        }
    }

    public void logDetail(String s) {
        if (this._$2719) {
            System.out.println(s);
        }
    }

    public double getGunHeat() {
        return super.getGunHeat();
    }

    public int getScanEventsCount() {
        return _$2725;
    }

    static {
        dblfmt.setMaximumFractionDigits(2);
        dblfmt.setMinimumFractionDigits(2);
        dblfmt.setMinimumIntegerDigits(1);
    }
}

