/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.bullet;

import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.enemy.EnemyShootingAtUsStrategy;
import dmh.robocode.utils.Geometry;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.Rules;

public class DangerousBullet {
    private Location firedFrom;
    private double speed;
    private double damage;
    private double bulletPower;
    private double estimatedHeading;
    private long timeFired;
    private EnemyRobot enemy;
    private EnemyShootingAtUsStrategy shootingStrategy;
    private Location cachedLocation = null;
    private long timeOfCachedLocation;
    private double likelyToBeAimingForUs;
    private double bearingAdjustment = 0.0;

    public DangerousBullet(EnemyShootingAtUsStrategy shootingStrategy, Location firedFrom, double bulletPower, double estimatedHeading, long timeFired, EnemyRobot enemy, double likelyToBeAimingForUs) {
        this.shootingStrategy = shootingStrategy;
        this.firedFrom = firedFrom;
        this.speed = Rules.getBulletSpeed((double)bulletPower);
        this.damage = Rules.getBulletDamage((double)bulletPower);
        this.bulletPower = bulletPower;
        this.estimatedHeading = estimatedHeading;
        this.timeFired = timeFired;
        this.enemy = enemy;
        this.likelyToBeAimingForUs = likelyToBeAimingForUs;
    }

    public Location getLocationAtTime(long atTime) {
        if (this.cachedLocation == null || atTime != this.timeOfCachedLocation) {
            double distanceTravelled = this.speed * (double)(atTime - this.timeFired);
            this.cachedLocation = Geometry.getLocationAtBearing(this.firedFrom, this.getEstimatedHeading(), distanceTravelled);
            this.timeOfCachedLocation = atTime;
        }
        return this.cachedLocation;
    }

    public double getDamage() {
        return this.damage;
    }

    public EnemyShootingAtUsStrategy getShootingStrategy() {
        return this.shootingStrategy;
    }

    public double getLikelyToBeAimingForUs() {
        return this.likelyToBeAimingForUs;
    }

    public double getEstimatedHeading() {
        return this.estimatedHeading + this.bearingAdjustment;
    }

    public boolean isPossibleLocation(Location possibleLocation, long atTime, double bulletPower, double marginOfError, EnemyRobot enemy) {
        if (enemy == this.enemy && Math.abs(bulletPower - this.bulletPower) < 0.001) {
            double distanceTravelled = (double)(atTime - this.timeFired) * this.speed;
            double locationDistance = Geometry.getDistanceBetweenLocations(this.firedFrom, possibleLocation);
            return Math.abs(distanceTravelled - locationDistance) <= marginOfError;
        }
        return false;
    }

    public Location getFiredFromLocation() {
        return this.firedFrom;
    }

    public void paint(Graphics2D g, long currentTime) {
        Location predictedLocation = this.getLocationAtTime(currentTime);
        int x = (int)predictedLocation.getX();
        int y = (int)predictedLocation.getY();
        int radius = (int)Math.round(this.likelyToBeAimingForUs * this.shootingStrategy.getWeightedChanceOfHit() / 1500.0);
        g.setColor(Color.red);
        g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
    }

    public void increaseBearingAdjustment(double changeOfAdjustment) {
        this.bearingAdjustment += changeOfAdjustment;
    }
}

