/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.data;

import dmh.robocode.data.DynamicMovementSequence;
import dmh.robocode.data.Movement;
import java.util.Arrays;
import java.util.List;

public class CompleteMovementSequence {
    Movement[] movements;

    public CompleteMovementSequence(Movement[] sequenceAsArray) {
        this.movements = (Movement[])sequenceAsArray.clone();
    }

    public CompleteMovementSequence(List<Movement> sequenceAsList) {
        this.movements = sequenceAsList == null ? new Movement[0] : sequenceAsList.toArray(new Movement[0]);
    }

    public CompleteMovementSequence(DynamicMovementSequence sequence, long startTime, long endTime) {
        this.movements = new Movement[(int)(endTime - startTime + 1L)];
        for (long time = startTime; time <= endTime; ++time) {
            this.movements[(int)(time - startTime)] = sequence.getAtTime(time);
        }
    }

    public int getLength() {
        return this.movements.length;
    }

    public Movement getMovement(int index) {
        if (index >= 0 && index < this.movements.length) {
            return this.movements[index];
        }
        return null;
    }

    public String getDebugString() {
        String result = "{ ";
        boolean isFirstMovement = true;
        for (Movement movement : this.movements) {
            if (isFirstMovement) {
                isFirstMovement = false;
            } else {
                result = result + "->";
            }
            result = result + movement.getDebugString();
        }
        return result + " }";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.movements);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompleteMovementSequence other = (CompleteMovementSequence)obj;
        return Arrays.equals(this.movements, other.movements);
    }
}

