/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.aiming;

import dmh.robocode.data.BattleConstants;
import dmh.robocode.data.Location;
import dmh.robocode.data.RadarObservation;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.CalibratedAimingStrategyUsingEnemySimulator;
import dmh.robocode.gunner.simulator.SteadyChangeEnemySimulatorImproved;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Color;

public class AimBetweenFurthestPossibleForwardsAndBackwards
extends CalibratedAimingStrategyUsingEnemySimulator {
    private Location targetLocation;
    private double targetEstimatedSuccess;
    long timeOfLastCalculation;
    int roundOfLastCalculation;

    public AimBetweenFurthestPossibleForwardsAndBackwards(CommandBasedRobot myRobot, EnemyRobot enemy, boolean isLearningAllowed, Color color) {
        super(myRobot, enemy, isLearningAllowed, color);
        this.timeOfLastCalculation = myRobot.getTime() - 1L;
        this.roundOfLastCalculation = myRobot.getRoundNum() - 1;
        this.targetLocation = null;
    }

    @Override
    public double getEstimatedSuccessOfShotUsingRules(double bulletSpeed) {
        this.calculateExpectedTarget(bulletSpeed);
        return this.targetEstimatedSuccess;
    }

    @Override
    public Location getTargetForShot(double bulletSpeed) {
        this.calculateExpectedTarget(bulletSpeed);
        return this.targetLocation;
    }

    private void calculateExpectedTarget(double bulletSpeed) {
        double perfectDistance = Math.min(BattleConstants.getInstance().getRobotWidth(), BattleConstants.getInstance().getRobotHeight());
        if (this.timeOfLastCalculation != this.getMyRobot().getTime() || this.roundOfLastCalculation != this.getMyRobot().getRoundNum()) {
            RadarObservation latestObservation = this.getEnemy().getLatestRadarObservation();
            if (latestObservation != null && latestObservation.getTimeSeen() == this.getMyRobot().getTime()) {
                double difference;
                Location maxForwardsLocation = this.getSimulatorResult(latestObservation, 8.0, bulletSpeed);
                Location maxBackwardsLocation = this.getSimulatorResult(latestObservation, -8.0, bulletSpeed);
                if (maxForwardsLocation != null && maxBackwardsLocation != null && (difference = Geometry.getDistanceBetweenLocations(maxForwardsLocation, maxBackwardsLocation)) <= perfectDistance) {
                    this.timeOfLastCalculation = this.getMyRobot().getTime();
                    this.roundOfLastCalculation = this.getMyRobot().getRoundNum();
                    this.targetLocation = Location.getMidPoint(maxForwardsLocation, maxBackwardsLocation);
                    this.targetEstimatedSuccess = 100.0;
                    return;
                }
            }
            this.targetLocation = null;
            this.targetEstimatedSuccess = 0.0;
        }
    }

    private Location getSimulatorResult(RadarObservation enemyObservation, double velocity, double bulletSpeed) {
        double rateOfTurn = 0.0;
        double acceleration = velocity;
        SteadyChangeEnemySimulatorImproved simulator = new SteadyChangeEnemySimulatorImproved(enemyObservation.getLocation(), enemyObservation.getVelocity(), enemyObservation.getHeading(), acceleration, rateOfTurn);
        return this.getSimulatorIntercept(simulator, bulletSpeed);
    }
}

