/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.navigator.target;

import dmh.robocode.data.BattleConstants;
import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.navigator.target.EnemyTargetAlgorithm;
import dmh.robocode.simulate.SimulateableRobot;
import dmh.robocode.utils.Geometry;

public class EnemyTargetDefault
implements EnemyTargetAlgorithm {
    private EnemyRobot enemy;
    private double safeTargetDistance;
    private SimulateableRobot myRobot;

    public EnemyTargetDefault(EnemyRobot enemy, SimulateableRobot myRobot, double safeTargetDistance) {
        this.enemy = enemy;
        this.myRobot = myRobot;
        this.safeTargetDistance = safeTargetDistance;
    }

    @Override
    public Location getRevisedTargetLocation() {
        Location enemyLocation = this.enemy.getLatestRadarObservation().getLocation();
        double enemyBearing = Geometry.getBearingBetweenLocations(this.myRobot.getLocation(), enemyLocation);
        double enemyDistance = Geometry.getDistanceBetweenLocations(this.myRobot.getLocation(), enemyLocation);
        if (enemyDistance > this.safeTargetDistance) {
            double offset = (4.0 * this.safeTargetDistance - enemyDistance) / 3.0;
            Location leftOption = Geometry.getLocationAtBearing(enemyLocation, enemyBearing - 90.0, offset);
            Location rightOption = Geometry.getLocationAtBearing(enemyLocation, enemyBearing + 90.0, offset);
            return this.getFurthestFromEdges(leftOption, rightOption);
        }
        Location leftOption = Geometry.getLocationAtBearing(this.myRobot.getLocation(), enemyBearing - 90.0, this.safeTargetDistance * 1.1);
        Location rightOption = Geometry.getLocationAtBearing(this.myRobot.getLocation(), enemyBearing + 90.0, this.safeTargetDistance * 1.1);
        return this.getFurthestFromEdges(leftOption, rightOption);
    }

    private Location getFurthestFromEdges(Location firstOption, Location secondOption) {
        if (firstOption.getHowCloseToEdgeOfBattlefield(BattleConstants.getInstance().getBattlefieldHeight(), BattleConstants.getInstance().getBattlefieldWidth()) > secondOption.getHowCloseToEdgeOfBattlefield(BattleConstants.getInstance().getBattlefieldHeight(), BattleConstants.getInstance().getBattlefieldWidth())) {
            return firstOption;
        }
        return secondOption;
    }
}

