/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.gun.patternrecognition;

import florent.XSeries.Configuration;
import florent.XSeries.gun.patternrecognition.DeathPoint;
import florent.XSeries.gun.patternrecognition.Scan;
import florent.XSeries.gun.patternrecognition.ScanComparator;
import florent.XSeries.radar.Enemy;
import florent.XSeries.utils.Force;
import florent.XSeries.utils.RobocodeTools;
import florent.XSeries.utils.XPoint;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import robocode.AdvancedRobot;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanStore
implements Serializable {
    private static final long serialVersionUID = -7036821762627695461L;
    private static final boolean DEBUG = false;
    private static final int MAXSCANS = 30000;
    private static final int MAXLOCATIONS = 130;
    public static final int MAXSIMILARSCAN = 75;
    public static final int MAXSIMILARSCANDUEL = 10;
    public static final int MAXSIMILARSCANDUELGH = 200;
    private XPoint firstXPoint;
    private XPoint lastXPoint;
    private Scan first;
    private Scan last;
    private XPoint[] locations;
    private String name;
    private int lastRecord;
    private Scan lastScan;
    private double firstScan = -1.0;
    public int scansRecorded;
    public int locationIndex = 0;
    private int locationOffset = 0;
    private double[] cumul;

    public ScanStore(String name) {
        this.name = name;
        this.initRound();
    }

    public void record(Enemy enemy, AdvancedRobot me) {
        ++this.scansRecorded;
        if (Configuration.others == 1 && Configuration.me.getTime() > 1L) {
            int i;
            int time = (int)Configuration.me.getTime();
            if (this.cumul[0] == Double.POSITIVE_INFINITY) {
                i = 0;
                while (i < time) {
                    this.cumul[i] = 0.0;
                    ++i;
                }
            }
            if (this.cumul[time - 1] == Double.POSITIVE_INFINITY) {
                i = time - 1;
                while (this.cumul[i] == Double.POSITIVE_INFINITY) {
                    --i;
                }
                int j = i + 1;
                while (j < time) {
                    this.cumul[j] = this.cumul[i];
                    ++j;
                }
            }
            this.cumul[time] = this.cumul[time - 1] + enemy.velocity;
        }
        Scan scan = new Scan();
        scan.distance = enemy.distance;
        scan.normalizedDistance = Math.min(800.0, enemy.distance) / 800.0;
        scan.distanceWall = Configuration.wallDistance(enemy.location);
        scan.distanceCenter = enemy.distanceToCenter();
        scan.time = Enemy.me.getTime();
        scan.velocity = enemy.velocity;
        scan.normalizedVelocity = Math.abs(scan.velocity) / 8.0;
        scan.heading = enemy.heading;
        scan.correctedHeading = (scan.velocity >= 0.0 ? scan.heading : scan.heading + Utils.normalAbsoluteAngle((double)(scan.heading + Math.PI))) % (Math.PI * 2);
        scan.positionIndex = this.locationIndex;
        scan.angle = Math.abs(Utils.normalRelativeAngle((double)(enemy.heading + (RobocodeTools.sign(enemy.velocity) < 0 ? Math.PI : 0.0) - enemy.absoluteBearing))) / Math.PI;
        scan.timeSinceStop = Math.min(enemy.timeSinceVChange, 40.0) / 40.0;
        scan.lastTimer = Math.min(enemy.lastTimeSinceVChange, 40.0) / 40.0;
        scan.runDist = enemy.runDist;
        scan.gunHeat = Math.min(me.getGunHeat(), 1.6) / 1.6;
        scan.absoluteBearing = enemy.absoluteBearing;
        scan.accel = me.getOthers() == 1 ? (enemy.velocity - enemy.lastVelocity == 0.0 ? 0.5 : (double)(enemy.velocity - enemy.lastVelocity > 0.0 ? 1 : 0)) : 1.0 * (double)me.getOthers() / 10.0;
        scan.lateralVelocity = Math.abs(enemy.lateralVelocity) / 8.0;
        double maxWDist = 400.0;
        double distV = 0.0;
        double distH = 0.0;
        distV = scan.correctedHeading == 1.5707963267948966 || scan.correctedHeading == 4.71238898038469 ? Double.POSITIVE_INFINITY : (scan.correctedHeading < 1.5707963267948966 || scan.correctedHeading > 4.71238898038469 ? (Configuration.battleFieldHeigth - enemy.location.y) / Math.cos(scan.correctedHeading) : enemy.location.y / Math.cos(scan.correctedHeading - Math.PI));
        distH = scan.correctedHeading == Math.PI || scan.correctedHeading == 0.0 ? Double.POSITIVE_INFINITY : (scan.correctedHeading < Math.PI ? (Configuration.battleFieldWidth - enemy.location.x) / Math.cos(scan.correctedHeading - 1.5707963267948966) : enemy.location.x / Math.cos(scan.correctedHeading - Math.PI - 1.5707963267948966));
        scan.wallIndex = 1.0 - Math.min(Math.min(distV, distH), maxWDist) / maxWDist;
        double h1 = (scan.correctedHeading + Math.PI) % (Math.PI * 2);
        if (h1 < 0.0) {
            h1 += Math.PI * 2;
        }
        distV = h1 == 1.5707963267948966 || h1 == 4.71238898038469 ? Double.POSITIVE_INFINITY : (h1 < 1.5707963267948966 || h1 > 4.71238898038469 ? (Configuration.battleFieldHeigth - enemy.location.y) / Math.cos(h1) : enemy.location.y / Math.cos(h1 - Math.PI));
        distH = h1 == Math.PI || h1 == 0.0 ? Double.POSITIVE_INFINITY : (h1 < Math.PI ? (Configuration.battleFieldWidth - enemy.location.x) / Math.cos(h1 - 1.5707963267948966) : enemy.location.x / Math.cos(h1 - Math.PI - 1.5707963267948966));
        scan.wallIndexReverse = 1.0 - Math.min(Math.min(distV, distH), maxWDist) / maxWDist;
        if (this.firstScan == -1.0) {
            this.firstScan = enemy.lastScan;
            this.lastRecord = (int)enemy.lastScan;
            this.locations[0] = new XPoint(enemy.location.x, enemy.location.y);
        } else {
            int offset = (int)(enemy.lastScan - (double)this.lastRecord);
            if (offset < 1) {
                return;
            }
            this.lastRecord = (int)enemy.lastScan;
            this.shiftLocations(offset);
            this.locations[0] = new XPoint(enemy.location.x, enemy.location.y);
            this.extrapolateLocations(offset);
            double angle = Utils.normalRelativeAngle((double)(enemy.heading + (RobocodeTools.sign(enemy.velocity) < 0 ? Math.PI : 0.0)));
            Force force = null;
            if (this.locations[1] != null) {
                force = new Force(this.locations[1], this.locations[0]);
                force.multiplyMagnitude(1.0 / Math.max(force.getMagnitude(), 1.0E-5));
            }
            if (this.locations[15] != null) {
                scan.distance15 = this.locations[0].distance(this.locations[15]) * Math.sin(angle);
            }
            if (this.locations[30] != null) {
                scan.distance30 = this.locations[0].distance(this.locations[30]) * Math.sin(angle);
            }
            if (this.locations[60] != null) {
                scan.distance60 = this.locations[0].distance(this.locations[60]) * Math.sin(angle);
            }
            if (this.locations[120] != null) {
                scan.distance120 = this.locations[0].distance(this.locations[120]) * Math.sin(angle);
            }
            if (me.getOthers() == 1) {
                if (this.locations[2] != null) {
                    scan.cumul2 = Math.min(16.0, Math.max(this.locations[0].distance(this.locations[2]) * Math.sin(angle), -3.0)) / 19.0;
                }
                if (this.locations[4] != null) {
                    scan.cumul4 = Math.min(32.0, Math.max(this.locations[0].distance(this.locations[4]) * Math.sin(angle), -4.0)) / 42.0;
                }
                if (this.locations[8] != null) {
                    scan.cumul8 = Math.min(64.0, Math.max(this.locations[0].distance(this.locations[8]) * Math.sin(angle), -36.0)) / 100.0;
                }
                if (this.locations[16] != null) {
                    scan.cumul16 = Math.min(128.0, Math.max(this.locations[0].distance(this.locations[16]) * Math.sin(angle), -100.0)) / 228.0;
                }
                if (this.locations[32] != null) {
                    scan.cumul32 = Math.min(256.0, Math.max(this.locations[0].distance(this.locations[32]) * Math.sin(angle), -228.0)) / 484.0;
                }
            } else {
                if (this.locations[8] != null) {
                    scan.cumul2 = Math.min(64.0, Math.max(this.locations[0].distance(this.locations[8]) * Math.sin(angle), -36.0)) / 100.0;
                }
                if (this.locations[16] != null) {
                    scan.cumul4 = Math.min(128.0, Math.max(this.locations[0].distance(this.locations[16]) * Math.sin(angle), -100.0)) / 228.0;
                }
                if (this.locations[32] != null) {
                    scan.cumul8 = Math.min(256.0, Math.max(this.locations[0].distance(this.locations[32]) * Math.sin(angle), -228.0)) / 484.0;
                }
                if (this.locations[64] != null) {
                    scan.cumul16 = Math.min(512.0, Math.max(this.locations[0].distance(this.locations[64]) * Math.sin(angle), -484.0)) / 996.0;
                }
                if (this.locations[128] != null) {
                    scan.cumul32 = Math.min(1024.0, Math.max(this.locations[0].distance(this.locations[128]) * Math.sin(angle), -996.0)) / 2020.0;
                }
            }
        }
        if (this.first == null) {
            this.first = scan;
            this.last = scan;
            this.lastXPoint = this.firstXPoint = new XPoint(enemy.location.x, enemy.location.y);
            ++this.locationIndex;
        } else {
            this.last.next = scan;
            scan.prec = this.last;
            this.last = scan;
            this.lastXPoint = this.lastXPoint.next = new XPoint(enemy.location.x, enemy.location.y);
            ++this.locationIndex;
        }
        this.lastScan = scan;
        scan.point = this.lastXPoint;
    }

    public ArrayList<Scan> mostSimilarScans(Enemy enemy, boolean GH, double power) {
        int max = Configuration.others > 1 ? 75 : 10;
        ArrayList<Scan> bests = new ArrayList<Scan>(max);
        double bVel = RobocodeTools.bulletVelocity(power);
        if (this.last == null) {
            return bests;
        }
        if (max >= this.scansRecorded) {
            Scan current = this.last.prec;
            while (current != null && current.prec != null) {
                bests.add(current);
                current = current.prec;
            }
        } else {
            double worstVal = 0.0;
            Scan current = this.last.prec;
            int i = 0;
            while (current != null && (this.last.time - current.time) * bVel < enemy.distance) {
                current = current.prec;
            }
            while (current != null && current.prec != null) {
                current.diffValue = this.lastScan.diff(current, GH);
                if (current.diffValue > worstVal && i < max) {
                    worstVal = current.diffValue;
                    bests.add(current);
                    ++i;
                } else if (current.diffValue < worstVal) {
                    bests.add(current);
                    ++i;
                }
                current = current.prec;
            }
        }
        bests.remove(this.lastScan);
        ScanComparator scanComparator = new ScanComparator();
        Collections.sort(bests, scanComparator);
        return bests;
    }

    public Scan[] speedyMostSimilarScans(Enemy enemy, boolean GH, double firePower) {
        int max = Math.min(Configuration.others > 1 ? 75 : 10, this.scansRecorded - 1);
        double bVel = RobocodeTools.bulletVelocity(firePower);
        if (max <= 0) {
            return null;
        }
        Scan[] bests = new Scan[max];
        if (this.last == null) {
            return null;
        }
        Scan current = this.last.prec;
        while (current != null && (this.last.time - current.time) * bVel < enemy.distance) {
            current = current.prec;
        }
        if (max >= this.scansRecorded - 1) {
            int i = 0;
            while (current != null && current.prec != null) {
                bests[i] = current;
                current = current.prec;
                ++i;
            }
        } else {
            double[] diffs = new double[max];
            int j = 0;
            while (j < max) {
                diffs[j] = Double.POSITIVE_INFINITY;
                ++j;
            }
            while (current != null && current.prec != null) {
                current.diffValue = this.lastScan.diff(current, GH);
                j = max - 1;
                j = max - 1;
                while (j >= 0 && current.diffValue < diffs[j]) {
                    --j;
                }
                if (++j < max) {
                    int k = max - 1;
                    while (k > j) {
                        diffs[k] = diffs[k - 1];
                        bests[k] = bests[k - 1];
                        --k;
                    }
                    diffs[j] = current.diffValue;
                    bests[j] = current;
                }
                current = current.prec;
            }
        }
        return bests;
    }

    public Scan[][] speedyMostSimilarScansVG(Enemy enemy, double firePower) {
        int maxNoGH = Math.min(Configuration.others > 1 ? 75 : 10, this.scansRecorded - 1);
        int maxGH = Math.min(Configuration.others > 1 ? 75 : 200, this.scansRecorded - 1);
        int max = Math.max(maxNoGH, maxGH);
        double bVel = RobocodeTools.bulletVelocity(firePower);
        if (max <= 0) {
            return null;
        }
        Scan[][] bests = new Scan[2][max];
        if (this.last == null) {
            return null;
        }
        Scan current = this.last.prec;
        while (current != null && (this.last.time - current.time) * bVel < enemy.distance) {
            current = current.prec;
        }
        if (max >= this.scansRecorded - 1) {
            int i = 0;
            while (current != null && current.prec != null) {
                bests[0][i] = current;
                bests[1][i] = current;
                current = current.prec;
                ++i;
            }
        } else {
            double[][] diffs = new double[2][max];
            int j = 0;
            while (j < max) {
                diffs[0][j] = Double.POSITIVE_INFINITY;
                diffs[1][j] = Double.POSITIVE_INFINITY;
                ++j;
            }
            while (current != null && current.prec != null) {
                current.projection = null;
                current.diffValue = this.lastScan.diff(current, false);
                j = maxNoGH - 1;
                j = maxNoGH - 1;
                while (j >= 0 && current.diffValue < diffs[0][j]) {
                    --j;
                }
                if (++j < maxNoGH) {
                    int k = maxNoGH - 1;
                    while (k > j) {
                        diffs[0][k] = diffs[0][k - 1];
                        bests[0][k] = bests[0][k - 1];
                        --k;
                    }
                    diffs[0][j] = current.diffValue;
                    bests[0][j] = current;
                }
                current.diffValueGH = current.diffValue + ScanStore.sqr(this.lastScan.gunHeat - current.gunHeat) * 100.0;
                int l = maxGH - 1;
                l = maxGH - 1;
                while (l >= 0 && current.diffValueGH < diffs[1][l]) {
                    --l;
                }
                if (++l < maxGH) {
                    int k = maxGH - 1;
                    while (k > l) {
                        diffs[1][k] = diffs[1][k - 1];
                        bests[1][k] = bests[1][k - 1];
                        --k;
                    }
                    diffs[1][l] = current.diffValueGH;
                    bests[1][l] = current;
                }
                current = current.prec;
            }
        }
        return bests;
    }

    public ArrayList<Scan>[] mostSimilarScansVG(Enemy enemy) {
        int max = Configuration.others > 1 ? 75 : 10;
        ArrayList<Scan> bests = new ArrayList<Scan>(max);
        ArrayList<Scan> bestsGH = new ArrayList<Scan>(max);
        ArrayList[] res = new ArrayList[]{bests, bestsGH};
        if (this.last == null) {
            return res;
        }
        if (max >= this.scansRecorded) {
            Scan current = this.last.prec;
            while (current != null && current.prec != null) {
                bests.add(current);
                current = current.prec;
            }
        } else {
            double worstVal = 0.0;
            double worstValGH = 0.0;
            Scan current = this.last.prec;
            int i = 0;
            int iGH = 0;
            while (current != null && current.prec != null) {
                current.diffValue = this.lastScan.diff(current, false);
                current.diffValueGH = this.lastScan.diff(current, true);
                if (current.diffValue > worstVal && i < max) {
                    worstVal = current.diffValue;
                    bests.add(current);
                    ++i;
                } else if (current.diffValue < worstVal) {
                    bests.add(current);
                    ++i;
                }
                if (current.diffValueGH > worstValGH && iGH < max) {
                    worstValGH = current.diffValueGH;
                    bestsGH.add(current);
                    ++i;
                } else if (current.diffValueGH < worstValGH) {
                    bestsGH.add(current);
                    ++i;
                }
                current = current.prec;
            }
        }
        bests.remove(this.lastScan);
        ScanComparator scanComparator = new ScanComparator();
        Collections.sort(bests, scanComparator);
        bestsGH.remove(this.lastScan);
        Collections.sort(bestsGH, scanComparator);
        return res;
    }

    public void initRound() {
        this.locations = new XPoint[130];
        this.firstScan = -1.0;
        this.trim();
        this.cumul = new double[3000];
        Arrays.fill(this.cumul, Double.POSITIVE_INFINITY);
    }

    public void endRound() {
        this.recordDeath();
    }

    private void shiftLocations(int offset) {
        int i = 129 - offset - 1;
        while (i >= 0) {
            this.locations[i + offset] = this.locations[i];
            --i;
        }
    }

    private void extrapolateLocations(int offset) {
        if (offset == 1) {
            return;
        }
        if (offset > this.locations.length - 1 || this.locations[offset] == null) {
            this.recordDeath();
            return;
        }
        double x = this.locations[offset].x;
        double y = this.locations[offset].y;
        double deltaX = (this.locations[0].x - this.locations[offset].x) / (double)offset;
        double deltaY = (this.locations[0].y - this.locations[offset].y) / (double)offset;
        int i = offset - 1;
        while (i > 0) {
            this.locations[i] = new XPoint(x + deltaX * (double)(offset - i), y + deltaY * (double)(offset - i));
            this.lastXPoint = this.lastXPoint.next = new XPoint(x + deltaX * (double)(offset - i), y + deltaY * (double)(offset - i));
            ++this.locationIndex;
            --i;
        }
        if (ScanStore.sqr(deltaX) + ScanStore.sqr(deltaY) > 81.0) {
            RobocodeTools.log(String.valueOf(offset) + "|" + Math.sqrt(ScanStore.sqr(deltaX) + ScanStore.sqr(deltaY)) + "|" + this.locations[offset].distance(this.locations[0]) / (double)offset);
        }
    }

    public Point2D.Double projectMovement(Scan scan, Point2D.Double gun, Point2D.Double targetLocation, double velocity, int delay2) {
        Scan startScan = this.last;
        double angle = Utils.normalRelativeAngle((double)(startScan.heading - scan.heading + (RobocodeTools.sign(startScan.velocity * scan.velocity) >= 0 ? 0.0 : Math.PI)));
        XPoint current = scan.point;
        Point2D.Double location = new XPoint();
        location.x = targetLocation.x;
        location.y = targetLocation.y;
        Point2D.Double startLocation = new Point2D.Double(targetLocation.x, targetLocation.y);
        XPoint prec = null;
        XPoint tmp = null;
        int travelTime = 0;
        int delay = delay2 + 2;
        while ((double)(travelTime - delay) * velocity <= location.distance(gun) && current != null) {
            if (current.equals(new DeathPoint())) {
                return null;
            }
            if (prec == null) {
                prec = current;
            }
            if (tmp != null && tmp.distance(current) > 12.0) {
                return null;
            }
            tmp = current;
            Force vector = new Force(prec, current);
            vector.rotate(angle);
            vector.translateTo(startLocation);
            location = vector.end;
            ++travelTime;
            if (!Configuration.BF.contains(location)) {
                return null;
            }
            current = current.next;
        }
        if (travelTime == 0) {
            return null;
        }
        if ((double)(travelTime - delay) * velocity < location.distance(gun)) {
            return null;
        }
        return location;
    }

    public Point2D.Double speedyProjectMovement(Scan scan, double velocity, int delay, Point2D.Double gun) {
        double x = 0.0;
        DeathPoint death = new DeathPoint();
        double y = 0.0;
        double distance = 0.0;
        double angle = 0.0;
        double bft = 0.0;
        Scan current = scan;
        int i = 0;
        while (i < 2) {
            distance = current.point.distance(scan.point);
            angle = Utils.normalRelativeAngle((double)(this.lastScan.correctedHeading + Math.atan2(current.point.x - scan.point.x, current.point.y - scan.point.y) - scan.correctedHeading));
            x = this.lastXPoint.x + Math.sin(angle) * distance;
            y = this.lastXPoint.y + Math.cos(angle) * distance;
            distance = gun.distance(x, y);
            bft = distance / velocity;
            if (current.next != null) {
                while (current.next != null && current.time < current.next.time && current.time - scan.time <= bft + (double)delay && !current.point.equals(death)) {
                    current = current.next;
                }
            }
            if (current.next == null || current.time > current.next.time || !Configuration.BF.contains(x, y) || current.time - scan.time < bft + (double)delay || bft == 0.0 || current.point.equals(death)) {
                return null;
            }
            ++i;
        }
        return new Point2D.Double(x, y);
    }

    public Point2D.Double speedyProjectMovement2(Scan scan, double velocity, int delay2, Point2D.Double gun) {
        double x = 0.0;
        DeathPoint death = new DeathPoint();
        double y = 0.0;
        double distance = 0.0;
        double angle = 0.0;
        double bft = 0.0;
        Scan current = scan;
        int delay = delay2 + 2;
        double angle2 = Utils.normalRelativeAngle((double)(this.lastScan.heading - scan.heading + (RobocodeTools.sign(this.lastScan.velocity * scan.velocity) >= 0 ? 0.0 : Math.PI)));
        distance = current.point.distance(scan.point);
        angle = Utils.normalRelativeAngle((double)(angle2 + Math.atan2(current.point.x - scan.point.x, current.point.y - scan.point.y)));
        x = this.lastXPoint.x + Math.sin(angle) * distance;
        y = this.lastXPoint.y + Math.cos(angle) * distance;
        distance = gun.distance(x, y);
        bft = distance / velocity;
        if (current.next != null) {
            while (current.next != null && current.time < current.next.time && current.time - scan.time <= bft + (double)delay && !current.point.equals(death) && Configuration.BF.contains(x, y)) {
                distance = current.point.distance(scan.point);
                angle = angle2 + Math.atan2(current.point.x - scan.point.x, current.point.y - scan.point.y);
                x = this.lastXPoint.x + Math.sin(angle) * distance;
                y = this.lastXPoint.y + Math.cos(angle) * distance;
                distance = gun.distance(x, y);
                bft = distance / velocity;
                current = current.next;
            }
        }
        if (current.next == null || current.time > current.next.time || !Configuration.BF.contains(x, y) || current.time - scan.time < bft + (double)delay || bft == 0.0 || current.point.equals(death)) {
            return null;
        }
        return new Point2D.Double(x, y);
    }

    public void trim() {
        while (this.scansRecorded > 30000) {
            this.first = this.first.next;
            this.first.prec = null;
            --this.scansRecorded;
        }
        if (this.first != null && this.first.positionIndex - this.locationOffset > 0) {
            int toRemove = this.first.positionIndex - this.locationOffset;
            RobocodeTools.log("Trim " + this.name + " " + toRemove);
            while (toRemove > 0) {
                this.firstXPoint = this.firstXPoint.next;
                --toRemove;
            }
            this.locationOffset = this.first.positionIndex;
        }
    }

    public void recordDeath() {
        if (this.lastXPoint == null) {
            return;
        }
        this.lastXPoint = this.lastXPoint.next = new DeathPoint();
        ++this.locationIndex;
    }

    private static final double sqr(double val) {
        return val * val;
    }
}

