/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.radar;

import florent.XSeries.Configuration;
import florent.XSeries.gun.TargetSelector;
import florent.XSeries.movement.wavesurfing.EnemyWave;
import florent.XSeries.radar.Enemy;
import florent.XSeries.radar.EnemyBuilder;
import florent.XSeries.radar.EnemyTracker;
import florent.XSeries.radar.PersistantData;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.Pluggable;
import florent.XSeries.utils.RobocodeTools;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tracker
implements Pluggable,
EnemyTracker {
    private ConcurrentHashMap<String, PersistantData> persistantData;
    private String[] names;
    private ConcurrentHashMap<String, Enemy> enemies = new ConcurrentHashMap();
    private ArrayList<EnemyBuilder> builders;
    private HashSet<String> deadBots;
    private ArrayList<Enemy> teammates;
    private static Xmen me;
    public int others;
    private int nameIndex;
    private static Tracker instance;

    private Tracker() {
        this.persistantData = new ConcurrentHashMap();
        this.builders = new ArrayList();
        this.deadBots = new HashSet();
        this.teammates = new ArrayList();
        EnemyWave.initClass((AdvancedRobot)me);
        Enemy.me = me;
        this.others = me.getOthers();
    }

    public static Tracker getInstance() {
        if (instance == null) {
            instance = new Tracker();
        }
        return instance;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        String name = e.getName();
        if (me.isTeammate(name)) {
            return;
        }
        if (!this.persistantData.containsKey(name) || !this.persistantData.get((Object)name).init) {
            this.getData(name).onScannedRobot(e);
        }
        this.getEnemy(name).onScannedRobot(e);
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        this.deadBots.add(e.getName());
        if (this.others == 1) {
            return;
        }
        RobocodeTools.log("removing " + e.getName());
        Enemy enemy = this.enemies.remove(e.getName());
        if (enemy != null) {
            this.teammates.remove(enemy);
        }
        this.others = me.getOthers();
        RobocodeTools.log("enemies " + me.getEnmiesAlive());
    }

    @Override
    public void onHitWall(HitWallEvent e) {
    }

    @Override
    public void onHitRobot(HitRobotEvent e) {
        this.getEnemy(e.getName()).onHitRobot(e);
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        this.getEnemy(e.getName()).onHitByBullet(e);
    }

    @Override
    public void onBulletMissed(BulletMissedEvent e) {
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.getEnemy(e.getHitBullet().getName()).onBulletHitBullet(e);
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        this.getEnemy(e.getName()).onBulletHit(e);
    }

    @Override
    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    @Override
    public void onPaint(Graphics2D g) {
        Iterator<Enemy> itEnemy = this.enemies.values().iterator();
        while (itEnemy.hasNext()) {
            itEnemy.next().onPaint(g);
        }
    }

    @Override
    public void onWin(WinEvent e) {
    }

    @Override
    public void onDeath(DeathEvent e) {
    }

    @Override
    public void onMainLoop() {
        Enemy.newTickClass();
        for (Enemy enemy : this.enemies.values()) {
            if ((double)me.getTime() - enemy.lastScan > 18.0 && enemy.isSkyClear()) {
                this.enemies.remove(enemy.name);
                RobocodeTools.log("removing out of date " + enemy.name);
                continue;
            }
            enemy.onMainLoop();
            enemy.closestIsMe = this.closest(enemy);
            enemy.target = this.closestEnemy(enemy);
        }
    }

    @Override
    public void initRound() {
        this.enemies.clear();
        this.deadBots.clear();
        this.teammates.clear();
        this.others = me.getOthers();
    }

    @Override
    public void endRound() {
    }

    @Override
    public ConcurrentHashMap<String, Enemy> getEnemies() {
        return this.enemies;
    }

    public static void setMe(Xmen me) {
        Tracker.me = me;
    }

    public Enemy getEnemy(String key) {
        Enemy enemy;
        if (!this.enemies.containsKey(key)) {
            enemy = new Enemy(me, key, this.getData(key));
            if (!this.deadBots.contains(key)) {
                this.enemies.put(key, enemy);
                if (me.isTeammate(key)) {
                    this.teammates.add(enemy);
                }
            }
            int i = 0;
            while (i < this.builders.size()) {
                this.builders.get(i).onEnemyCreation(enemy);
                ++i;
            }
        } else {
            enemy = this.enemies.get(key);
        }
        return enemy;
    }

    public PersistantData getData(String key) {
        PersistantData data;
        if (!this.persistantData.containsKey(key)) {
            data = new PersistantData(key);
            if (!this.deadBots.contains(key)) {
                this.persistantData.put(key, data);
            }
        } else {
            data = this.persistantData.get(key);
        }
        return data;
    }

    public void addBuilder(EnemyBuilder builder) {
        this.builders.add(builder);
    }

    public void removeBuilder(EnemyBuilder builder) {
        this.builders.remove(builder);
    }

    public boolean isDead(Enemy enemy) {
        return this.deadBots.contains(enemy.name);
    }

    public boolean isDead(String name) {
        return this.deadBots.contains(name);
    }

    public boolean endGame() {
        if (me.getEnmiesAlive() != 1 || this.enemies.size() == 0) {
            return false;
        }
        Enemy enemy = this.enemies.values().iterator().next();
        return enemy.energy == 0.0 && enemy.velocity == 0.0 && enemy.isSkyClear();
    }

    public boolean closest(Enemy enemy) {
        if (me.isTeammate(enemy.name)) {
            return false;
        }
        Enemy target = TargetSelector.getInstance(me, Tracker.getInstance()).getTarget();
        if (target != null && target.equals(enemy)) {
            return true;
        }
        double distance = enemy.distance;
        for (Enemy current : this.enemies.values()) {
            if (Configuration.team && !me.isTeammate(current.name) || !(current.location.distance(enemy.location) < distance - 50.0) || current.equals(enemy)) continue;
            return false;
        }
        return true;
    }

    public Enemy closestEnemy(Enemy enemy) {
        if (!Configuration.team) {
            double dist = enemy.distance;
            Enemy best = null;
            for (Enemy current : this.enemies.values()) {
                if (current.name.equals(enemy.name) || !(current.location.distance(enemy.location) < dist)) continue;
                best = current;
                dist = current.location.distance(enemy.location);
            }
            return best;
        }
        double dist = enemy.distance;
        Enemy best = null;
        if (me.isTeammate(enemy.name)) {
            for (Enemy current : this.enemies.values()) {
                if (current.name.equals(enemy.name) || me.isTeammate(current.name) || !(current.location.distance(enemy.location) < dist)) continue;
                best = current;
                dist = current.location.distance(enemy.location);
            }
        } else {
            for (Enemy current : this.enemies.values()) {
                if (current.name.equals(enemy.name) || !me.isTeammate(current.name) || !(current.location.distance(enemy.location) < dist)) continue;
                best = current;
                dist = current.location.distance(enemy.location);
            }
        }
        return best;
    }

    public Point2D.Double[] getTeammatesLocations() {
        if (me.getTeammates() == null) {
            return null;
        }
        Point2D.Double[] locations = new Point2D.Double[me.getTeammates().length];
        int i = 0;
        for (Enemy enemy : this.enemies.values()) {
            if (!me.isTeammate(enemy.name)) continue;
            locations[i] = new Point2D.Double(enemy.location.x, enemy.location.y);
            ++i;
        }
        return locations;
    }

    public Point2D.Double[] getTeamLocations() {
        if (me.getTeammates() == null) {
            return null;
        }
        ArrayList<Point2D.Double> locations = new ArrayList<Point2D.Double>();
        locations.add(new Point2D.Double(me.getX(), me.getY()));
        for (Enemy enemy : this.enemies.values()) {
            if (!me.isTeammate(enemy.name)) continue;
            locations.add(new Point2D.Double(enemy.location.x, enemy.location.y));
        }
        Point2D.Double[] locs = new Point2D.Double[locations.size()];
        return locations.toArray(locs);
    }

    private int getRealOthers() {
        if (Configuration.team) {
            int friends = me.getTeammates() != null ? me.getTeammates().length : 0;
            return me.getOthers() - friends;
        }
        return me.getOthers();
    }

    public ArrayList<EnemyDistance> enemiesDistance() {
        Point2D.Double[] locs = this.getTeamLocations();
        Enemy[] en = new Enemy[me.getOthers()];
        double[] dist = new double[me.getOthers()];
        ArrayList<EnemyDistance> list = new ArrayList<EnemyDistance>();
        int i = 0;
        for (Enemy enemy : this.enemies.values()) {
            if (me.isTeammate(enemy.name)) continue;
            en[i] = enemy;
            dist[i] = 0.0;
            int j = 0;
            while (j < locs.length) {
                int n = i;
                dist[n] = dist[n] + enemy.location.distance(locs[j]);
                ++j;
            }
            list.add(new EnemyDistance(dist[i], en[i]));
            ++i;
        }
        Collections.sort(list);
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EnemyDistance
    implements Comparable<EnemyDistance> {
        public Enemy enemy;
        public double distance;

        @Override
        public int compareTo(EnemyDistance arg0) {
            return (int)(this.distance - arg0.distance);
        }

        public EnemyDistance(double distance, Enemy enemy) {
            this.distance = distance;
            this.enemy = enemy;
        }

        public String toString() {
            return String.valueOf(this.enemy.name) + " " + this.distance;
        }
    }
}

