/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.team;

import florent.XSeries.team.TeamMessage;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import java.awt.geom.Point2D;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class TeamScan
extends TeamMessage {
    private static final long serialVersionUID = 948616002704185074L;
    private double radarX;
    private double radarY;
    private double radarHeading;
    private double scanBearing;
    private double scanDistance;
    private double scanEnergy;
    private String scanName;
    private double scanHeading;
    private double scanVelocity;
    private long scanTime;

    public TeamScan(ScannedRobotEvent e, double x, double y, double heading) {
        this.scanBearing = e.getBearingRadians();
        this.scanDistance = e.getDistance();
        this.scanEnergy = e.getEnergy();
        this.scanName = e.getName();
        this.scanHeading = e.getHeadingRadians();
        this.scanVelocity = e.getVelocity();
        this.scanTime = e.getTime();
        this.radarX = x;
        this.radarY = y;
        this.radarHeading = heading;
    }

    public void executeMessage(Xmen me) {
        Point2D.Double myLocation = new Point2D.Double(me.getX(), me.getY());
        Point2D.Double targetLocation = new Point2D.Double();
        double absoluteBearing = this.radarHeading + this.scanBearing;
        targetLocation.x = this.radarX + Math.sin(absoluteBearing) * this.scanDistance;
        targetLocation.y = this.radarY + Math.cos(absoluteBearing) * this.scanDistance;
        double bearing = Utils.normalRelativeAngle((double)(RobocodeTools.absoluteBearing(myLocation, targetLocation) - me.getHeadingRadians()));
        double distance = myLocation.distance(targetLocation);
        ScannedRobotEvent fakeScan = new ScannedRobotEvent(this.scanName, this.scanEnergy, bearing, distance, this.scanHeading, this.scanVelocity);
        fakeScan.setTime(this.scanTime);
        me.onScannedRobot(fakeScan);
    }
}

