/*
 * Decompiled with CFR 0.152.
 */
package florent.stats;

import florent.stats.StatData;

public class ComplexStatData
extends StatData {
    private String key;
    private int values;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private double average;
    private double sum;
    public double factor = 1.0;

    public ComplexStatData(String key) {
        this.key = key;
    }

    public void record(double val) {
        ++this.values;
        if (this.min > val) {
            this.min = val;
        }
        if (this.max < val) {
            this.max = val;
        }
        this.average = (this.average * (double)(this.values - 1) + val) / (double)this.values;
        this.sum += val;
    }

    public String toString() {
        return String.valueOf(this.key) + ":" + this.min + "/" + this.average + "/" + this.max + "(" + this.values + ")" + this.sum / this.factor * 100.0;
    }
}

