/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.GunInstruction;
import shrub.GunPhysics;
import shrub.Heading;
import shrub.InterceptSolution;
import shrub.Location;
import shrub.MoveHistory;
import shrub.PredictorAPI;
import shrub.TrackerAPI;

public class GunController {
    private int mMode = 0;
    private long mTimeNow = 0L;
    private Location mGunLocn = Location.ZERO_ZERO;
    private Heading mGunHdng = Heading.ZERO;
    private double mMaxPower = 3.0;
    private double mMinPower = 0.1;
    private TrackerAPI mTrackerRef = null;
    private PredictorAPI mCLPredictor = null;
    private PredictorAPI mBHPredictor = null;
    private PredictorAPI mCPPredictor = null;
    private PredictorAPI mPHPredictor = null;
    private static final NumberFormat dp2 = NumberFormat.getInstance();
    private final GunPhysics mGunPhysics = GunPhysics.getInstance();
    private static GunController THE_INSTANCE = new GunController();

    private GunController() {
    }

    public static GunController getInstance() {
        return THE_INSTANCE;
    }

    public void SetTrackerRef(TrackerAPI trackerRef) {
        this.mTrackerRef = trackerRef;
    }

    public void SetCLPredictor(PredictorAPI predictorRef) {
        this.mCLPredictor = predictorRef;
    }

    public void SetBHPredictor(PredictorAPI predictorRef) {
        this.mBHPredictor = predictorRef;
    }

    public void SetCPPredictor(PredictorAPI predictorRef) {
        this.mCPPredictor = predictorRef;
    }

    public void SetPHPredictor(PredictorAPI predictorRef) {
        this.mPHPredictor = predictorRef;
    }

    public void SetMode(int newMode) {
        this.mMode = newMode;
    }

    public void SetGunHdng(Heading newGunHdng) {
        this.mGunHdng = newGunHdng;
    }

    public void SetGunLocn(Location gunLocn) {
        this.mGunLocn = gunLocn;
    }

    public void SetMaxPower(double newMaxPower) {
        this.mMaxPower = newMaxPower;
    }

    public void SetMinPower(double newMinPower) {
        this.mMinPower = newMinPower;
    }

    public void SetTime(long newTime) {
        this.mTimeNow = newTime;
    }

    public GunInstruction GenerateInstruction() {
        GunInstruction instruct = GunInstruction.valueOf(GunInstruction.NONE, 0.0);
        if (this.mMode != 0) {
            if (this.mMode == 1) {
                if (this.mGunPhysics.amIReadyToFire()) {
                    instruct = this.CLAutoshoot();
                }
            } else if (this.mMode == 2) {
                if (this.mGunPhysics.amIReadyToFire()) {
                    instruct = this.BHAutoshoot();
                }
            } else if (this.mMode == 3) {
                if (this.mGunPhysics.amIReadyToFire()) {
                    instruct = this.CPAutoshoot();
                }
            } else if (this.mMode == 4) {
                if (this.mGunPhysics.amIReadyToFire()) {
                    instruct = this.PHAutoshoot();
                }
            } else {
                System.out.println("ERROR: Gun.GenerateInstruction(), unexpected mode " + this.mMode);
            }
        }
        return instruct;
    }

    public GunInstruction CLAutoshoot() {
        GunInstruction instruct = GunInstruction.valueOf(GunInstruction.NONE, 0.0);
        if (this.mTrackerRef == null || this.mCLPredictor == null) {
            System.out.println("ERROR : Gun.CLAutoshoot(), tracker/predictor not specified");
        } else {
            this.mTrackerRef.ExtrapolateCurrentTarget(this.mTimeNow);
            double minSpdAllowed = GunPhysics.shotSpdFromPwr(this.mMaxPower);
            double maxSpdAllowed = GunPhysics.shotSpdFromPwr(this.mMinPower);
            MoveHistory targetHist = this.mTrackerRef.GetCurrentTargetHistory();
            InterceptSolution intSoln = this.mCLPredictor.Intercept(minSpdAllowed, maxSpdAllowed, this.mGunLocn, this.mGunHdng, targetHist);
            if (intSoln.mSpeed >= GunPhysics.minLegalSpd() && intSoln.mSpeed <= GunPhysics.maxLegalSpd()) {
                double power = GunPhysics.shotPwrFromSpd(intSoln.mSpeed);
                instruct = GunInstruction.valueOf(GunInstruction.FIRE, power);
            }
        }
        return instruct;
    }

    private GunInstruction BHAutoshoot() {
        GunInstruction instruct = GunInstruction.valueOf(GunInstruction.NONE, 0.0);
        if (this.mTrackerRef == null || this.mBHPredictor == null) {
            System.out.println("ERROR : Gun.BHAutoshoot(), tracker/predictor not specified");
        } else {
            this.mTrackerRef.ExtrapolateCurrentTarget(this.mTimeNow);
            double minSpdAllowed = GunPhysics.shotSpdFromPwr(this.mMaxPower);
            double maxSpdAllowed = GunPhysics.shotSpdFromPwr(this.mMinPower);
            MoveHistory targetHist = this.mTrackerRef.GetCurrentTargetHistory();
            InterceptSolution intSoln = this.mBHPredictor.Intercept(minSpdAllowed, maxSpdAllowed, this.mGunLocn, this.mGunHdng, targetHist);
            if (intSoln.mSpeed >= GunPhysics.minLegalSpd() && intSoln.mSpeed <= GunPhysics.maxLegalSpd()) {
                double power = GunPhysics.shotPwrFromSpd(intSoln.mSpeed);
                instruct = GunInstruction.valueOf(GunInstruction.FIRE, power);
            } else if (intSoln.mBearing < -0.1) {
                instruct = GunInstruction.valueOf(GunInstruction.LEFT, -1.0 * intSoln.mBearing);
            } else if (intSoln.mBearing > 0.1) {
                instruct = GunInstruction.valueOf(GunInstruction.RIGHT, intSoln.mBearing);
            }
        }
        return instruct;
    }

    private GunInstruction CPAutoshoot() {
        GunInstruction instruct = GunInstruction.valueOf(GunInstruction.NONE, 0.0);
        if (this.mTrackerRef == null || this.mCPPredictor == null) {
            System.out.println("ERROR : Gun.CPAutoshoot(), tracker/predictor not specified");
        } else {
            this.mTrackerRef.ExtrapolateCurrentTarget(this.mTimeNow);
            double minSpdAllowed = GunPhysics.shotSpdFromPwr(this.mMaxPower);
            double maxSpdAllowed = GunPhysics.shotSpdFromPwr(this.mMinPower);
            MoveHistory targetHist = this.mTrackerRef.GetCurrentTargetHistory();
            InterceptSolution intSoln = this.mCPPredictor.Intercept(minSpdAllowed, maxSpdAllowed, this.mGunLocn, this.mGunHdng, targetHist);
            if (intSoln.mSpeed >= GunPhysics.minLegalSpd() && intSoln.mSpeed <= GunPhysics.maxLegalSpd()) {
                double power = GunPhysics.shotPwrFromSpd(intSoln.mSpeed);
                instruct = GunInstruction.valueOf(GunInstruction.FIRE, power);
            } else if (intSoln.mBearing < 0.0) {
                instruct = GunInstruction.valueOf(GunInstruction.LEFT, intSoln.mBearing);
            } else if (intSoln.mBearing > 0.0) {
                instruct = GunInstruction.valueOf(GunInstruction.RIGHT, intSoln.mBearing);
            }
        }
        return instruct;
    }

    private GunInstruction PHAutoshoot() {
        GunInstruction instruct = GunInstruction.valueOf(GunInstruction.NONE, 0.0);
        if (this.mTrackerRef == null || this.mPHPredictor == null) {
            System.out.println("ERROR : Gun.PHAutoshoot(), tracker/predictor not specified");
        } else {
            this.mTrackerRef.ExtrapolateCurrentTarget(this.mTimeNow);
            double minSpdAllowed = GunPhysics.shotSpdFromPwr(this.mMaxPower);
            double maxSpdAllowed = GunPhysics.shotSpdFromPwr(this.mMinPower);
            MoveHistory targetHist = this.mTrackerRef.GetCurrentTargetHistory();
            InterceptSolution intSoln = this.mPHPredictor.Intercept(minSpdAllowed, maxSpdAllowed, this.mGunLocn, this.mGunHdng, targetHist);
            if (intSoln.mSpeed >= GunPhysics.minLegalSpd() && intSoln.mSpeed <= GunPhysics.maxLegalSpd()) {
                double power = GunPhysics.shotPwrFromSpd(intSoln.mSpeed);
                instruct = GunInstruction.valueOf(GunInstruction.FIRE, power);
            } else if (intSoln.mBearing < -0.1) {
                instruct = GunInstruction.valueOf(GunInstruction.LEFT, -1.0 * intSoln.mBearing);
            } else if (intSoln.mBearing > 0.1) {
                instruct = GunInstruction.valueOf(GunInstruction.RIGHT, intSoln.mBearing);
            }
        }
        return instruct;
    }

    public void Print() {
        System.out.println("----- Gun -----");
        System.out.println("mMode: " + this.mMode);
        System.out.println("mGunLocn: " + this.mGunLocn.toString());
        System.out.println("mGunHdng: " + this.mGunHdng.Get());
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

