/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.MoveHistory;
import shrub.PCalculator;

public class TargetPData {
    private final MoveHistory mHistoryRef;
    private final String mName;
    private final int mMinPeriod;
    private final int mPeriodStep;
    private final int mNumPeriods;
    private double mValueThreshold = 100.0;
    private double[] mPeriodData = null;
    private int mCurrentIndex = 0;
    private final boolean mIsOkay;
    private static NumberFormat dp2 = NumberFormat.getInstance();

    public static TargetPData getInstance(String name, MoveHistory historyRef, int minPeriod, int periodStep, int numPeriods, double valueThreshold) {
        TargetPData answer = new TargetPData(name, historyRef, minPeriod, periodStep, numPeriods, valueThreshold);
        return answer;
    }

    private TargetPData(String name, MoveHistory historyRef, int minPeriod, int periodStep, int numPeriods, double valueThreshold) {
        if (historyRef == null) {
            System.out.println("ERROR: TargetPData constructor, null ref");
            this.mIsOkay = false;
            this.mName = "";
            this.mHistoryRef = null;
            this.mMinPeriod = -1;
            this.mPeriodStep = -1;
            this.mNumPeriods = -1;
            this.mValueThreshold = -1.0;
        } else {
            this.mIsOkay = true;
            this.mName = name;
            this.mHistoryRef = historyRef;
            this.mMinPeriod = minPeriod;
            this.mPeriodStep = periodStep;
            this.mNumPeriods = numPeriods;
            this.mValueThreshold = valueThreshold;
            this.InitialiseArrayData();
        }
    }

    private void InitialiseArrayData() {
        this.mPeriodData = new double[this.mNumPeriods];
        for (int index = 0; index < this.mNumPeriods; ++index) {
            this.mPeriodData[index] = 999999.0;
        }
        this.mCurrentIndex = 0;
    }

    public void SetValueThreshold(double newValue) {
        this.mValueThreshold = newValue;
    }

    public final String GetName() {
        return this.mName;
    }

    public final boolean IsOkay() {
        return this.mIsOkay;
    }

    public void CalcNextPeriod() {
        ++this.mCurrentIndex;
        if (this.mCurrentIndex >= this.mNumPeriods) {
            this.mCurrentIndex = 0;
        }
        int period = this.PeriodFromIndex(this.mCurrentIndex);
        double pValue = 999999.0;
        PCalculator pCalc = PCalculator.getInstance(this.mHistoryRef, period);
        if (pCalc.IsOkay()) {
            pValue = pCalc.Evaluate();
        }
        this.mPeriodData[this.mCurrentIndex] = pValue;
    }

    public final int GetBestPeriod() {
        int answer = -1;
        if (this.mPeriodData != null) {
            double thisValue = 999999.0;
            double minValueSoFar = 999999.0;
            int minIndexSoFar = -1;
            for (int index = this.mNumPeriods - 1; index >= 0; --index) {
                thisValue = this.mPeriodData[index];
                if (!(thisValue <= minValueSoFar)) continue;
                minValueSoFar = thisValue;
                minIndexSoFar = index;
            }
            if (minValueSoFar < this.mValueThreshold) {
                answer = this.PeriodFromIndex(minIndexSoFar);
            }
        } else {
            System.out.println("ERROR: TargetPData.GetBestPeriod(), data array does not exist");
        }
        return answer;
    }

    public final int PeriodFromIndex(int index) {
        int period = this.mMinPeriod + this.mPeriodStep * index;
        return period;
    }

    public final int IndexFromPeriod(int period) {
        int index = (period - this.mMinPeriod) / this.mPeriodStep;
        return index;
    }

    public final double GetValueForPeriod(int period) {
        int index = this.IndexFromPeriod(period);
        double pVal = this.GetValueAtIndex(index);
        return pVal;
    }

    public final double GetValueAtIndex(int index) {
        double pVal = this.mPeriodData[index];
        return pVal;
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

