/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.DangerPrediction.Search;

import java.util.Random;
import rdt.AgentSmith.DangerPrediction.CommandSequence;
import rdt.AgentSmith.DangerPrediction.ICommandSequenceEvaluator;
import rdt.AgentSmith.DangerPrediction.IMovementSearch;
import rdt.AgentSmith.DangerPrediction.MovementCommand;
import rdt.AgentSmith.Profiling.Profiler;

public class RHEA
implements IMovementSearch {
    private CommandSequence _bestSequence;
    private boolean _reset = true;
    private boolean _rolled = false;
    private double _totalFitness;
    private ICommandSequenceEvaluator _evaluator;
    private CommandSequence[] _currentPopulation;
    private CommandSequence[] _nextPopulation;
    private Random _random = new Random();
    private int _requiredActiveSequenceLength;

    public RHEA(ICommandSequenceEvaluator evaluator, int sequenceLength) {
        this._evaluator = evaluator;
        int populationSize = 61;
        this._currentPopulation = new CommandSequence[populationSize];
        this._nextPopulation = new CommandSequence[populationSize];
        for (int index = 0; index < populationSize; ++index) {
            this._currentPopulation[index] = new CommandSequence(sequenceLength);
            this._nextPopulation[index] = new CommandSequence(sequenceLength);
        }
        this._bestSequence = new CommandSequence(sequenceLength);
    }

    @Override
    public void Reset(int requiredActiveSequenceLength) {
        this._requiredActiveSequenceLength = requiredActiveSequenceLength;
        this._reset = true;
    }

    @Override
    public void RunOneIteration() {
        if (this._reset) {
            this.CreateRandomPopulation(this._requiredActiveSequenceLength);
            this._reset = false;
            this._rolled = false;
        } else {
            if (this._rolled) {
                this.RollPopulation();
                this._rolled = false;
            }
            this.SelectAndMutatePopulation();
        }
        this.EvaluateCurrentPopulation();
    }

    @Override
    public void Roll(int selectedCommand) {
        this._rolled = true;
    }

    @Override
    public int GetBestMovementCommand() {
        return this._bestSequence.Sequence[0];
    }

    private void CreateRandomPopulation(int activeSequenceLength) {
        Profiler.StartScope("CreateRandomPopulation");
        for (int index = 0; index < this._currentPopulation.length; ++index) {
            this.MakeRandomSequence(this._currentPopulation[index], activeSequenceLength);
        }
        Profiler.EndScope();
    }

    private void MakeRandomSequence(CommandSequence sequence, int activeSequenceLength) {
        sequence.ActiveLength = activeSequenceLength;
        for (int index = 0; index < activeSequenceLength; ++index) {
            sequence.Sequence[index] = MovementCommand.Random();
        }
    }

    private void EvaluateCurrentPopulation() {
        Profiler.StartScope("EvaluateCurrentPopulation");
        this._totalFitness = 0.0;
        CommandSequence bestSequence = this._currentPopulation[0];
        for (int index = 0; index < this._currentPopulation.length; ++index) {
            CommandSequence sequence = this._currentPopulation[index];
            this._evaluator.Evaluate(sequence);
            this._totalFitness += sequence.Fitness;
            if (!(sequence.Fitness < bestSequence.Fitness)) continue;
            bestSequence = sequence;
        }
        this._bestSequence.Copy(bestSequence);
        Profiler.EndScope();
    }

    private void SelectAndMutatePopulation() {
        Profiler.StartScope("SelectAndMutatePopulation");
        this._nextPopulation[0].Copy(this._bestSequence);
        for (int index = 1; index < this._nextPopulation.length; index += 2) {
            this.TournamentSelection(this._nextPopulation[index], this._nextPopulation[index + 1]);
        }
        CommandSequence[] temp = this._currentPopulation;
        this._currentPopulation = this._nextPopulation;
        this._nextPopulation = temp;
        Profiler.EndScope();
    }

    private void TournamentSelection(CommandSequence target0, CommandSequence target1) {
        CommandSequence parent0 = null;
        CommandSequence parent1 = null;
        double rand0 = this._random.nextDouble() * this._totalFitness;
        double rand1 = this._random.nextDouble() * this._totalFitness;
        double fitness = 0.0;
        for (int index = 0; index < this._currentPopulation.length; ++index) {
            CommandSequence sequence = this._currentPopulation[index];
            fitness += sequence.Fitness;
            if (parent0 == null && fitness >= rand0) {
                parent0 = sequence;
                if (parent1 != null) break;
            }
            if (parent1 != null || !(fitness >= rand1)) continue;
            parent1 = sequence;
            if (parent0 != null) break;
        }
        int randCrossover = this._random.nextInt(parent0.ActiveLength - 3) + 1;
        System.arraycopy(parent0.Sequence, 0, target0.Sequence, 0, randCrossover);
        System.arraycopy(parent1.Sequence, 0, target1.Sequence, 0, randCrossover);
        System.arraycopy(parent1.Sequence, randCrossover, target0.Sequence, 0, parent0.ActiveLength - randCrossover);
        System.arraycopy(parent0.Sequence, randCrossover, target1.Sequence, 0, parent1.ActiveLength - randCrossover);
        target0.ActiveLength = parent0.ActiveLength;
        target1.ActiveLength = parent1.ActiveLength;
    }

    private void RollPopulation() {
        Profiler.StartScope("RollPopulation");
        this._bestSequence.Roll(MovementCommand.Random());
        for (int index = 0; index < this._currentPopulation.length; ++index) {
            this._currentPopulation[index].Roll(MovementCommand.Random());
        }
        Profiler.EndScope();
    }
}

