/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Guns.GunImplementations;

import java.awt.geom.Point2D;
import rdt.AgentSmith.Guns.Gun;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.RobotHistory.RobotHistory;
import rdt.AgentSmith.RobotHistory.RobotSnapshot;
import rdt.AgentSmith.Stats.IStats;
import rdt.AgentSmith.Utils.MathUtils;
import robocode.util.Utils;

public class IterativeCircularWithWallStopping
extends Gun {
    public IterativeCircularWithWallStopping(String ownerName, IRobot robot, RobotHistory targetHistory, IStats stats, long firingTickOffset) {
        super(ownerName + " : Iterative Circular with Wall Stopping", robot, targetHistory, stats, firingTickOffset);
    }

    @Override
    public double GetFiringAngle(double sourceX, double sourceY, long firingTick, double bulletVelocity) {
        double predictedY;
        double predictedX;
        block1: {
            double deltaTime = 0.0;
            double myX = sourceX;
            double myY = sourceY;
            RobotSnapshot snapshot = this.GetFiringSnapshot(firingTick);
            double enemyHeading = snapshot.AbsoluteHeading;
            double enemyVelocity = snapshot.VelocityAlongHeading;
            double battleFieldWidth = this._robot.getBattleFieldWidth();
            double battleFieldHeight = this._robot.getBattleFieldHeight();
            predictedX = snapshot.LocationX;
            predictedY = snapshot.LocationY;
            RobotSnapshot prevSnapshot = this.GetFiringSnapshot(firingTick - 1L);
            double enemyHeadingChange = snapshot.AbsoluteHeading - prevSnapshot.AbsoluteHeading;
            do {
                double d;
                deltaTime += 1.0;
                if (!(d * bulletVelocity < Point2D.Double.distance(myX, myY, predictedX, predictedY))) break block1;
                predictedY += Math.cos(enemyHeading) * enemyVelocity;
            } while (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0));
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
        }
        return Utils.normalAbsoluteAngle((double)MathUtils.GetAngle(sourceX, sourceY, predictedX, predictedY));
    }
}

