/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Waves;

import java.util.ArrayList;
import rdt.AgentSmith.IBulletHitBulletEventHandler;
import rdt.AgentSmith.IHitByBulletEventHandler;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.RobotHistory.RobotSnapshot;
import rdt.AgentSmith.Targeting.ITargeting;
import rdt.AgentSmith.Targeting.Target;
import rdt.AgentSmith.Waves.IWaveEventHandler;
import rdt.AgentSmith.Waves.WaveData;
import rdt.AgentSmith.Waves.WaveDebug;
import rdt.AgentSmith.Waves.WaveManagerBase;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;

public class EnemyWaveManager
extends WaveManagerBase
implements IHitByBulletEventHandler,
IBulletHitBulletEventHandler {
    private ITargeting _targeting;

    public EnemyWaveManager(IRobot robot, ITargeting targeting) {
        super(robot, 100);
        this._targeting = targeting;
        this._robot.RegisterForEventHandling(this);
        this._robot.RegisterForEventHandling(this);
        new WaveDebug(robot, this);
    }

    @Override
    public void Update() {
        ArrayList<Target> targets = this._targeting.GetTargets();
        for (int index = 0; index < targets.size(); ++index) {
            Target target = targets.get(index);
            if (!target.Alive || !target.Valid || target.LastTickFired != this._robot.getTime() - 1L) continue;
            RobotSnapshot snapshot = target.RobotHistory.Snapshots.get(1);
            this.FireWave(snapshot.LocationX, snapshot.LocationY, WaveData.eWaveType.Real, target.LastFiredBulletFirepower, snapshot.Tick, target);
        }
        super.Update();
    }

    @Override
    public void OnHitByBulletEvent(HitByBulletEvent eventData) {
        WaveData waveData = this.GetClosestActiveWave(eventData.getBullet().getX(), eventData.getBullet().getY());
        if (waveData == null) {
            return;
        }
        for (int index = 0; index < this._eventHandlers.size(); ++index) {
            ((IWaveEventHandler)this._eventHandlers.get(index)).OnHitByBulletWithWaveEvent(eventData, waveData);
        }
        this.RemoveActiveWave(waveData);
    }

    @Override
    public void OnBulletHitBulletEvent(BulletHitBulletEvent eventData) {
        Bullet enemyBullet = eventData.getBullet().getName().compareTo(this._robot.getName()) == 0 ? eventData.getHitBullet() : eventData.getBullet();
        WaveData waveData = this.GetClosestActiveWave(enemyBullet.getX(), enemyBullet.getY());
        if (waveData == null) {
            return;
        }
        for (int index = 0; index < this._eventHandlers.size(); ++index) {
            ((IWaveEventHandler)this._eventHandlers.get(index)).OnBulletHitBulletWithWaveEvent(eventData, waveData);
        }
        this.RemoveActiveWave(waveData);
    }
}

