/*
 * Decompiled with CFR 0.152.
 */
package labg.shooting;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import labg.shooting.ShootingStrategy;
import labg.util.Enemy;
import labg.util.EvolutionManager;
import labg.util.FriendlyBullet;
import labg.util.Geometry;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class FactoredShootingStrategy
extends ShootingStrategy {
    AdvancedRobot myBot;
    Enemy target;
    EvolutionManager evoMan;
    Vector friendBulls;
    HashMap enemies;
    boolean readyToFire = false;
    boolean fired = false;
    long readyToFireTime = 0L;
    double close = 350.0;
    double medium = 600.0;
    double far = 750.0;

    public FactoredShootingStrategy(AdvancedRobot myBot, Enemy target, EvolutionManager evoMan, HashMap enemies) {
        super(myBot, target, evoMan);
        this.myBot = myBot;
        this.target = target;
        this.evoMan = evoMan;
        this.enemies = enemies;
        this.friendBulls = new Vector();
    }

    public void shoot() {
        double shotPower = 0.0;
        shotPower = this.myBot.getEnergy() < 20.0 ? 0.5 : (this.target.distance <= this.close ? 3.0 : (this.target.distance > this.close && this.target.distance <= this.medium ? 2.0 : 1.0));
        int distIndex = 0;
        distIndex = this.myBot.getEnergy() < 20.0 ? 3 : (this.target.distance <= this.close ? 2 : (this.target.distance > this.close && this.target.distance <= this.medium ? 1 : 0));
        double guessFactor = this.myBot.getOthers() == 1 ? this.target.getBestGuessFactor(distIndex, false) : this.target.getBestGuessFactor(distIndex, true);
        long currTime = this.myBot.getTime() + (long)((int)Math.round(Geometry.getRange(this.myBot.getX(), this.myBot.getY(), this.target.xPos, this.target.yPos) / (20.0 - 3.0 * shotPower)));
        Point2D.Double currPoint = this.target.heading - this.target.prevHeading < 1.0E-4 ? this.target.guessPosition(currTime, guessFactor, 1) : this.target.guessCircularPosition(currTime, guessFactor, 1);
        int i = 0;
        while (i < 5) {
            long prevTime = currTime;
            Point2D.Double prevPoint = currPoint;
            currTime = this.myBot.getTime() + (long)((int)Math.round(Geometry.getRange(this.myBot.getX(), this.myBot.getY(), prevPoint.x, prevPoint.y) / (20.0 - 3.0 * shotPower)));
            currPoint = this.target.heading - this.target.prevHeading < 1.0E-4 ? this.target.guessPosition(currTime, guessFactor, i + 2) : this.target.guessCircularPosition(currTime, guessFactor, i + 2);
            ++i;
        }
        if (currPoint.x < 0.0) {
            currPoint.x = 0.0;
        } else if (currPoint.x > this.myBot.getBattleFieldWidth()) {
            currPoint.x = this.myBot.getBattleFieldWidth();
        }
        if (currPoint.y < 0.0) {
            currPoint.y = 0.0;
        } else if (currPoint.y > this.myBot.getBattleFieldHeight()) {
            currPoint.y = this.myBot.getBattleFieldHeight();
        }
        double gunOffset = this.myBot.getGunHeadingRadians() - (1.5707963267948966 - Math.atan2(currPoint.y - this.myBot.getY(), currPoint.x - this.myBot.getX()));
        this.myBot.setTurnGunLeftRadians(Geometry.normaliseBearing(gunOffset));
        if ((this.myBot.getTime() - this.target.timeLastSeen < 10L || this.myBot.getOthers() == 1 && this.myBot.getTime() - this.target.timeLastSeen < 3L) && this.myBot.getEnergy() > shotPower && this.myBot.getGunHeat() == 0.0 && Math.abs(this.myBot.getGunTurnRemaining()) < 10.0) {
            this.target.shots += 1.0;
            this.readyToFire = false;
            this.target.takenShot = true;
            this.myBot.setFire(shotPower);
            this.fired = true;
        }
        double guessFact = -2.0;
        if (this.fired) {
            this.fired = false;
            int i2 = 0;
            while (i2 < 22) {
                long currTime2 = this.myBot.getTime() + (long)((int)Math.round(Geometry.getRange(this.myBot.getX(), this.myBot.getY(), this.target.xPos, this.target.yPos) / (20.0 - 3.0 * shotPower)));
                Point2D.Double currPoint2 = this.target.heading - this.target.prevHeading < 1.0E-4 ? this.target.guessPosition(currTime2, guessFact, 1) : this.target.guessCircularPosition(currTime2, guessFact, 1);
                int j = 0;
                while (j < 5) {
                    long prevTime2 = currTime2;
                    Point2D.Double prevPoint2 = currPoint2;
                    currTime2 = this.myBot.getTime() + (long)((int)Math.round(Geometry.getRange(this.myBot.getX(), this.myBot.getY(), prevPoint2.x, prevPoint2.y) / (20.0 - 3.0 * shotPower)));
                    currPoint2 = this.target.heading - this.target.prevHeading < 1.0E-4 ? this.target.guessPosition(currTime2, guessFact, j + 2) : this.target.guessCircularPosition(currTime2, guessFact, j + 2);
                    ++j;
                }
                if (currPoint2.x < 0.0) {
                    currPoint2.x = 0.0;
                } else if (currPoint2.x > this.myBot.getBattleFieldWidth()) {
                    currPoint2.x = this.myBot.getBattleFieldWidth();
                }
                if (currPoint2.y < 0.0) {
                    currPoint2.y = 0.0;
                } else if (currPoint2.y > this.myBot.getBattleFieldHeight()) {
                    currPoint2.y = this.myBot.getBattleFieldHeight();
                }
                double bearing = Geometry.absbearing(this.myBot.getX(), this.myBot.getY(), currPoint2.x, currPoint2.y);
                int distRange = 0;
                distRange = this.myBot.getEnergy() < 20.0 ? 3 : (this.target.distance <= this.close ? 2 : (this.target.distance > this.close && this.target.distance <= this.medium ? 1 : 0));
                this.friendBulls.add(new FriendlyBullet(this.target.name, i2, distRange, this.myBot.getX(), this.myBot.getY(), bearing, this.myBot.getTime(), shotPower));
                guessFact += 0.2;
                ++i2;
            }
        }
    }

    public void moveFriendlyBullets() {
        Iterator it = this.friendBulls.iterator();
        while (it.hasNext()) {
            FriendlyBullet b = (FriendlyBullet)it.next();
            String str = b.targetName;
            Enemy en = (Enemy)this.enemies.get(str);
            if (en == null) continue;
            if (this.myBot.getOthers() == 1) {
                if (b.targetWasHit(en.xPos, en.yPos, this.myBot.getTime())) {
                    en.updateStats(b, true, false);
                    try {
                        it.remove();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!b.outOfRange(en.xPos, en.yPos, this.myBot.getTime())) continue;
                en.updateStats(b, false, false);
                try {
                    it.remove();
                }
                catch (Exception e) {}
                continue;
            }
            if (b.targetWasHit(en.xPos, en.yPos, this.myBot.getTime())) {
                en.updateStats(b, true, true);
                try {
                    it.remove();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!b.outOfRange(en.xPos, en.yPos, this.myBot.getTime())) continue;
            en.updateStats(b, false, true);
            try {
                it.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setEnemy(Enemy foe) {
        this.target = foe;
    }

    public Enemy getEnemy() {
        return this.target;
    }

    public void readyToFire(boolean ready, long t) {
        this.readyToFire = ready;
        this.readyToFireTime = t;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onDeath(DeathEvent e) {
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    public void onWin(WinEvent e) {
    }
}

